/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.vanilla.installer.test;

import org.junit.platform.launcher.LauncherInterceptor;
import org.spongepowered.common.applaunch.test.TestGameAccess;
import org.spongepowered.vanilla.installer.test.SpongeTestBoot;

public final class SpongeLauncherInterceptor
implements LauncherInterceptor {
    private final ClassLoader classLoader;

    public SpongeLauncherInterceptor() {
        try {
            this.classLoader = SpongeTestBoot.getGameClassLoader();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T intercept(LauncherInterceptor.Invocation<T> invocation) {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.classLoader);
        try {
            Object object = invocation.proceed();
            return (T)object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    public void close() {
        TestGameAccess.shutdownGame();
    }
}

