/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.vanilla.installer;

import java.io.IOException;
import java.nio.file.Path;
import org.spongepowered.common.applaunch.config.LaunchConfig;
import org.spongepowered.common.applaunch.config.TokenReplacement;
import org.spongepowered.libs.LibraryManager;
import org.spongepowered.vanilla.installer.library.TinyLogger;

public final class Installer {
    private final Path directory;
    private final LibraryManager libraryManager;
    private final LaunchConfig config;

    public Installer(Path directory) throws IOException {
        this.directory = directory;
        this.config = LaunchConfig.load(directory, true);
        TokenReplacement tokens = new TokenReplacement();
        tokens.register("BASE_DIR", directory);
        this.libraryManager = new LibraryManager(TinyLogger.INSTANCE, this.config.checkLibraryHashes(), Path.of(tokens.replace(this.config.librariesDirectory()), new String[0]), this.getClass().getResource("/sponge-libraries.json"));
    }

    public Path getDirectory() {
        return this.directory;
    }

    public LibraryManager getLibraryManager() {
        return this.libraryManager;
    }

    public LaunchConfig getConfig() {
        return this.config;
    }
}

