/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.bootstrap;

import java.lang.module.ModuleReference;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;

public final class FilteringPassthroughClassLoader
extends ClassLoader {
    private final Set<String> filteredPackages = new HashSet<String>();

    FilteringPassthroughClassLoader(ClassLoader parent, Stream<ModuleReference> modules) {
        super(parent);
        modules.forEach(m4 -> this.filteredPackages.addAll(m4.descriptor().packages()));
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (!this.filteredPackages.contains(FilteringPassthroughClassLoader.nameToPackage(name))) {
            return super.loadClass(name, resolve);
        }
        throw new ClassNotFoundException(name);
    }

    private static String nameToPackage(String name) {
        int index = name.lastIndexOf(46);
        if (index == -1 || index == name.length() - 1) {
            return "";
        }
        return name.substring(0, index);
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }
}

