/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.bootstrap;

import java.io.File;
import java.lang.module.Configuration;
import java.lang.module.ModuleFinder;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.spongepowered.bootstrap.FilteringPassthroughClassLoader;
import org.spongepowered.bootstrap.ResourceClassLoader;
import org.spongepowered.bootstrap.dev.DevClasspath;

public abstract class Bootstrap<Jar> {
    public static final boolean DEBUG = Boolean.getBoolean("sponge.bootstrap.debug");

    public abstract String name();

    protected abstract Jar createJar(Path[] var1);

    protected abstract String getModuleName(Jar var1);

    protected abstract ModuleFinder createModuleFinder(Collection<Jar> var1);

    protected boolean filterApplicationModule(Jar jar) {
        return false;
    }

    protected abstract ClassLoader createApplicationClassLoader(Configuration var1, List<ModuleLayer> var2, ClassLoader var3);

    protected abstract void runApplication(ModuleLayer var1) throws Exception;

    public void devBoot(boolean isolated) throws Exception {
        this.boot(DevClasspath.resolve(), isolated);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void boot(List<Path[]> classpath, boolean isolated) throws Exception {
        String resources;
        if (DEBUG) {
            System.out.println("Bootstrapping " + this.name() + " from classloader: " + String.valueOf(this.getClass().getClassLoader()));
            System.out.println("Isolated: " + isolated);
        }
        HashSet<String> moduleNames = new HashSet<String>();
        ArrayList<Path> resourcePaths = new ArrayList<Path>();
        ArrayList<Jar> resourceJars = new ArrayList<Jar>();
        ArrayList<Jar> appJars = new ArrayList<Jar>();
        for (Path[] paths : classpath) {
            Jar jar = this.createJar(paths);
            String name = this.getModuleName(jar);
            if (ModuleLayer.boot().findModule(name).isPresent()) {
                if (!DEBUG) continue;
                System.out.println("Boot: " + name + " " + Bootstrap.formatUnion(paths));
                continue;
            }
            if (this.filterApplicationModule(jar)) {
                if (DEBUG) {
                    System.out.println("Filtered: " + name + " " + Bootstrap.formatUnion(paths));
                }
                resourceJars.add(jar);
                resourcePaths.addAll(Arrays.asList(paths));
                continue;
            }
            if (!moduleNames.add(name)) {
                if (DEBUG) {
                    System.out.println("Duplicate: " + name + " " + Bootstrap.formatUnion(paths));
                }
                resourceJars.add(jar);
                resourcePaths.addAll(Arrays.asList(paths));
                continue;
            }
            if (DEBUG) {
                System.out.println("App: " + name + " " + Bootstrap.formatUnion(paths));
            }
            appJars.add(jar);
        }
        ModuleFinder finder = this.createModuleFinder(appJars);
        Configuration config = ModuleLayer.boot().configuration().resolveAndBind(finder, ModuleFinder.ofSystem(), moduleNames);
        List<ModuleLayer> parentLayers = List.of(ModuleLayer.boot());
        ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader parentLoader = ClassLoader.getPlatformClassLoader();
        if (!isolated && (resources = System.getProperty("sponge.resources")) != null) {
            ArrayList<Jar> spongeJars = new ArrayList<Jar>();
            for (String entry : resources.split(File.pathSeparator)) {
                Path[] paths = (Path[])Stream.of(entry.split("&")).map(x$0 -> Path.of(x$0, new String[0])).toArray(Path[]::new);
                spongeJars.add(this.createJar(paths));
            }
            ModuleFinder spongeFinder = this.createModuleFinder(spongeJars);
            ModuleFinder resourceFinder = this.createModuleFinder(resourceJars);
            parentLoader = new FilteringPassthroughClassLoader(contextLoader, Stream.concat(spongeFinder.findAll().stream(), resourceFinder.findAll().stream()));
        }
        if (!resourcePaths.isEmpty()) {
            URL[] urls = new URL[resourcePaths.size()];
            for (int i = 0; i < urls.length; ++i) {
                urls[i] = ((Path)resourcePaths.get(i)).toUri().toURL();
            }
            parentLoader = new ResourceClassLoader("BOOTSTRAP-RESOURCES", urls, parentLoader);
        }
        ClassLoader loader = this.createApplicationClassLoader(config, parentLayers, parentLoader);
        ModuleLayer layer = ModuleLayer.boot().defineModules(config, moduleName -> loader);
        try {
            Thread.currentThread().setContextClassLoader(loader);
            if (DEBUG) {
                System.out.println("Starting application ...");
            }
            this.runApplication(layer);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextLoader);
        }
    }

    public static String formatUnion(Path[] paths) {
        return Arrays.stream(paths).map(Path::toString).collect(Collectors.joining("&"));
    }
}

