/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.plugin.builtin.jvm.locator;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.spongepowered.plugin.Environment;
import org.spongepowered.plugin.blackboard.Keys;
import org.spongepowered.plugin.builtin.jvm.JVMPluginResource;
import org.spongepowered.plugin.builtin.jvm.locator.JVMPluginResourceLocatorService;

public final class DirectoryPluginResourceLocatorService
implements JVMPluginResourceLocatorService {
    @Override
    public String name() {
        return "java_directory";
    }

    @Override
    public Set<JVMPluginResource> locatePluginResources(Environment environment) {
        Optional<List<Path>> dirs = environment.blackboard().find(Keys.PLUGIN_DIRECTORIES);
        if (dirs.isEmpty()) {
            environment.logger().debug("Locator '{}' is disabled.", (Object)this.name());
            return Collections.emptySet();
        }
        environment.logger().info("Locating '{}' resources...", (Object)this.name());
        HashSet<JVMPluginResource> resources = new HashSet<JVMPluginResource>();
        String metadataPath = environment.blackboard().get(Keys.METADATA_FILE_PATH);
        for (Path pluginsDir : dirs.get()) {
            if (Files.notExists(pluginsDir, new LinkOption[0])) {
                environment.logger().debug("Plugin directory '{}' does not exist for locator '{}'. Skipping...", (Object)pluginsDir, (Object)this.name());
                continue;
            }
            try {
                for (Path path : Files.walk(pluginsDir, new FileVisitOption[0]).toList()) {
                    if (!Files.isRegularFile(path, new LinkOption[0]) || !path.getFileName().toString().endsWith(".jar")) continue;
                    try (JarFile jf = new JarFile(path.toFile());){
                        JarEntry pluginMetadataJarEntry = jf.getJarEntry(metadataPath);
                        if (pluginMetadataJarEntry == null) {
                            environment.logger().debug("'{}' does not contain any plugin metadata so it is not a plugin. Skipping...", (Object)path);
                            continue;
                        }
                        resources.add(JVMPluginResource.create(environment, this.name(), path));
                    }
                    catch (IOException e) {
                        environment.logger().error("Error reading '{}' as a Jar file when traversing directory resources for plugin discovery! Skipping...", (Object)path, (Object)e);
                    }
                }
            }
            catch (IOException ex) {
                environment.logger().error("Error walking plugins directory {}", (Object)pluginsDir, (Object)ex);
            }
        }
        environment.logger().info("Located [{}] resource(s) for '{}'...", (Object)resources.size(), (Object)this.name());
        return resources;
    }
}

