/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.plugin.builtin.jvm.locator;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.spongepowered.plugin.Environment;
import org.spongepowered.plugin.blackboard.Keys;
import org.spongepowered.plugin.builtin.jvm.JVMPluginResource;
import org.spongepowered.plugin.builtin.jvm.locator.JVMPluginResourceLocatorService;

public final class ClasspathPluginResourceLocatorService
implements JVMPluginResourceLocatorService {
    @Override
    public String name() {
        return "java_classpath";
    }

    @Override
    public Set<JVMPluginResource> locatePluginResources(Environment environment) {
        environment.logger().info("Locating '{}' resources...", (Object)this.name());
        String metadataPath = environment.blackboard().get(Keys.METADATA_FILE_PATH);
        String[] cp = System.getProperty("java.class.path").split(File.pathSeparator);
        HashSet<JVMPluginResource> resources = new HashSet<JVMPluginResource>();
        for (String str : cp) {
            if (!str.endsWith(".jar")) continue;
            Path path = Paths.get(str, new String[0]);
            try (JarFile jar = new JarFile(path.toFile());){
                ZipEntry metadataEntry = jar.getEntry(metadataPath);
                if (metadataEntry == null) {
                    environment.logger().debug("'{}' does not contain any plugin metadata so it is not a plugin. Skipping...", (Object)str);
                    continue;
                }
                resources.add(JVMPluginResource.create(environment, this.name(), path));
            }
            catch (IOException e) {
                environment.logger().error("Error reading '{}' as a Jar file. Skipping...", (Object)path, (Object)e);
            }
        }
        environment.logger().info("Located [{}] resource(s) for '{}'...", (Object)resources.size(), (Object)this.name());
        return resources;
    }
}

