/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.plugin.builtin;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.spongepowered.plugin.blackboard.Blackboard;
import org.spongepowered.plugin.blackboard.Key;

public final class StandardBlackboard
implements Blackboard {
    private final Map<Key<?>, Object> values = new HashMap();

    @Override
    public <V> void set(Key<V> key, V value) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(value, "value");
        if (this.values.containsKey(key)) {
            throw new IllegalStateException(String.format("Key '%s' already has a value!", key.name()));
        }
        this.values.put(key, value);
    }

    @Override
    public <V> V get(Key<V> key) {
        Object rawValue = this.values.get(Objects.requireNonNull(key, "key"));
        if (rawValue == null) {
            throw new IllegalArgumentException(String.format("Key '%s' has no value!", key.name()));
        }
        return key.clazz().cast(rawValue);
    }

    @Override
    public <V> Optional<V> find(Key<V> key) {
        Object value = this.values.get(Objects.requireNonNull(key, "key"));
        if (value == null) {
            return Optional.empty();
        }
        return Optional.of(key.clazz().cast(value));
    }
}

