/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.forge.applaunch.plugin;

import cpw.mods.modlauncher.Environment;
import cpw.mods.modlauncher.api.IEnvironment;
import cpw.mods.modlauncher.api.TypesafeMap;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.common.applaunch.AppLaunch;
import org.spongepowered.common.applaunch.config.LaunchConfig;
import org.spongepowered.common.applaunch.config.TokenReplacement;
import org.spongepowered.common.applaunch.plugin.PluginPlatform;

public final class ForgePluginPlatform
implements PluginPlatform {
    private static volatile boolean bootstrapped;
    private final Environment environment;
    private final Logger logger;
    private final LaunchConfig config;
    private final TokenReplacement tokens;
    private final List<Path> pluginDirectories;

    public static synchronized void bootstrap(Environment environment) {
        ForgePluginPlatform platform;
        if (bootstrapped) {
            return;
        }
        bootstrapped = true;
        try {
            platform = new ForgePluginPlatform(environment);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        AppLaunch.setPluginPlatform(platform);
    }

    private ForgePluginPlatform(Environment environment) throws IOException {
        this.environment = environment;
        this.logger = LogManager.getLogger((String)"plugin");
        this.config = LaunchConfig.load(this.baseDirectory(), true);
        this.tokens = new TokenReplacement();
        this.tokens.register("BASE_DIR", this.baseDirectory());
        this.tokens.register("CONFIG_DIR", this.configDirectory());
        this.tokens.register("MODS_DIR", FMLPaths.MODSDIR.get());
        Path additionalPluginsDirectory = Path.of(this.tokens.replace(this.config.additionalPluginsDirectory()), new String[0]);
        Files.createDirectories(additionalPluginsDirectory, new FileAttribute[0]);
        this.pluginDirectories = List.of(FMLPaths.MODSDIR.get(), additionalPluginsDirectory);
    }

    @Override
    public String version() {
        return this.environment.getProperty((TypesafeMap.Key)IEnvironment.Keys.VERSION.get()).orElse("dev");
    }

    @Override
    public Logger logger() {
        return this.logger;
    }

    @Override
    public boolean vanilla() {
        return false;
    }

    @Override
    public Path baseDirectory() {
        return FMLPaths.GAMEDIR.get();
    }

    @Override
    public Path configDirectory() {
        return FMLPaths.CONFIGDIR.get();
    }

    @Override
    public LaunchConfig config() {
        return this.config;
    }

    @Override
    public TokenReplacement tokens() {
        return this.tokens;
    }

    @Override
    public List<Path> pluginDirectories() {
        return this.pluginDirectories;
    }
}

