/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.forge.applaunch.loading.moddiscovery.locator;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import net.minecraftforge.forgespi.locating.IModFile;
import net.minecraftforge.forgespi.locating.IModLocator;
import org.spongepowered.forge.applaunch.loading.moddiscovery.AbstractModProvider;
import org.spongepowered.forge.applaunch.loading.moddiscovery.PluginFileParser;

public final class EnvironmentPluginLocator
extends AbstractModProvider
implements IModLocator {
    public List<IModLocator.ModFileOrException> scanMods() {
        ArrayList<IModLocator.ModFileOrException> modFiles = new ArrayList<IModLocator.ModFileOrException>();
        for (Path[] paths : EnvironmentPluginLocator.getPluginsPaths()) {
            modFiles.add(new IModLocator.ModFileOrException((IModFile)PluginFileParser.newModFile(this, false, paths), null));
        }
        return modFiles;
    }

    public String name() {
        return "environment plugin";
    }

    private static List<Path[]> getPluginsPaths() {
        String env = System.getenv("SPONGE_PLUGINS");
        if (env == null) {
            return Collections.emptyList();
        }
        ArrayList<Path[]> plugins = new ArrayList<Path[]>();
        for (String entry : env.split(";")) {
            if (entry.isBlank()) continue;
            plugins.add((Path[])Stream.of(entry.split("&")).map(x$0 -> Path.of(x$0, new String[0])).toArray(Path[]::new));
        }
        return plugins;
    }
}

