/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.forge.applaunch.loading.moddiscovery;

import com.google.common.collect.ImmutableMap;
import cpw.mods.modlauncher.Environment;
import cpw.mods.modlauncher.Launcher;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.forgespi.locating.IModFile;
import net.minecraftforge.forgespi.locating.IModLocator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.forge.applaunch.loading.moddiscovery.AbstractModProvider;
import org.spongepowered.forge.applaunch.loading.moddiscovery.PluginFileParser;
import org.spongepowered.forge.applaunch.plugin.ForgePluginPlatform;

public final class SpongeForgeModLocator
extends AbstractModProvider
implements IModLocator {
    private static final Logger LOGGER = LogManager.getLogger();

    public List<IModLocator.ModFileOrException> scanMods() {
        if (!FMLEnvironment.production) {
            ArrayList<IModLocator.ModFileOrException> resources = new ArrayList<IModLocator.ModFileOrException>();
            String resourcesProp = System.getProperty("sponge.resources");
            if (resourcesProp != null) {
                for (String entry : resourcesProp.split(File.pathSeparator)) {
                    if (entry.isBlank()) continue;
                    Path[] paths = (Path[])Stream.of(entry.split("&")).map(x$0 -> Path.of(x$0, new String[0])).toArray(Path[]::new);
                    resources.add(new IModLocator.ModFileOrException((IModFile)PluginFileParser.newModFile(this, true, paths), null));
                }
            }
            return resources;
        }
        try {
            URL rootJar = SpongeForgeModLocator.class.getProtectionDomain().getCodeSource().getLocation();
            FileSystem fs = FileSystems.getFileSystem(rootJar.toURI());
            return Files.list(fs.getPath("jars", new String[0])).filter(path -> path.getFileName().toString().toLowerCase(Locale.ROOT).endsWith(".jar")).map(path -> {
                try {
                    URI jij = new URI("jij:" + path.toAbsolutePath().toUri().getRawSchemeSpecificPart()).normalize();
                    ImmutableMap env = ImmutableMap.of((Object)"packagePath", (Object)path);
                    FileSystem jijFS = FileSystems.newFileSystem(jij, env);
                    return jijFS.getPath("/", new String[0]);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }).map(path -> new IModLocator.ModFileOrException((IModFile)PluginFileParser.newModFile(this, false, path), null)).toList();
        }
        catch (Exception e) {
            LOGGER.error("Failed to scan mod candidates", (Throwable)e);
            return List.of();
        }
    }

    public String name() {
        return "spongeforge";
    }

    @Override
    public void initArguments(Map<String, ?> arguments) {
        Environment env = Launcher.INSTANCE.environment();
        ForgePluginPlatform.bootstrap(env);
    }
}

