/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.forge.applaunch.loading.moddiscovery;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.forgespi.locating.IDependencyLocator;
import net.minecraftforge.forgespi.locating.IModFile;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.common.applaunch.AppLaunch;
import org.spongepowered.forge.applaunch.loading.moddiscovery.AbstractModProvider;
import org.spongepowered.forge.applaunch.loading.moddiscovery.PluginFileParser;
import org.spongepowered.forge.applaunch.loading.moddiscovery.SpongeForgeModLocator;
import org.spongepowered.forge.applaunch.loading.moddiscovery.library.Log4JLogger;
import org.spongepowered.libs.LibraryManager;

public class SpongeForgeDependencyLocator
extends AbstractModProvider
implements IDependencyLocator {
    private static final Logger LOGGER = LogManager.getLogger();

    public List<IModFile> scanMods(Iterable<IModFile> loadedMods) {
        ArrayList<IModFile> modFiles = new ArrayList<IModFile>();
        if (FMLEnvironment.production) {
            Object platform = AppLaunch.pluginPlatform();
            LibraryManager libraryManager = new LibraryManager(new Log4JLogger(LogManager.getLogger(LibraryManager.class)), platform.config().checkLibraryHashes(), Path.of(platform.tokens().replace(platform.config().librariesDirectory()), new String[0]), SpongeForgeModLocator.class.getResource("/sponge-libraries.json"));
            try {
                libraryManager.validate();
            }
            catch (Exception ex) {
                throw new RuntimeException("Failed to download and validate Sponge libraries", ex);
            }
            libraryManager.finishedProcessing();
            for (LibraryManager.Library library : libraryManager.getAll("main")) {
                Path path = library.file();
                LOGGER.debug("Proposing jar {} as a game library", (Object)path);
                modFiles.add((IModFile)PluginFileParser.newLibraryFile(this, path));
            }
        }
        return modFiles;
    }

    public String name() {
        return "spongeforge";
    }
}

