/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.forge.applaunch.loading.moddiscovery;

import cpw.mods.jarhandling.SecureJar;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraftforge.forgespi.locating.IModFile;
import net.minecraftforge.forgespi.locating.IModProvider;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractModProvider
implements IModProvider {
    private static final Logger LOGGER = LogManager.getLogger();

    public boolean isValid(IModFile modFile) {
        return true;
    }

    public void initArguments(Map<String, ?> arguments) {
    }

    public void scanFile(IModFile file, Consumer<Path> pathConsumer) {
        LOGGER.debug("Scan started: {}", (Object)file);
        SecureJar jar = file.getSecureJar();
        Consumer<Path> consumer = pathConsumer;
        AtomicReference<SecureJar.Status> minStatus = new AtomicReference<SecureJar.Status>(SecureJar.Status.NONE);
        if (jar.hasSecurityData()) {
            minStatus.set(SecureJar.Status.VERIFIED);
            consumer = path -> {
                pathConsumer.accept((Path)path);
                SecureJar.Status status = jar.verifyPath(path);
                if (status.ordinal() < ((SecureJar.Status)minStatus.get()).ordinal()) {
                    minStatus.set(status);
                }
            };
        }
        try (Stream<Path> files = Files.walk(jar.getRootPath(), new FileVisitOption[0]);){
            files.filter(p -> p.toString().endsWith(".class")).forEach(consumer);
        }
        catch (IOException e) {
            LOGGER.debug("Scan failed: {}", (Object)file);
            minStatus.set(SecureJar.Status.NONE);
        }
        file.setSecurityStatus(minStatus.get());
        LOGGER.debug("Scan finished: {}", (Object)file);
    }
}

