/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.forge.applaunch.loading.metadata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraftforge.forgespi.language.IConfigurable;
import org.spongepowered.forge.applaunch.loading.metadata.PluginDependencyConfigurable;
import org.spongepowered.forge.applaunch.loading.metadata.PluginMetadataConfigurable;
import org.spongepowered.plugin.metadata.PluginMetadata;
import org.spongepowered.plugin.metadata.builtin.MetadataContainer;
import org.spongepowered.plugin.metadata.model.PluginDependency;

public final class PluginFileConfigurable
implements IConfigurable {
    private final MetadataContainer container;

    public PluginFileConfigurable(MetadataContainer container) {
        this.container = container;
    }

    public <T> Optional<T> getConfigElement(String ... key) {
        if (key.length < 1) {
            return Optional.empty();
        }
        String query = key[0];
        if (key.length != this.requiredConfigElements(query)) {
            return Optional.empty();
        }
        if ("modLoader".equals(query)) {
            return Optional.of(this.container.loader().name());
        }
        if ("loaderVersion".equals(query)) {
            return Optional.of(this.container.loader().version().toString());
        }
        if ("license".equals(query)) {
            return Optional.of(this.container.license());
        }
        if (key.length == 2) {
            String plugin = key[1];
            PluginMetadata metadata = this.container.metadata(plugin).orElse(null);
            if (metadata == null) {
                return Optional.empty();
            }
            if ("modproperties".equals(query)) {
                return Optional.of(metadata.properties());
            }
        }
        return Optional.empty();
    }

    public List<? extends IConfigurable> getConfigList(String ... key) {
        if (key.length < 1) {
            return Collections.emptyList();
        }
        String query = key[0];
        if (key.length != this.requiredConfigElements(query)) {
            return Collections.emptyList();
        }
        if ("mods".equals(query)) {
            Set<PluginMetadata> metadataById = this.container.metadata();
            if (metadataById.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList metadataConfigurables = new ArrayList();
            metadataById.forEach(metadata -> metadataConfigurables.add(new PluginMetadataConfigurable((PluginMetadata)metadata)));
            return metadataConfigurables;
        }
        if (key.length != 2) {
            return Collections.emptyList();
        }
        String plugin = key[1];
        PluginMetadata metadata2 = this.container.metadata(plugin).orElse(null);
        if (metadata2 == null) {
            return Collections.emptyList();
        }
        if ("dependencies".equals(query)) {
            Set<PluginDependency> dependencies = metadata2.dependencies();
            if (dependencies.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<PluginDependencyConfigurable> depConfigurables = new ArrayList<PluginDependencyConfigurable>();
            for (PluginDependency dependency : dependencies) {
                depConfigurables.add(new PluginDependencyConfigurable(metadata2, dependency));
            }
            return depConfigurables;
        }
        return Collections.emptyList();
    }

    private int requiredConfigElements(String query) {
        if ("dependencies".equals(query) || "modproperties".equals(query)) {
            return 2;
        }
        return 1;
    }
}

