/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.worldGeneration.structure.worldGen;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.api.events.PixelmonStructureGenerationEvent;
import com.pixelmonmod.pixelmon.config.PixelmonItemsBadges;
import com.pixelmonmod.pixelmon.entities.npcs.NPCChatting;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrainer;
import com.pixelmonmod.pixelmon.entities.npcs.registry.GymNPCData;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ServerNPCRegistry;
import com.pixelmonmod.pixelmon.enums.EnumEncounterMode;
import com.pixelmonmod.pixelmon.enums.EnumNPCType;
import com.pixelmonmod.pixelmon.enums.EnumTrainerAI;
import com.pixelmonmod.pixelmon.enums.EnumType;
import com.pixelmonmod.pixelmon.items.ItemBadge;
import com.pixelmonmod.pixelmon.worldGeneration.structure.StructureInfo;
import com.pixelmonmod.pixelmon.worldGeneration.structure.StructureRegistry;
import com.pixelmonmod.pixelmon.worldGeneration.structure.gyms.GymInfo;
import com.pixelmonmod.pixelmon.worldGeneration.structure.gyms.WorldGymData;
import com.pixelmonmod.pixelmon.worldGeneration.structure.gyms.WorldGymInfo;
import com.pixelmonmod.pixelmon.worldGeneration.structure.towns.NPCPlacementInfo;
import com.pixelmonmod.pixelmon.worldGeneration.structure.util.StructureScattered;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.structure.MapGenScatteredFeature;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.eventhandler.Event;

public class WorldGenGym
extends MapGenScatteredFeature
implements IWorldGenerator {
    public static StructureBoundingBox lastTownBB;
    static final int distance = 30;
    public static final List<StructureBoundingBox> usedTownsList;
    public static final List<BlockPos> gymsGenerated;
    public static boolean locked;

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (lastTownBB == null) {
            return;
        }
        if (usedTownsList.contains(lastTownBB)) {
            return;
        }
        if (locked) {
            return;
        }
        int minX = chunkX * 16;
        int maxX = minX + 16;
        int minZ = chunkZ * 16;
        int maxZ = minZ + 16;
        if (this.isClose(minX, maxX, WorldGenGym.lastTownBB.field_78897_a, WorldGenGym.lastTownBB.field_78893_d) && this.isClose(minZ, maxZ, WorldGenGym.lastTownBB.field_78896_c, WorldGenGym.lastTownBB.field_78892_f)) {
            GymInfo gyminfo;
            WorldGymData data = (WorldGymData)world.getPerWorldStorage().func_75742_a(WorldGymData.class, "gyminfo");
            if (data == null) {
                data = new WorldGymData();
                world.getPerWorldStorage().func_75745_a("gyminfo", (WorldSavedData)data);
            }
            if ((gyminfo = StructureRegistry.getNextGym(data, random)) == null || gyminfo.type == null || this.getBadge(data, gyminfo.type) == null) {
                if (gyminfo != null && gyminfo.type == null) {
                    Pixelmon.LOGGER.warn("Gym type info not found. External JSON files are probably not updated correctly.");
                }
                return;
            }
            for (int i = 0; i < 10; ++i) {
                ItemStack badge;
                int zPos;
                int yPos;
                int xPos = random.nextInt(16) + chunkX * 16;
                BlockPos pos = new BlockPos(xPos, yPos = 64, zPos = random.nextInt(16) + chunkZ * 16);
                StructureScattered s = gyminfo.createStructure(random, pos, true, false, null, false);
                if (!this.canSpawnStructureAtCoords(world, s, gyminfo, pos)) continue;
                locked = true;
                GymPlacementInfo info = new GymPlacementInfo(s, gyminfo, pos, lastTownBB);
                info.struc.signItem = badge = this.getBadge(data, info.gyminfo.type);
                boolean generated = info.struc.generate(world, random);
                PixelmonStructureGenerationEvent.Post generationEvent = new PixelmonStructureGenerationEvent.Post(world, info.struc, (StructureInfo)info.gyminfo, info.gymPos, generated);
                Pixelmon.EVENT_BUS.post((Event)generationEvent);
                if (!generated) break;
                gymsGenerated.add(pos);
                info.gyminfo.level = data.getGymLevel();
                WorldGenGym.spawnNPCs(world, info.struc, info.gyminfo, badge);
                data.addGym(info.gyminfo.name, badge, info.gyminfo.level);
                usedTownsList.add(info.lastTownBB);
                Pixelmon.LOGGER.info("Gym spawned at " + info.struc.func_74874_b().field_78897_a + " " + info.struc.func_74874_b().field_78895_b + " " + info.struc.func_74874_b().field_78896_c);
                break;
            }
            locked = false;
        }
    }

    private ItemStack getBadge(WorldGymData data, EnumType[] types) {
        ArrayList<ItemBadge> clearedList = PixelmonItemsBadges.getBadgeList(types);
        for (WorldGymInfo info : data.getGymList()) {
            if (!clearedList.contains(info.badge.func_77973_b())) continue;
            clearedList.remove(info.badge.func_77973_b());
        }
        if (clearedList.size() == 0) {
            clearedList = PixelmonItemsBadges.getBadgeList(types);
        }
        return new ItemStack((Item)RandomHelper.getRandomElementFromList(clearedList));
    }

    public static void spawnNPCs(World world, StructureScattered s, GymInfo gymInfo) {
        WorldGenGym.spawnNPCs(world, s, gymInfo, new ItemStack((Item)PixelmonItemsBadges.getRandomBadge(gymInfo.type)));
    }

    public static void spawnNPCs(World world, StructureScattered s, GymInfo gymInfo, ItemStack badge) {
        for (NPCPlacementInfo npcInfo : gymInfo.getNPCS()) {
            GymNPCData data;
            if (npcInfo.npcType == EnumNPCType.ChattingNPC) {
                NPCChatting npc = new NPCChatting(world);
                data = ServerNPCRegistry.getGymMember(npcInfo.npcName);
                if (data == null) {
                    Pixelmon.LOGGER.warn("Can't find Gym NPC " + npcInfo.npcName);
                    continue;
                }
                npc.init(data);
                npc.setCustomSteveTexture(data.textures.get(data.getRandomTextureIndex()));
                npc.initDefaultAI();
                npc.ignoreDespawnCounter = true;
                WorldGenGym.spawnVillager(world, s, npcInfo.x, npcInfo.y, npcInfo.z, (EntityLiving)npc);
                continue;
            }
            if (npcInfo.npcType != EnumNPCType.Trainer) continue;
            NPCTrainer trainer = new NPCTrainer(world);
            data = ServerNPCRegistry.getGymMember(npcInfo.npcName);
            if (data == null) {
                Pixelmon.LOGGER.warn("Can't find Gym NPC " + npcInfo.npcName);
                continue;
            }
            trainer.init(data, gymInfo, npcInfo.tier);
            trainer.setAIMode(EnumTrainerAI.StillAndEngage);
            trainer.initAI();
            trainer.setEncounterMode(EnumEncounterMode.OncePerPlayer);
            trainer.setStartRotationYaw(WorldGenGym.getRotation(npcInfo.rotation, s.getFacing()));
            if (npcInfo.drops != null) {
                ArrayList<ItemStack> dropsList = new ArrayList<ItemStack>();
                dropsList.add(RandomHelper.getRandomElementFromList(npcInfo.drops));
                if (npcInfo.tier == 0 && badge != null) {
                    dropsList.add(badge);
                }
                trainer.updateDrops(dropsList.toArray(new ItemStack[dropsList.size()]));
            }
            trainer.ignoreDespawnCounter = true;
            WorldGenGym.spawnVillager(world, s, npcInfo.x, npcInfo.y, npcInfo.z, (EntityLiving)trainer);
        }
    }

    private static float getRotation(int rotation, EnumFacing facing) {
        switch (facing) {
            case EAST: {
                return rotation;
            }
            case WEST: {
                return rotation + 180;
            }
            case NORTH: {
                return rotation - 90;
            }
            case SOUTH: {
                return rotation + 90;
            }
        }
        return 0.0f;
    }

    protected static void spawnVillager(World worldIn, StructureScattered s, int x, int y, int z, EntityLiving entity) {
        int xoff = s.getX(x, z);
        int yoff = s.getY(y);
        int zoff = s.getZ(x, z);
        if (!s.func_74874_b().func_175898_b((Vec3i)new BlockPos(xoff, yoff, zoff))) {
            return;
        }
        entity.func_70012_b((double)xoff + 0.5, (double)yoff, (double)zoff + 0.5, 0.0f, 0.0f);
        worldIn.func_72838_d((Entity)entity);
    }

    private boolean isClose(int min1, int max1, int min2, int max2) {
        return Math.abs(min1 - min2) < 30 || Math.abs(min1 - max2) < 30 || Math.abs(max1 - min2) < 30 || Math.abs(max1 - max2) < 30;
    }

    protected boolean canSpawnStructureAtCoords(World world, StructureScattered s, GymInfo gyminfo, BlockPos pos) {
        for (BlockPos p : gymsGenerated) {
            if (!(p.func_177951_i((Vec3i)pos) < 90000.0)) continue;
            return false;
        }
        if (usedTownsList.contains(lastTownBB)) {
            return false;
        }
        PixelmonStructureGenerationEvent.Pre generationEvent = new PixelmonStructureGenerationEvent.Pre(world, s, gyminfo, pos);
        Pixelmon.EVENT_BUS.post((Event)generationEvent);
        return !generationEvent.isCanceled();
    }

    static {
        usedTownsList = new ArrayList<StructureBoundingBox>();
        gymsGenerated = new ArrayList<BlockPos>();
        locked = false;
    }

    private class GymPlacementInfo {
        public StructureScattered struc;
        public GymInfo gyminfo;
        public BlockPos gymPos;
        public StructureBoundingBox lastTownBB;

        public GymPlacementInfo(StructureScattered s, GymInfo gyminfo, BlockPos pos, StructureBoundingBox lastTownBB) {
            this.struc = s;
            this.gyminfo = gyminfo;
            this.gymPos = pos;
            this.lastTownBB = lastTownBB;
        }
    }
}

