/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.storage.extras;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.entities.pixelmon.EnumSpecialTexture;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import com.pixelmonmod.pixelmon.storage.extras.ExtrasContact;
import java.awt.Color;
import java.util.EnumSet;
import java.util.UUID;
import net.minecraft.util.Tuple;

public class PixelExtrasData {
    public final UUID id;
    Tuple<EnumSet<ExtrasContact.Groups>, int[]> apiData;
    private EnumSet<Category> enabled = EnumSet.allOf(Category.class);
    private HatType hatType = HatType.NONE;
    private MonocleType monocleType = MonocleType.NONE;
    SashType sashType = null;
    RobeType robeType = RobeType.NONE;
    private int[] sashColors = null;
    private int[] capColors = new int[]{Color.RED.getRed(), Color.RED.getGreen(), Color.RED.getBlue()};
    private int[] monocleOffset = new int[]{5, 4, 3};

    public PixelExtrasData(UUID id) {
        this.id = id;
    }

    public boolean isReady() {
        return this.apiData != null;
    }

    public boolean hasData() {
        return this.has(ExtrasContact.Groups.values());
    }

    public int dataHash() {
        int hash = 0;
        for (Enum enumm : (EnumSet)this.apiData.func_76341_a()) {
            if (enumm == null) continue;
            hash = 31 * hash + (enumm.ordinal() + 1);
        }
        return hash;
    }

    public int[] getColours(Category category) {
        if (category == Category.SASH) {
            return this.sashColors == null ? (int[])this.apiData.func_76340_b() : this.sashColors;
        }
        if (category == Category.HAT) {
            return this.capColors;
        }
        if (category == Category.MONOCLE) {
            return this.monocleOffset;
        }
        return null;
    }

    public void setColours(Category category, int[] array) {
        if (category == Category.SASH) {
            this.sashColors = array;
        } else if (category == Category.HAT) {
            this.capColors = array;
        } else if (category == Category.MONOCLE) {
            this.monocleOffset = array;
        }
    }

    public boolean isEnabled(Category category) {
        return this.enabled.contains((Object)category);
    }

    public void setEnabled(Category category, boolean bool) {
        if (bool) {
            this.enabled.add(category);
        } else {
            this.enabled.remove((Object)category);
        }
    }

    public HatType getHatType() {
        if (this.isEnabled(Category.HAT)) {
            switch (this.hatType) {
                case SCOR_HOOD: 
                case TRAINER_CAP: {
                    return this.has(ExtrasContact.Groups.Trainer_Cap) ? this.hatType : (this.hatType = HatType.NONE);
                }
                case PIKA_HOOD: {
                    return this.has(ExtrasContact.Groups.Pikahood) ? this.hatType : (this.hatType = HatType.NONE);
                }
                case EEVEE_HOOD: {
                    return this.has(ExtrasContact.Groups.EeveeHood) ? this.hatType : (this.hatType = HatType.NONE);
                }
                case WIKI: {
                    return this.has(ExtrasContact.Groups.Wiki) ? this.hatType : (this.hatType = HatType.NONE);
                }
                case TOP_HAT: 
                case FEZ: 
                case FEDORA: {
                    return this.has(ExtrasContact.Groups.CompWinner) ? this.hatType : (this.hatType = HatType.NONE);
                }
            }
        }
        return HatType.NONE;
    }

    public boolean setHatType(HatType hat) {
        if (hat == HatType.TRAINER_CAP && this.has(ExtrasContact.Groups.Trainer_Cap) || hat == HatType.PIKA_HOOD && this.has(ExtrasContact.Groups.Pikahood) || hat == HatType.EEVEE_HOOD && this.has(ExtrasContact.Groups.EeveeHood) || hat == HatType.SCOR_HOOD && this.has(ExtrasContact.Groups.Trainer_Cap) || hat == HatType.WIKI && this.has(ExtrasContact.Groups.Wiki) || this.has(ExtrasContact.Groups.CompWinner) || hat == HatType.NONE) {
            this.hatType = hat;
            return true;
        }
        return false;
    }

    public EnumSet<HatType> getAvailableHats() {
        EnumSet<HatType> set = EnumSet.noneOf(HatType.class);
        if (this.has(ExtrasContact.Groups.Trainer_Cap)) {
            set.add(HatType.TRAINER_CAP);
            set.add(HatType.SCOR_HOOD);
        }
        if (this.has(ExtrasContact.Groups.CompWinner)) {
            set.add(HatType.TOP_HAT);
            set.add(HatType.FEZ);
            set.add(HatType.FEDORA);
        }
        if (this.has(ExtrasContact.Groups.Pikahood)) {
            set.add(HatType.PIKA_HOOD);
        }
        if (this.has(ExtrasContact.Groups.EeveeHood)) {
            set.add(HatType.EEVEE_HOOD);
        }
        if (this.has(ExtrasContact.Groups.Wiki)) {
            set.add(HatType.WIKI);
        }
        return set;
    }

    public MonocleType getMonocleType() {
        if (this.isEnabled(Category.MONOCLE)) {
            switch (this.monocleType) {
                case GOLD_MONOCLE: {
                    return this.has(ExtrasContact.Groups.Monocle_Gold) ? this.monocleType : (this.monocleType = MonocleType.NONE);
                }
                case BLACK_MONOCLE: {
                    return this.has(ExtrasContact.Groups.Monocle_Black) ? this.monocleType : (this.monocleType = MonocleType.NONE);
                }
            }
        }
        return MonocleType.NONE;
    }

    public boolean setMonocleType(MonocleType monocle) {
        if (monocle == MonocleType.GOLD_MONOCLE && this.has(ExtrasContact.Groups.Monocle_Gold) || monocle == MonocleType.BLACK_MONOCLE && this.has(ExtrasContact.Groups.Monocle_Black) || monocle == MonocleType.NONE) {
            this.monocleType = monocle;
            return true;
        }
        return false;
    }

    public EnumSet<MonocleType> getAvailableMonocles() {
        EnumSet<MonocleType> set = EnumSet.noneOf(MonocleType.class);
        if (this.has(ExtrasContact.Groups.Monocle_Gold)) {
            set.add(MonocleType.GOLD_MONOCLE);
        }
        if (this.has(ExtrasContact.Groups.Monocle_Black)) {
            set.add(MonocleType.BLACK_MONOCLE);
        }
        return set;
    }

    public SashType getSashType() {
        if (this.isEnabled(Category.SASH)) {
            if (this.sashType == null) {
                return this.has(ExtrasContact.Groups.Rainbow_Sash) ? SashType.RAINBOW : (this.has(ExtrasContact.Groups.Admin, ExtrasContact.Groups.Junior_Admin) ? SashType.RANK_ADMIN : (this.has(ExtrasContact.Groups.Developer) ? SashType.RANK_DEV : (this.has(ExtrasContact.Groups.Modeler) ? SashType.RANK_MODELER : (this.has(ExtrasContact.Groups.Support) ? SashType.RANK_SUPPORT : (this.has(ExtrasContact.Groups.Sash) ? SashType.REGULAR : SashType.NONE)))));
            }
            switch (this.sashType) {
                case REGULAR: {
                    return this.has(ExtrasContact.Groups.Sash) ? this.sashType : (this.sashType = SashType.NONE);
                }
                case RAINBOW: {
                    return this.has(ExtrasContact.Groups.Rainbow_Sash) ? this.sashType : (this.sashType = SashType.NONE);
                }
                case RANK_ADMIN: {
                    return this.has(ExtrasContact.Groups.Admin) ? this.sashType : (this.sashType = SashType.NONE);
                }
                case RANK_JR: {
                    return this.has(ExtrasContact.Groups.Junior_Admin) ? this.sashType : (this.sashType = SashType.NONE);
                }
                case RANK_DEV: {
                    return this.has(ExtrasContact.Groups.Developer) ? this.sashType : (this.sashType = SashType.NONE);
                }
                case RANK_MODELER: {
                    return this.has(ExtrasContact.Groups.Modeler) ? this.sashType : (this.sashType = SashType.NONE);
                }
                case RANK_SUPPORT: {
                    return this.has(ExtrasContact.Groups.Support) ? this.sashType : (this.sashType = SashType.NONE);
                }
            }
        }
        return SashType.NONE;
    }

    public boolean setSashType(SashType sash) {
        if (sash == SashType.REGULAR && this.has(ExtrasContact.Groups.Sash) || sash == SashType.RAINBOW && this.has(ExtrasContact.Groups.Rainbow_Sash) || sash == SashType.RANK_ADMIN && this.has(ExtrasContact.Groups.Admin) || sash == SashType.RANK_JR && this.has(ExtrasContact.Groups.Junior_Admin) || sash == SashType.RANK_DEV && this.has(ExtrasContact.Groups.Developer) || sash == SashType.RANK_MODELER && this.has(ExtrasContact.Groups.Modeler) || sash == SashType.RANK_SUPPORT && this.has(ExtrasContact.Groups.Support) || sash == SashType.NONE) {
            this.sashType = sash;
            return true;
        }
        return false;
    }

    public EnumSet<SashType> getAvailableSashs() {
        EnumSet<SashType> set = EnumSet.noneOf(SashType.class);
        if (this.has(ExtrasContact.Groups.Sash)) {
            set.add(SashType.REGULAR);
        }
        if (this.has(ExtrasContact.Groups.Rainbow_Sash)) {
            set.add(SashType.RAINBOW);
        }
        if (this.has(ExtrasContact.Groups.Admin)) {
            set.add(SashType.RANK_ADMIN);
        }
        if (this.has(ExtrasContact.Groups.Junior_Admin)) {
            set.add(SashType.RANK_JR);
        }
        if (this.has(ExtrasContact.Groups.Developer)) {
            set.add(SashType.RANK_DEV);
        }
        if (this.has(ExtrasContact.Groups.Modeler)) {
            set.add(SashType.RANK_MODELER);
        }
        if (this.has(ExtrasContact.Groups.Support)) {
            set.add(SashType.RANK_SUPPORT);
        }
        return set;
    }

    public EnumSet<EnumSpecies> getAvailableTextures() {
        EnumSet<EnumSpecies> set = EnumSet.noneOf(EnumSpecies.class);
        if (this.has(ExtrasContact.Groups.Spectral_Jeweller)) {
            set.add(EnumSpecies.Haunter);
        }
        if (this.has(ExtrasContact.Groups.Shadow_Lugia)) {
            set.add(EnumSpecies.Lugia);
        }
        if (this.has(ExtrasContact.Groups.Wobbuffet)) {
            set.add(EnumSpecies.Wobbuffet);
        }
        return set;
    }

    public boolean canSeeTexture(EnumSpecies pokemon) {
        return pokemon == EnumSpecies.Haunter && this.has(ExtrasContact.Groups.Spectral_Jeweller) || pokemon == EnumSpecies.Lugia && this.has(ExtrasContact.Groups.Shadow_Lugia) || pokemon == EnumSpecies.Wobbuffet && this.has(ExtrasContact.Groups.Wobbuffet);
    }

    public void checkPokemon(Pokemon pokemon) {
        if (!this.isReady()) {
            return;
        }
        if (pokemon.getSpecialTexture() == EnumSpecialTexture.Online && !this.canSeeTexture(pokemon.getSpecies())) {
            pokemon.setSpecialTexture(EnumSpecialTexture.None);
        }
    }

    public boolean setRobeType(RobeType type) {
        if (type == RobeType.WIZARD && this.has(ExtrasContact.Groups.Robe) || type == RobeType.NONE) {
            this.robeType = type;
            return true;
        }
        return false;
    }

    public RobeType getRobeType() {
        if (this.isEnabled(Category.ROBE)) {
            switch (this.robeType) {
                case WIZARD: {
                    return this.has(ExtrasContact.Groups.Robe) ? this.robeType : (this.robeType = RobeType.NONE);
                }
            }
        }
        return RobeType.NONE;
    }

    public EnumSet<RobeType> getAvailableRobes() {
        EnumSet<RobeType> set = EnumSet.noneOf(RobeType.class);
        if (this.has(ExtrasContact.Groups.Robe)) {
            set.add(RobeType.WIZARD);
        }
        return set;
    }

    public boolean hasBoostedNecklace() {
        return this.has(ExtrasContact.Groups.BoostedNecklace);
    }

    final boolean has(ExtrasContact.Groups ... groups) {
        if (this.apiData != null) {
            for (ExtrasContact.Groups group : groups) {
                if (!((EnumSet)this.apiData.func_76341_a()).contains((Object)group)) continue;
                return true;
            }
        }
        return false;
    }

    public static enum Category {
        SASH,
        HAT,
        ROBE,
        MONOCLE;

    }

    public static enum RobeType {
        NONE,
        WIZARD,
        HWEEN;

    }

    public static enum SashType {
        NONE,
        REGULAR,
        RAINBOW,
        RANK_ADMIN,
        RANK_JR,
        RANK_DEV,
        RANK_MODELER,
        RANK_SUPPORT;

    }

    public static enum MonocleType {
        NONE(-1),
        GOLD_MONOCLE(0),
        BLACK_MONOCLE(1);

        public final int id;

        private MonocleType(int id) {
            this.id = id;
        }

        public static MonocleType getFromId(int id) {
            for (MonocleType monocle : MonocleType.values()) {
                if (monocle.id != id) continue;
                return monocle;
            }
            return NONE;
        }
    }

    public static enum HatType {
        NONE(-1),
        TOP_HAT(0),
        FEZ(1),
        FEDORA(2),
        TRAINER_CAP(4),
        PIKA_HOOD(5),
        WIKI(6),
        EEVEE_HOOD(7),
        SCOR_HOOD(8);

        public final int id;

        private HatType(int id) {
            this.id = id;
        }

        public static HatType getFromId(int id) {
            for (HatType hat : HatType.values()) {
                if (hat.id != id) continue;
                return hat;
            }
            return NONE;
        }

        public static HatType getFromName(String name) {
            for (HatType hat : HatType.values()) {
                if (!hat.name().replace("_", "").equalsIgnoreCase(name)) continue;
                return hat;
            }
            return NONE;
        }
    }
}

