/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.pokedex;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.world.WeatherType;
import com.pixelmonmod.pixelmon.api.world.WorldTime;
import com.pixelmonmod.pixelmon.comm.ClientUpdatePokedex;
import com.pixelmonmod.pixelmon.comm.packetHandlers.OpenScreen;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.BaseStats;
import com.pixelmonmod.pixelmon.enums.EnumFeatureState;
import com.pixelmonmod.pixelmon.enums.EnumGuiScreen;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import com.pixelmonmod.pixelmon.pokedex.EnumPokedexRegisterStatus;
import com.pixelmonmod.pixelmon.pokedex.PokedexEntry;
import com.pixelmonmod.pixelmon.storage.PlayerPartyStorage;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Pokedex {
    public static final HashMap<Integer, PokedexEntry> fullPokedex = new HashMap();
    public static final int pokedexSize = EnumSpecies.values().length;
    public UUID uuid;
    private Map<Integer, EnumPokedexRegisterStatus> seenMap;

    public static void loadPokedex() {
        for (EnumSpecies pokemon : EnumSpecies.values()) {
            BaseStats bs = pokemon.getBaseStats();
            if (bs == null) {
                Pixelmon.LOGGER.error("Error loading base stats for " + pokemon.name);
                continue;
            }
            fullPokedex.put(pokemon.getNationalPokedexInteger(), new PokedexEntry(bs.nationalPokedexNumber, bs.pixelmonName, bs.weight.floatValue(), bs.height.floatValue()));
        }
    }

    public static int nameToID(String name) {
        Optional<EnumSpecies> optional;
        if (name.equals("Ho-oh")) {
            name = "Ho-Oh";
        }
        if (!(optional = EnumSpecies.getFromName(name)).isPresent()) {
            return 0;
        }
        return optional.get().getNationalPokedexInteger();
    }

    public static boolean isEntryEmpty(int i) {
        if (!fullPokedex.containsKey(i)) {
            return true;
        }
        String checkName = Pokedex.fullPokedex.get((Object)Integer.valueOf((int)i)).name;
        return checkName.equals("???") || !EnumSpecies.getNameList().contains((Object)checkName);
    }

    public Pokedex() {
        this(null);
    }

    public Pokedex(UUID uuid) {
        this.uuid = uuid;
        this.seenMap = new HashMap<Integer, EnumPokedexRegisterStatus>();
    }

    public Pokedex setUUID(UUID uuid) {
        this.uuid = uuid;
        return this;
    }

    public NBTTagCompound readFromNBT(NBTTagCompound nbt) {
        this.seenMap.clear();
        NBTTagList nbtl = nbt.func_150295_c("Pokedex", 8);
        for (int i = 0; i < nbtl.func_74745_c(); ++i) {
            try {
                String[] s = nbtl.func_150307_f(i).split(":");
                this.seenMap.put(Integer.parseInt(s[0]), EnumPokedexRegisterStatus.get(Integer.parseInt(s[1])));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return nbt;
    }

    public Map<Integer, EnumPokedexRegisterStatus> getSeenMap() {
        return this.seenMap;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        NBTTagList nbtl = new NBTTagList();
        for (Map.Entry<Integer, EnumPokedexRegisterStatus> e : this.seenMap.entrySet()) {
            nbtl.func_74742_a((NBTBase)new NBTTagString(e.getKey() + ":" + e.getValue().ordinal()));
        }
        nbt.func_74782_a("Pokedex", (NBTBase)nbtl);
        return nbt;
    }

    public void update() {
        EntityPlayerMP player = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_177451_a(this.uuid);
        if (player != null) {
            Pixelmon.network.sendTo((IMessage)new ClientUpdatePokedex(this), player);
        }
    }

    public boolean set(int id, EnumPokedexRegisterStatus drs) {
        if (this.seenMap.containsKey(id) && this.seenMap.get(id).ordinal() > drs.ordinal()) {
            return false;
        }
        if (id > 0 && id <= pokedexSize) {
            this.seenMap.put(id, drs);
            return true;
        }
        this.checkForShinyCharm();
        return false;
    }

    public static boolean set(UUID playerUUID, int id, EnumPokedexRegisterStatus drs) {
        PlayerPartyStorage storage = Pixelmon.storageManager.getParty(playerUUID);
        boolean bool = storage.pokedex.set(id, drs);
        storage.pokedex.update();
        return bool;
    }

    public void wipe() {
        this.seenMap.clear();
        this.update();
    }

    public EnumPokedexRegisterStatus get(int id) {
        EnumPokedexRegisterStatus d = this.seenMap.get(id);
        if (d == null) {
            d = EnumPokedexRegisterStatus.unknown;
        }
        return d;
    }

    public PokedexEntry getEntry(int id) {
        EnumPokedexRegisterStatus d = this.seenMap.get(id);
        if (d == null) {
            d = EnumPokedexRegisterStatus.unknown;
        }
        switch (d) {
            case caught: {
                return fullPokedex.get(id);
            }
            case seen: {
                return new PokedexEntry(id, Pokedex.fullPokedex.get((Object)Integer.valueOf((int)id)).name);
            }
        }
        return new PokedexEntry(id, "???");
    }

    public boolean isUnknown(int id) {
        return this.get(id) == EnumPokedexRegisterStatus.unknown;
    }

    public boolean hasSeen(int id) {
        EnumPokedexRegisterStatus d = this.get(id);
        return d == EnumPokedexRegisterStatus.seen || this.hasCaught(id);
    }

    public boolean hasCaught(int id) {
        return this.get(id) == EnumPokedexRegisterStatus.caught;
    }

    public int countCaught() {
        int count = 0;
        for (int i = 1; i <= pokedexSize; ++i) {
            if (!this.hasCaught(i)) continue;
            ++count;
        }
        return count;
    }

    public int countSeen() {
        int count = 0;
        for (int i = 1; i <= pokedexSize; ++i) {
            if (!this.hasSeen(i)) continue;
            ++count;
        }
        return count;
    }

    @SideOnly(value=Side.CLIENT)
    public void setSeenMap(Map<Integer, EnumPokedexRegisterStatus> seenMap) {
        this.seenMap = seenMap;
    }

    public void checkForShinyCharm() {
        PlayerPartyStorage partyStorage;
        if (PixelmonConfig.allowShinyCharmFromPokedex && this.countCaught() >= pokedexSize && (partyStorage = Pixelmon.storageManager.getParty(this.uuid)).getShinyCharmState() == EnumFeatureState.Disabled) {
            partyStorage.setShinyCharm(EnumFeatureState.Active);
            OpenScreen.open((EntityPlayer)partyStorage.getPlayer(), EnumGuiScreen.ShinyCharm, new int[0]);
        }
    }

    public void setSeenList(HashMap<Integer, EnumPokedexRegisterStatus> data) {
        this.seenMap = data;
    }

    public static class PokedexSpawnData {
        private Biome biome;
        private List<WorldTime> times = Lists.newArrayList();
        private List<WeatherType> weathers = Lists.newArrayList();
        private Integer maxY;
        private Integer minY;

        public PokedexSpawnData(Biome biome) {
            this.biome = biome;
        }

        public Biome getBiome() {
            return this.biome;
        }

        public List<WorldTime> getTimes() {
            return this.times;
        }

        public List<WeatherType> getWeathers() {
            return this.weathers;
        }

        public int getMaxY() {
            return this.maxY;
        }

        public int getMinY() {
            return this.minY;
        }

        public void setMaxY(int maxY) {
            this.maxY = maxY;
        }

        public void setMinY(int minY) {
            this.minY = minY;
        }

        public void addWeather(WeatherType weather) {
            this.weathers.add(weather);
        }

        public void addTime(WorldTime time) {
            this.times.add(time);
        }

        public void encryptTo(ByteBuf buffer) {
            buffer.writeInt(Biome.func_185362_a((Biome)this.biome));
            buffer.writeInt(this.times.size());
            for (WorldTime time : this.times) {
                buffer.writeInt(time.ordinal());
            }
            buffer.writeInt(this.weathers.size());
            for (WeatherType weather : this.weathers) {
                buffer.writeInt(weather.ordinal());
            }
            buffer.writeBoolean(this.maxY != null);
            if (this.maxY != null) {
                buffer.writeInt(this.maxY.intValue());
            }
            buffer.writeBoolean(this.minY != null);
            if (this.minY != null) {
                buffer.writeInt(this.minY.intValue());
            }
        }

        public static PokedexSpawnData decryptFrom(ByteBuf buffer) {
            int i;
            PokedexSpawnData data = new PokedexSpawnData(Biome.func_185357_a((int)buffer.readInt()));
            int size = buffer.readInt();
            for (i = 0; i < size; ++i) {
                data.addTime(WorldTime.values()[buffer.readInt()]);
            }
            size = buffer.readInt();
            for (i = 0; i < size; ++i) {
                data.addWeather(WeatherType.values()[buffer.readInt()]);
            }
            if (buffer.readBoolean()) {
                data.maxY = buffer.readInt();
            }
            if (buffer.readBoolean()) {
                data.minY = buffer.readInt();
            }
            return data;
        }

        public String toString() {
            int i;
            String s = this.biome.field_76791_y;
            if (!this.times.isEmpty()) {
                s = s + " at";
                for (i = 0; i < this.times.size(); ++i) {
                    WorldTime time = this.times.get(i);
                    s = s + (i == 0 ? " " : (i < this.times.size() - 1 ? ", " : ", or ")) + time.getLocalizedName().toLowerCase();
                }
            }
            if (!this.weathers.isEmpty()) {
                s = s + " during";
                for (i = 0; i < this.weathers.size(); ++i) {
                    WeatherType weather = this.weathers.get(i);
                    s = s + (i == 0 ? " " : (i < this.weathers.size() - 1 ? ", " : ", or ")) + weather.getLocalizedName().toLowerCase();
                }
            }
            if (this.minY != null) {
                s = s + " above y=" + this.minY;
            }
            if (this.maxY != null) {
                s = s + " below y=" + this.maxY;
            }
            return s;
        }
    }
}

