/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.config.PixelmonItems;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.EnumSpecialTexture;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import com.pixelmonmod.pixelmon.enums.forms.EnumAlolan;
import com.pixelmonmod.pixelmon.enums.forms.EnumMega;
import com.pixelmonmod.pixelmon.enums.forms.EnumPrimal;
import com.pixelmonmod.pixelmon.enums.forms.IEnumForm;
import com.pixelmonmod.pixelmon.items.PixelmonItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.translation.I18n;

public class ItemPixelmonSprite
extends PixelmonItem {
    public ItemPixelmonSprite() {
        super("pixelmon_sprite");
        this.func_77637_a(null);
        this.func_77625_d(1);
    }

    public String func_77653_i(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return super.func_77653_i(stack);
        }
        if (stack.func_77978_p().func_74764_b("Nickname")) {
            return stack.func_77978_p().func_74779_i("Nickname") + " " + this.getLocalizedName();
        }
        if (stack.func_77978_p().func_74764_b("ndex")) {
            NBTTagCompound compound = stack.func_77978_p();
            EnumSpecies species = EnumSpecies.getFromDex(compound.func_74765_d("ndex"));
            IEnumForm form = species.getFormEnum(compound.func_74771_c("form"));
            boolean shiny = compound.func_74767_n("Shiny");
            String name = species.getLocalizedName();
            if ((form instanceof EnumMega || form instanceof EnumPrimal || form instanceof EnumAlolan) && !form.isDefaultForm()) {
                name = form.getLocalizedName() + " " + name;
            }
            if (shiny) {
                name = I18n.func_74838_a((String)"gui.trainereditor.shiny") + " " + name;
            }
            return name + " " + this.getLocalizedName();
        }
        return super.func_77653_i(stack);
    }

    public static ItemStack getPhoto(Pokemon pokemon) {
        ItemStack itemStack = new ItemStack(PixelmonItems.itemPixelmonSprite);
        NBTTagCompound tagCompound = new NBTTagCompound();
        itemStack.func_77982_d(tagCompound);
        tagCompound.func_74777_a("ndex", (short)pokemon.getSpecies().getNationalPokedexInteger());
        tagCompound.func_74774_a("form", (byte)pokemon.getForm());
        tagCompound.func_74774_a("gender", pokemon.getGender().getForm());
        tagCompound.func_74757_a("Shiny", pokemon.isShiny());
        if (pokemon.getSpecialTexture() != EnumSpecialTexture.None) {
            tagCompound.func_74774_a("specialTexture", (byte)pokemon.getSpecialTexture().id);
        }
        if (!pokemon.getCustomTexture().isEmpty()) {
            tagCompound.func_74778_a("CustomTexture", pokemon.getCustomTexture());
        }
        if (pokemon.getNickname() != null && !pokemon.getNickname().isEmpty()) {
            tagCompound.func_74778_a("Nickname", pokemon.getNickname());
        }
        return itemStack;
    }

    public static ItemStack getPhoto(EntityPixelmon pixelmon) {
        return ItemPixelmonSprite.getPhoto(pixelmon.getPokemonData());
    }
}

