/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.enums.items;

import com.pixelmonmod.pixelmon.client.models.ModelHolder;
import com.pixelmonmod.pixelmon.client.render.tileEntities.SharedModels;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import net.minecraft.util.ResourceLocation;

public enum EnumFossils {
    HELIX(0, 1, EnumSpecies.Omanyte, "helix_fossil"),
    DOME(1, 1, EnumSpecies.Kabuto, "dome_fossil"),
    OLD_AMBER(2, 1, EnumSpecies.Aerodactyl, "old_amber"),
    ROOT(3, 3, EnumSpecies.Lileep, "root_fossil"),
    CLAW(4, 3, EnumSpecies.Anorith, "claw_fossil"),
    SKULL(5, 4, EnumSpecies.Cranidos, "skull_fossil"),
    ARMOR(6, 4, EnumSpecies.Shieldon, "armor_fossil"),
    COVER(7, 5, EnumSpecies.Tirtouga, "cover_fossil"),
    PLUME(8, 5, EnumSpecies.Archen, "plume_fossil"),
    JAW(9, 6, EnumSpecies.Tyrunt, "jaw_fossil"),
    SAIL(10, 6, EnumSpecies.Amaura, "sail_fossil");

    private int index;
    private int generation;
    private EnumSpecies pokemon;
    private String itemName;
    private ResourceLocation texture;

    private EnumFossils(int index, int generation, EnumSpecies pokemon, String itemName) {
        this.index = index;
        this.generation = generation;
        this.pokemon = pokemon;
        this.itemName = itemName;
        this.texture = new ResourceLocation("pixelmon", "textures/fossils/" + this.name().toLowerCase() + "_fossilmodel.png");
    }

    public int getIndex() {
        return this.index;
    }

    public int getGeneration() {
        return this.generation;
    }

    public EnumSpecies getPokemon() {
        return this.pokemon;
    }

    public String getItemName() {
        return this.itemName;
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }

    public ModelHolder getModel() {
        switch (this) {
            case HELIX: {
                return SharedModels.helixFossil;
            }
            case DOME: {
                return SharedModels.domeFossil;
            }
            case OLD_AMBER: {
                return SharedModels.oldAmber;
            }
            case ROOT: {
                return SharedModels.rootFossil;
            }
            case CLAW: {
                return SharedModels.clawFossil;
            }
            case SKULL: {
                return SharedModels.skullFossil;
            }
            case ARMOR: {
                return SharedModels.armorFossil;
            }
            case COVER: {
                return SharedModels.coverFossil;
            }
            case PLUME: {
                return SharedModels.plumeFossil;
            }
            case JAW: {
                return SharedModels.jawFossil;
            }
            case SAIL: {
                return SharedModels.sailFossil;
            }
        }
        return SharedModels.helixFossil;
    }
}

