/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pokeballs;

import com.google.common.collect.ImmutableList;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pokeballs.EnumPokeBallMode;
import com.pixelmonmod.pixelmon.entities.pokeballs.captures.CaptureBase;
import com.pixelmonmod.pixelmon.entities.pokeballs.captures.CaptureBeastBall;
import com.pixelmonmod.pixelmon.entities.pokeballs.captures.CaptureDiveBall;
import com.pixelmonmod.pixelmon.entities.pokeballs.captures.CaptureDuskBall;
import com.pixelmonmod.pixelmon.entities.pokeballs.captures.CaptureFastBall;
import com.pixelmonmod.pixelmon.entities.pokeballs.captures.CaptureFriendBall;
import com.pixelmonmod.pixelmon.entities.pokeballs.captures.CaptureHealBall;
import com.pixelmonmod.pixelmon.entities.pokeballs.captures.CaptureHeavyBall;
import com.pixelmonmod.pixelmon.entities.pokeballs.captures.CaptureLevelBall;
import com.pixelmonmod.pixelmon.entities.pokeballs.captures.CaptureLoveBall;
import com.pixelmonmod.pixelmon.entities.pokeballs.captures.CaptureLureBall;
import com.pixelmonmod.pixelmon.entities.pokeballs.captures.CaptureLuxuryBall;
import com.pixelmonmod.pixelmon.entities.pokeballs.captures.CaptureMoonBall;
import com.pixelmonmod.pixelmon.entities.pokeballs.captures.CaptureNestBall;
import com.pixelmonmod.pixelmon.entities.pokeballs.captures.CaptureNetBall;
import com.pixelmonmod.pixelmon.entities.pokeballs.captures.CaptureQuickBall;
import com.pixelmonmod.pixelmon.entities.pokeballs.captures.CaptureRepeatBall;
import com.pixelmonmod.pixelmon.entities.pokeballs.captures.CaptureSafariBall;
import com.pixelmonmod.pixelmon.entities.pokeballs.captures.CaptureSportBall;
import com.pixelmonmod.pixelmon.entities.pokeballs.captures.CaptureTimerBall;
import com.pixelmonmod.pixelmon.enums.items.EnumPokeballs;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;

public class PokeballTypeHelper {
    public static final List<CaptureBase> captureList;

    public static double getBallBonus(EnumPokeballs type, EntityLivingBase thrower, EntityPixelmon p2, EnumPokeBallMode mode) {
        double ballBonus = type.getBallBonus();
        for (CaptureBase c : captureList) {
            if (c.pokeball != type) continue;
            return c.getBallBonus(type, (EntityPlayer)thrower, p2, mode);
        }
        return ballBonus;
    }

    public static void doAfterEffect(EnumPokeballs type, EntityPixelmon p2) {
        captureList.stream().filter(c -> c.pokeball == type).forEach(c -> c.doAfterEffect(type, p2));
    }

    public static int modifyCaptureRate(EnumPokeballs type, EntityPixelmon pixelmon, int captureRate) {
        for (CaptureBase c : captureList) {
            if (c.pokeball != type) continue;
            return c.modifyCaptureRate(pixelmon, captureRate);
        }
        return captureRate;
    }

    static {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)new CaptureLoveBall());
        builder.add((Object)new CaptureLevelBall());
        builder.add((Object)new CaptureMoonBall());
        builder.add((Object)new CaptureFriendBall());
        builder.add((Object)new CaptureSafariBall());
        builder.add((Object)new CaptureDiveBall());
        builder.add((Object)new CaptureDuskBall());
        builder.add((Object)new CaptureHealBall());
        builder.add((Object)new CaptureLuxuryBall());
        builder.add((Object)new CaptureNetBall());
        builder.add((Object)new CaptureNestBall());
        builder.add((Object)new CaptureHeavyBall());
        builder.add((Object)new CaptureSportBall());
        builder.add((Object)new CaptureQuickBall());
        builder.add((Object)new CaptureLureBall());
        builder.add((Object)new CaptureFastBall());
        builder.add((Object)new CaptureTimerBall());
        builder.add((Object)new CaptureRepeatBall());
        builder.add((Object)new CaptureBeastBall());
        captureList = builder.build();
    }
}

