/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.stats;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.enums.ExperienceGainType;
import com.pixelmonmod.pixelmon.api.events.ExperienceGainEvent;
import com.pixelmonmod.pixelmon.api.events.LevelUpEvent;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.controller.BattleControllerBase;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.comm.PixelmonStatsData;
import com.pixelmonmod.pixelmon.comm.packetHandlers.OpenReplaceMoveScreen;
import com.pixelmonmod.pixelmon.config.PixelmonServerConfig;
import com.pixelmonmod.pixelmon.entities.pixelmon.helpers.EvolutionQuery;
import com.pixelmonmod.pixelmon.entities.pixelmon.helpers.EvolutionQueryList;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Moveset;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Stats;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.links.DelegateLink;
import com.pixelmonmod.pixelmon.enums.ExperienceGroup;
import com.pixelmonmod.pixelmon.enums.items.EnumPokeballs;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class Level {
    protected DelegateLink pixelmon;
    public int expToNextLevel = 0;
    int oldLevel = -1;

    public Level(DelegateLink p) {
        this.pixelmon = p;
    }

    protected void updateStats() {
        this.pixelmon.updateStats();
    }

    public void writeToNBT(NBTTagCompound var1) {
        var1.func_74768_a("Level", this.getLevel());
        var1.func_74768_a("EXP", this.getExp());
        var1.func_74768_a("EXPToNextLevel", this.canLevelUp() ? this.getExpForLevel(this.getLevel() + 1) - this.getExpForLevel(this.getLevel()) : 0);
    }

    public void readFromNBT(NBTTagCompound var1) {
        this.setExp(var1.func_74762_e("EXP"));
        this.setLevel(var1.func_74762_e("Level"));
    }

    public int getLevel() {
        return this.pixelmon.getLevel();
    }

    public void setLevel(int i) {
        this.pixelmon.setLevel(i);
        this.setScale();
        this.updateExpToNextLevel();
        Stats stats = this.pixelmon.getStats();
        if (this.pixelmon.getHealth() == stats.hp || this.pixelmon.getHealth() == -1) {
            this.updateStats();
            this.pixelmon.setHealthDirect(this.pixelmon.getStats().hp);
        } else {
            float oldHP = stats.hp;
            float oldHealth = this.pixelmon.getHealth();
            this.updateStats();
            float newHealth = stats.hp;
            if (oldHP != 0.0f) {
                newHealth = oldHealth / oldHP * (float)stats.hp;
            }
            this.pixelmon.setHealthDirect((int)Math.ceil(newHealth));
        }
    }

    public void updateExpToNextLevel() {
        this.expToNextLevel = this.getLevel() == 1 ? this.getExpForLevel(this.getLevel() + 1) : (this.canLevelUp() ? this.getExpForLevel(this.getLevel() + 1) - this.getExpForLevel(this.getLevel()) : 0);
    }

    private int getExpForLevel(int l) {
        ExperienceGroup ex = this.pixelmon.getBaseStats().experienceGroup;
        if (ex == ExperienceGroup.Erratic) {
            if (l <= 50) {
                return (100 - l) * (l * l * l) / 50;
            }
            if (l <= 68) {
                return (150 - l) * (l * l * l) / 100;
            }
            if (l <= 98) {
                return (191 - l) * (l * l * l) / 150;
            }
            if (l <= 100) {
                return (160 - l) * (l * l * l) / 100;
            }
            return 60 * (l * l * l) / 100;
        }
        if (ex == ExperienceGroup.Fast) {
            return (int)(0.8 * (double)l * (double)l * (double)l);
        }
        if (ex == ExperienceGroup.MediumFast) {
            return l * l * l;
        }
        if (ex == ExperienceGroup.MediumSlow) {
            return l == 2 ? 9 : (int)(1.2 * (double)l * (double)l * (double)l - (double)(15 * l * l) + (double)(100 * l) - 140.0);
        }
        if (ex == ExperienceGroup.Slow) {
            return (int)(1.25 * (double)l * (double)l * (double)l);
        }
        if (ex == ExperienceGroup.Fluctuating) {
            if (l <= 15) {
                return (l + 73) * (l * l * l) / 150;
            }
            if (l <= 36) {
                return (l + 14) * (l * l * l) / 50;
            }
            return (l + 64) * (l * l * l) / 100;
        }
        return -1;
    }

    public int getExp() {
        return this.pixelmon.getExp();
    }

    public void setExp(int experience) {
        this.pixelmon.setExp(experience);
    }

    public boolean canLevelUp() {
        return this.getLevel() < PixelmonServerConfig.maxLevel;
    }

    protected void onLevelUp(PixelmonStatsData stats) {
        this.updateStats();
        this.pixelmon.updateLevelUp(stats);
        int amount = this.pixelmon.getFriendship() < 100 ? 5 : (this.pixelmon.getFriendship() < 200 ? 3 : 2);
        this.pixelmon.adjustFriendship(amount + (this.pixelmon.getCaughtBall() == EnumPokeballs.LuxuryBall ? 1 : 0));
        this.setScale();
    }

    public void awardEXP(int experience) {
        this.awardEXP(experience, ExperienceGainType.UNKNOWN);
    }

    public void awardEXP(int experience, ExperienceGainType type) {
        if (!this.pixelmon.doesLevel()) {
            return;
        }
        ExperienceGainEvent event = new ExperienceGainEvent(this.pixelmon, experience, type);
        if (Pixelmon.EVENT_BUS.post((Event)event)) {
            return;
        }
        experience = event.getExperience();
        this.setExp(this.getExp() + experience);
        EntityPlayerMP owner = this.pixelmon.getPlayerOwner();
        BattleControllerBase bc = this.pixelmon.getBattleController();
        if (owner != null && this.canLevelUp() && experience > 0) {
            TextComponentTranslation message = ChatHandler.getMessage("pixelmon.stats.gainexp", this.pixelmon.getRealNickname(), experience);
            if (bc == null) {
                ChatHandler.sendChat((ICommandSender)owner, message);
            } else {
                bc.sendToPlayer((EntityPlayer)owner, message);
            }
        }
        if (!this.canLevelUp() || this.expToNextLevel == -1) {
            this.setExp(0);
            return;
        }
        if (owner == null) {
            return;
        }
        boolean isReplacingMove = false;
        boolean didLevel = false;
        while (this.getExp() >= this.expToNextLevel) {
            int xp = this.getExp();
            this.pixelmon.update(EnumUpdateType.Name);
            int newExp = this.getExp() - this.expToNextLevel;
            if (!this.canLevelUp() || Pixelmon.EVENT_BUS.post((Event)new LevelUpEvent(owner, this.pixelmon, this.getLevel() + 1))) break;
            didLevel = true;
            PixelmonStatsData stats = PixelmonStatsData.createPacket(this.pixelmon);
            this.setLevel(this.getLevel() + 1);
            this.onLevelUp(stats);
            this.setExp(newExp);
            int newLevel = this.getLevel();
            ArrayList<Attack> newAttacks = this.pixelmon.getBaseStats().getMovesAtLevel(newLevel);
            for (Attack a : newAttacks) {
                Moveset moveset = this.pixelmon.getMoveset();
                if (moveset.hasAttack(a)) continue;
                if (moveset.size() >= 4) {
                    isReplacingMove = true;
                    Pixelmon.network.sendTo((IMessage)new OpenReplaceMoveScreen(this.pixelmon.getPokemonUUID(), a.getActualMove().getAttackId(), true), owner);
                    continue;
                }
                moveset.add(a);
                this.pixelmon.update(EnumUpdateType.Moveset);
                TextComponentTranslation message = ChatHandler.getMessage("pixelmon.stats.learnedmove", this.pixelmon.getRealNickname(), a.getActualMove().getTranslatedName());
                if (bc != null) {
                    ChatHandler.sendBattleMessage((Entity)owner, message);
                    continue;
                }
                ChatHandler.sendChat((ICommandSender)owner, message);
            }
            if (bc == null || bc.rules.levelCap >= PixelmonServerConfig.maxLevel || bc.rules.levelCap < newLevel) continue;
            this.setExp(0);
            break;
        }
        this.pixelmon.update(EnumUpdateType.Stats);
        if (didLevel && !isReplacingMove) {
            if (this.pixelmon.getBattleController() == null) {
                this.pixelmon.pokemon.tryEvolution();
            } else {
                this.pixelmon.getBattleController().checkedPokemon.add(this.pixelmon.pokemon);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkForExistingEvolutionQuery() {
        List<EvolutionQuery> list = EvolutionQueryList.queryList;
        synchronized (list) {
            for (int i = 0; i < EvolutionQueryList.queryList.size(); ++i) {
                if (!EvolutionQueryList.queryList.get((int)i).pokemonUUID.equals(this.pixelmon.getPokemonUUID())) continue;
                return true;
            }
        }
        return false;
    }

    private void setScale() {
        float percent = 1.0f;
        percent = 0.8f + 0.4f * (float)this.getLevel() / (float)PixelmonServerConfig.maxLevel;
        this.pixelmon.setScale(percent);
    }

    public void recalculateXP() {
        this.setExp(0);
        this.expToNextLevel = this.getExpForLevel(this.getLevel() + 1) - this.getExpForLevel(this.getLevel());
    }

    public int getExpForNextLevelClient() {
        if (this.oldLevel != this.getLevel()) {
            this.expToNextLevel = this.getExpForLevel(this.getLevel() + 1) - this.getExpForLevel(this.getLevel());
            this.oldLevel = this.getLevel();
        }
        return this.expToNextLevel;
    }

    public float getExpFraction() {
        return Level.getExpFraction(this.getExp(), this.expToNextLevel);
    }

    public static float getExpFraction(int exp, int expToNextLevel) {
        if (expToNextLevel == 0) {
            return 0.0f;
        }
        return (float)exp / (float)expToNextLevel;
    }
}

