/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.stats;

import com.google.common.collect.Sets;
import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.BaseStats;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import com.pixelmonmod.pixelmon.enums.forms.IEnumForm;
import java.util.Set;

public enum Gender implements IEnumForm
{
    Male,
    Female,
    None;

    public static final Set<EnumSpecies> mfModels;

    @Override
    public String getSpriteSuffix() {
        return this == None ? "" : "-" + this.name().toLowerCase();
    }

    @Override
    public String getFormSuffix() {
        return this == None ? "" : this.name().toLowerCase();
    }

    @Override
    public byte getForm() {
        return (byte)this.ordinal();
    }

    @Override
    public String getUnlocalizedName() {
        return "pixelmon.gender.form." + this.name().toLowerCase();
    }

    public boolean isCompatible(Gender otherGender) {
        return this == Male && otherGender == Female || this == Female && otherGender == Male;
    }

    public static Gender getGender(short ord) {
        for (Gender g : Gender.values()) {
            if (g.ordinal() != ord) continue;
            return g;
        }
        return Male;
    }

    public static Gender getGender(String name) {
        for (Gender gender : Gender.values()) {
            if (!gender.name().toLowerCase().startsWith(name.toLowerCase())) continue;
            return gender;
        }
        return null;
    }

    public static Gender getRandomGender(BaseStats baseStats) {
        if (baseStats.malePercent < 0) {
            return None;
        }
        if (RandomHelper.rand.nextInt(100) < baseStats.malePercent) {
            return Male;
        }
        return Female;
    }

    static {
        mfModels = Sets.newHashSet((Object[])new EnumSpecies[]{EnumSpecies.Unfezant, EnumSpecies.Frillish, EnumSpecies.Jellicent, EnumSpecies.Pyroar});
    }
}

