/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.specs;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.pokemon.ISpecType;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.SpecValue;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.EnumSpecialTexture;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;

public class SpecialTextureSpec
extends SpecValue<EnumSpecialTexture>
implements ISpecType {
    public SpecialTextureSpec(EnumSpecialTexture value) {
        super("specialTexture", value);
    }

    @Override
    public List<String> getKeys() {
        return Lists.newArrayList((Object[])new String[]{"st", "specialTexture", "special-texture"});
    }

    @Override
    public SpecValue<?> parse(@Nullable String arg) {
        EnumSpecialTexture texture;
        if (arg != null && (texture = EnumSpecialTexture.fromName(arg)) != EnumSpecialTexture.Online) {
            return new SpecialTextureSpec(texture);
        }
        return new SpecialTextureSpec(null);
    }

    @Override
    public SpecValue<?> readFromNBT(NBTTagCompound nbt) {
        byte bite = nbt.func_74771_c("specialTexture");
        if (bite == -1) {
            return new SpecialTextureSpec(null);
        }
        return new SpecialTextureSpec(EnumSpecialTexture.fromIndex(bite));
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, SpecValue<?> value) {
        if (value.value != null) {
            nbt.func_74774_a("specialTexture", (byte)((EnumSpecialTexture)((Object)value.value)).id);
        } else {
            nbt.func_74774_a("specialTexture", (byte)-1);
        }
    }

    @Override
    public Class<? extends SpecValue<?>> getSpecClass() {
        return SpecialTextureSpec.class;
    }

    @Override
    public String toParameterForm(SpecValue<?> value) {
        return value.key + ":" + value.value.toString();
    }

    @Override
    public Class<EnumSpecialTexture> getValueClass() {
        return EnumSpecialTexture.class;
    }

    @Override
    public void apply(EntityPixelmon pixelmon) {
        this.apply(pixelmon.getPokemonData());
    }

    @Override
    public void apply(Pokemon pokemon) {
        if (pokemon.getSpecies().hasSpecialTexture()) {
            if (this.value == null) {
                pokemon.setSpecialTexture(pokemon.getSpecies().getSpecialTexture());
            } else {
                pokemon.setSpecialTexture((EnumSpecialTexture)((Object)this.value));
            }
        }
    }

    @Override
    public boolean matches(EntityPixelmon pixelmon) {
        return this.matches(pixelmon.getPokemonData());
    }

    @Override
    public boolean matches(Pokemon pokemon) {
        return pokemon.getSpecialTexture() == this.value;
    }

    @Override
    public SpecValue<EnumSpecialTexture> clone() {
        return new SpecialTextureSpec((EnumSpecialTexture)((Object)this.value));
    }
}

