/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.specs;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.pokemon.ISpecType;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.SpecValue;
import com.pixelmonmod.pixelmon.config.PixelmonItemsHeld;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.enums.EnumMegaPokemon;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import com.pixelmonmod.pixelmon.enums.forms.EnumGreninja;
import com.pixelmonmod.pixelmon.enums.forms.EnumPrimal;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import com.pixelmonmod.pixelmon.items.heldItems.ItemMegaStone;
import com.pixelmonmod.pixelmon.items.heldItems.NoItem;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;

public class CanMegaEvoSpec
extends SpecValue<Boolean>
implements ISpecType {
    public CanMegaEvoSpec(boolean value) {
        super("canmegaevo", value);
    }

    @Override
    public List<String> getKeys() {
        return Lists.newArrayList((Object[])new String[]{"canmegaevo", "canmega", "canmegaevolve"});
    }

    @Override
    public SpecValue<?> parse(@Nullable String arg) {
        try {
            return new CanMegaEvoSpec(arg == null ? true : Boolean.parseBoolean(arg));
        }
        catch (Exception e) {
            return new CanMegaEvoSpec(true);
        }
    }

    @Override
    public SpecValue<?> readFromNBT(NBTTagCompound nbt) {
        return new CanMegaEvoSpec(nbt.func_74767_n(this.key));
    }

    public void writeToNBT(NBTTagCompound nbt, SpecValue value) {
        nbt.func_74757_a(this.key, ((Boolean)value.value).booleanValue());
    }

    @Override
    public Class<? extends SpecValue<?>> getSpecClass() {
        return CanMegaEvoSpec.class;
    }

    @Override
    public String toParameterForm(SpecValue<?> value) {
        return this.key + ":" + value.value.toString();
    }

    @Override
    public Class<Boolean> getValueClass() {
        return Boolean.class;
    }

    @Override
    public void apply(EntityPixelmon pixelmon) {
    }

    @Override
    public void apply(Pokemon pokemon) {
    }

    @Override
    public boolean matches(EntityPixelmon pixelmon) {
        return this.matches(pixelmon.getPokemonData());
    }

    @Override
    public boolean matches(Pokemon pokemon) {
        if (pokemon.getSpecies() == EnumSpecies.Rayquaza) {
            return pokemon.getMoveset().hasAttack("Dragon Ascent");
        }
        if (pokemon.getSpecies() == EnumSpecies.Necrozma) {
            return (pokemon.getForm() == 1 || pokemon.getForm() == 2) && pokemon.getHeldItem().func_77973_b() == PixelmonItemsHeld.ultranecrozium_z;
        }
        EnumMegaPokemon mega = EnumMegaPokemon.getMega(pokemon.getSpecies());
        if (mega != null && mega.getMegaEvoItems().length == 0) {
            return true;
        }
        if (pokemon.getSpecies() == EnumSpecies.Groudon) {
            return pokemon.getFormEnum() == EnumPrimal.PRIMAL || pokemon.getHeldItemAsItemHeld() == PixelmonItemsHeld.redOrb;
        }
        if (pokemon.getSpecies() == EnumSpecies.Kyogre) {
            return pokemon.getFormEnum() == EnumPrimal.PRIMAL || pokemon.getHeldItemAsItemHeld() == PixelmonItemsHeld.blueOrb;
        }
        if (pokemon.getSpecies() == EnumSpecies.Greninja && pokemon.getFormEnum() == EnumGreninja.BATTLE_BOND) {
            return true;
        }
        if (pokemon.getHeldItemAsItemHeld() == NoItem.noItem) {
            return false;
        }
        if (pokemon.getHeldItemAsItemHeld().getHeldItemType() == EnumHeldItems.megaStone) {
            return ((ItemMegaStone)pokemon.getHeldItemAsItemHeld()).pokemon == pokemon.getSpecies();
        }
        return false;
    }

    @Override
    public SpecValue<Boolean> clone() {
        return new CanMegaEvoSpec((Boolean)this.value);
    }
}

