/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.moveSkills;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.moveskills.MoveSkill;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonSpec;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.config.PixelmonItemsHeld;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.helpers.EvolutionQuery;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import com.pixelmonmod.pixelmon.enums.forms.EnumGreninja;
import com.pixelmonmod.pixelmon.items.ItemHeld;
import com.pixelmonmod.pixelmon.items.heldItems.ItemMegaStone;
import com.pixelmonmod.pixelmon.storage.PlayerPartyStorage;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;

public class MegaEvolution {
    public static MoveSkill createMoveSkill() {
        MoveSkill moveSkill = new MoveSkill(new ResourceLocation("pixelmon", "mega_evolve")).setName("pixelmon.moveskill.mega_evolve.name").describe("pixelmon.moveskill.mega_evolve.description").setIcon(new ResourceLocation("pixelmon", "textures/gui/overlay/externalMoves/mega.png")).setDefaultCooldownTicks(20).setUsePP(false).setAbleSpecs(Lists.newArrayList((Object[])new PokemonSpec[]{new PokemonSpec("canmega")}));
        moveSkill.id = "externalmoves.mega evolve.name";
        return moveSkill.setBehaviourNoTarget(pixelmon -> {
            if (pixelmon.func_70902_q() == null || pixelmon.getFormEnum().isTemporary()) return moveSkill.cooldownTicks;
            PlayerPartyStorage party = pixelmon.getPlayerParty();
            if (party == null) {
                return -1;
            }
            if (pixelmon.getSpecies() == EnumSpecies.Kyogre && pixelmon.getPokemonData().getHeldItemAsItemHeld() == PixelmonItemsHeld.blueOrb || pixelmon.getSpecies() == EnumSpecies.Groudon && pixelmon.getPokemonData().getHeldItemAsItemHeld() == PixelmonItemsHeld.redOrb) {
                pixelmon.setForm(1 - pixelmon.getPokemonData().getForm());
            }
            if (pixelmon.getSpecies() == EnumSpecies.Greninja && pixelmon.getFormEnum() == EnumGreninja.BATTLE_BOND) {
                new EvolutionQuery((EntityPixelmon)((Object)pixelmon), EnumGreninja.ASH.getForm());
                return moveSkill.cooldownTicks;
            } else if (pixelmon.getSpecies() == EnumSpecies.Rayquaza && EnumSpecies.Rayquaza.hasMega()) {
                new EvolutionQuery((EntityPixelmon)((Object)pixelmon), 1);
                return moveSkill.cooldownTicks;
            } else if (pixelmon.getSpecies() == EnumSpecies.Necrozma && (pixelmon.getPokemonData().getForm() == 1 || pixelmon.getPokemonData().getForm() == 2) && pixelmon.getPokemonData().getHeldItemAsItemHeld() == PixelmonItemsHeld.ultranecrozium_z && EnumSpecies.Necrozma.hasMega()) {
                pixelmon.getPokemonData().getPersistentData().func_74768_a("SrcForm", pixelmon.getPokemonData().getForm());
                new EvolutionQuery((EntityPixelmon)((Object)pixelmon), 3);
                return moveSkill.cooldownTicks;
            } else {
                ItemHeld held = pixelmon.getPokemonData().getHeldItemAsItemHeld();
                if (!(held instanceof ItemMegaStone) || ((ItemMegaStone)held).pokemon != pixelmon.getSpecies()) return -1;
                ItemMegaStone stone = (ItemMegaStone)held;
                if (party.getMegaItem().canEvolve()) {
                    new EvolutionQuery((EntityPixelmon)((Object)pixelmon), stone.form);
                    return moveSkill.cooldownTicks;
                } else {
                    ChatHandler.sendChat((Entity)pixelmon.func_70902_q(), "pixelmon.moveskill.mega_evolve.noring", new Object[0]);
                    return -1;
                }
            }
        });
    }
}

