/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.moveSkills;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.moveskills.MoveSkill;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.StatsType;
import com.pixelmonmod.pixelmon.tools.LineCalc;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class Dig {
    public static ArrayList<Block> allowedBlocks = new ArrayList();

    public static MoveSkill createMoveSkill() {
        allowedBlocks = Lists.newArrayList((Object[])new Block[]{Blocks.field_150349_c, Blocks.field_150354_m, Blocks.field_150322_A, Blocks.field_150435_aG, Blocks.field_150348_b, Blocks.field_150351_n, Blocks.field_150391_bh, Blocks.field_150346_d});
        MoveSkill moveSkill = new MoveSkill(new ResourceLocation("pixelmon", "dig")).setName("pixelmon.moveskill.dig.name").describe("pixelmon.moveskill.dig.description1", "pixelmon.moveskill.dig.description2").setIcon(new ResourceLocation("pixelmon", "textures/gui/overlay/externalMoves/dig.png")).setAnyMoves("Dig").setUsePP(true);
        moveSkill.id = "externalmoves.dig.name";
        moveSkill.setBehaviourBlockTarget((pixelmon, tup) -> {
            if (!PixelmonConfig.allowDestructiveExternalMoves) {
                return -1;
            }
            EnumFacing sideHit = (EnumFacing)tup.func_76340_b();
            BlockPos pos = (BlockPos)tup.func_76341_a();
            int depth = 74 - (int)(((float)pixelmon.getPokemonData().getStat(StatsType.Attack) - 20.0f) / 180.0f * 74.0f);
            if (depth < 2) {
                depth = 2;
            }
            int maxOff = 1;
            if (pixelmon.getPokemonData().getStat(StatsType.Attack) > 150) {
                maxOff = 2;
            }
            if (pixelmon.getPokemonData().getStat(StatsType.Attack) > 300) {
                maxOff = 3;
            }
            if (pos.func_177956_o() < depth) {
                pixelmon.field_70170_p.func_184133_a(null, pos, SoundEvents.field_187689_f, SoundCategory.NEUTRAL, 0.3f, 0.1f);
            } else {
                int yOff;
                int xOff;
                if (sideHit == EnumFacing.UP) {
                    for (xOff = -1 * maxOff; xOff <= maxOff; ++xOff) {
                        for (int zOff = -1 * maxOff; zOff <= maxOff; ++zOff) {
                            Dig.doHarvest(pixelmon, pos.func_177982_a(xOff, 0, zOff));
                        }
                    }
                } else if (sideHit == EnumFacing.DOWN) {
                    for (xOff = -1 * maxOff; xOff <= maxOff; ++xOff) {
                        for (int zOff = -1 * maxOff; zOff <= maxOff; ++zOff) {
                            Dig.doHarvest(pixelmon, pos.func_177982_a(xOff, 0, zOff));
                        }
                    }
                } else if (sideHit == EnumFacing.SOUTH) {
                    for (xOff = -1 * maxOff; xOff <= maxOff; ++xOff) {
                        for (int yOff2 = -1 * maxOff; yOff2 <= maxOff; ++yOff2) {
                            Dig.doHarvest(pixelmon, pos.func_177982_a(xOff, yOff2, 0));
                        }
                    }
                } else if (sideHit == EnumFacing.NORTH) {
                    for (xOff = -1 * maxOff; xOff <= maxOff; ++xOff) {
                        for (int yOff3 = -1 * maxOff; yOff3 <= maxOff; ++yOff3) {
                            Dig.doHarvest(pixelmon, pos.func_177982_a(xOff, yOff3, 0));
                        }
                    }
                } else if (sideHit == EnumFacing.EAST) {
                    for (yOff = -1 * maxOff; yOff <= maxOff; ++yOff) {
                        for (int zOff = -1 * maxOff; zOff <= maxOff; ++zOff) {
                            Dig.doHarvest(pixelmon, pos.func_177982_a(0, yOff, zOff));
                        }
                    }
                } else if (sideHit == EnumFacing.WEST) {
                    for (yOff = -1 * maxOff; yOff <= maxOff; ++yOff) {
                        for (int zOff = -1 * maxOff; zOff <= maxOff; ++zOff) {
                            Dig.doHarvest(pixelmon, pos.func_177982_a(0, yOff, zOff));
                        }
                    }
                }
                pixelmon.field_70170_p.func_184133_a(null, pos, SoundEvents.field_187571_bR, SoundCategory.NEUTRAL, 1.0f, 0.1f);
            }
            float speed = pixelmon.getPokemonData().getStat(StatsType.Speed);
            return (int)(300.0f * (1.0f - LineCalc.lerp(speed, 1.0f, 200.0f, 0.0f, 0.5f)));
        });
        return moveSkill;
    }

    private static void doHarvest(EntityPixelmon user, BlockPos pos) {
        EntityPlayerMP player;
        boolean flag;
        IBlockState state = user.field_70170_p.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (allowedBlocks.contains(block) && (flag = block.canHarvestBlock((IBlockAccess)user.field_70170_p, pos, (EntityPlayer)(player = (EntityPlayerMP)user.func_70902_q()))) && Dig.removeBlock(pos, user.field_70170_p, player, true)) {
            block.func_176226_b(user.field_70170_p, pos, state, 0);
        }
    }

    private static boolean removeBlock(BlockPos pos, World theWorld, EntityPlayerMP playerMP, boolean canHarvest) {
        IBlockState iblockstate = theWorld.func_180495_p(pos);
        boolean flag = false;
        Block block = iblockstate.func_177230_c();
        block.func_176208_a(theWorld, pos, iblockstate, (EntityPlayer)playerMP);
        flag = block.removedByPlayer(iblockstate, theWorld, pos, (EntityPlayer)playerMP, canHarvest);
        if (flag) {
            block.func_176206_d(theWorld, pos, iblockstate);
        }
        return flag;
    }
}

