/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.interactions.custom;

import com.google.common.collect.Maps;
import com.pixelmonmod.pixelmon.entities.pixelmon.Entity1Base;
import com.pixelmonmod.pixelmon.entities.pixelmon.Entity4Interactions;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityBreeding;
import com.pixelmonmod.pixelmon.entities.pixelmon.interactions.custom.CameruptInteraction;
import com.pixelmonmod.pixelmon.entities.pixelmon.interactions.custom.MareepInteraction;
import com.pixelmonmod.pixelmon.entities.pixelmon.interactions.custom.MiltankInteraction;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import java.util.EnumMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;

public abstract class PixelmonInteraction {
    public int maxInteractions;
    public int counter = 400;
    private static EnumMap<EnumSpecies, Class<? extends PixelmonInteraction>> pixelmonInteractions = Maps.newEnumMap(EnumSpecies.class);

    public PixelmonInteraction(int maxInteractions) {
        this.maxInteractions = maxInteractions;
    }

    public boolean processInteract(Entity1Base pixelmon, EntityPlayer player, EnumHand hand, ItemStack itemstack) {
        if (pixelmon instanceof Entity4Interactions) {
            Entity4Interactions poke = (Entity4Interactions)pixelmon;
            poke.setNumInteractions(poke.getNumInteractions() - 1);
        } else if (pixelmon instanceof EntityBreeding) {
            EntityBreeding poke = (EntityBreeding)pixelmon;
            poke.setNumInteractions(poke.getNumInteractions() - 1);
        }
        if (this.counter <= 0) {
            this.resetCounter(pixelmon);
        }
        return true;
    }

    public void resetCounter(Entity1Base pixelmon) {
        if (!pixelmon.field_70170_p.field_72995_K) {
            this.counter = pixelmon.func_70681_au().nextInt(600) + 800;
        }
    }

    public static PixelmonInteraction getInteraction(EnumSpecies species) {
        if (pixelmonInteractions.containsKey(species)) {
            Class<? extends PixelmonInteraction> c = pixelmonInteractions.get(species);
            try {
                return c.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    static {
        pixelmonInteractions.put(EnumSpecies.Miltank, MiltankInteraction.class);
        pixelmonInteractions.put(EnumSpecies.Camerupt, CameruptInteraction.class);
        pixelmonInteractions.put(EnumSpecies.Mareep, MareepInteraction.class);
    }
}

