/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.events.RidePokemonEvent;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.config.PixelmonServerConfig;
import com.pixelmonmod.pixelmon.entities.SpawnLocationType;
import com.pixelmonmod.pixelmon.entities.pixelmon.Entity3HasStats;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.helpers.AIHelper;
import com.pixelmonmod.pixelmon.entities.pixelmon.interactions.custom.PixelmonInteraction;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Moveset;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.RidingOffsets;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.StatsType;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import com.pixelmonmod.pixelmon.storage.PlayerPartyStorage;
import javax.vecmath.Vector3f;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.eventhandler.Event;

public abstract class Entity4Interactions
extends Entity3HasStats {
    static final DataParameter<Byte> dwNumInteractions = EntityDataManager.func_187226_a(Entity4Interactions.class, (DataSerializer)DataSerializers.field_187191_a);
    public int ridingPlayerVertical;
    public boolean isFlying = false;
    private int initAir = 0;
    private boolean ridingInitialised = false;
    protected AIHelper aiHelper;
    public int aggressionTimer = 0;
    private PixelmonInteraction interaction;
    private int numInteractions = 0;
    public float mountBoost = 1.0f;
    public ResourceLocation skillId;
    public int targetX;
    public int targetY;
    public int targetZ;
    public EnumFacing targetSide;

    public Entity4Interactions(World par1World) {
        super(par1World);
        this.field_70180_af.func_187214_a(dwNumInteractions, (Object)0);
    }

    public AIHelper getAIHelper() {
        if (this.aiHelper == null) {
            this.resetAI();
        }
        return this.aiHelper;
    }

    public void resetAI() {
        this.aiHelper = new AIHelper(this.getPokemonName(), this, this.field_70714_bg);
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (player.field_70170_p.field_72995_K) {
            return super.func_184645_a(player, hand);
        }
        if (this.interaction != null && this.getNumInteractions() > 0 && this.interaction.processInteract(this, player, hand, player.func_184586_b(hand))) {
            return true;
        }
        if (hand == EnumHand.MAIN_HAND) {
            boolean allowMount;
            if (player.func_184218_aH() || !PixelmonConfig.allowRiding || !this.getBaseStats().isRideable.booleanValue() || !this.belongsTo(player)) {
                return super.func_184645_a(player, hand);
            }
            if (!(PixelmonConfig.landMount || this.canFly() || this.canSurf())) {
                return super.func_184645_a(player, hand);
            }
            boolean bl = allowMount = !Pixelmon.EVENT_BUS.post((Event)new RidePokemonEvent((EntityPlayerMP)player, (EntityPixelmon)this));
            if (!allowMount) {
                return super.func_184645_a(player, hand);
            }
            player.func_184220_m((Entity)this);
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    public boolean canFly() {
        if (PixelmonConfig.requireHM) {
            Moveset moves = this.getPokemonData().getMoveset();
            return this.getBaseStats().canFly != false && moves.hasAttack("Fly");
        }
        return this.getBaseStats().canFly;
    }

    public boolean canSurf() {
        if (PixelmonConfig.requireHM) {
            Moveset moves = this.getPokemonData().getMoveset();
            return this.getBaseStats().canSurf != false && moves.hasAttack("Surf");
        }
        return this.getBaseStats().canSurf;
    }

    public void onSendout() {
        if (!this.field_70170_p.field_72995_K && this.interaction == null) {
            this.interaction = PixelmonInteraction.getInteraction(this.getSpecies());
            if (this.interaction != null) {
                this.setNumInteractions(this.pokemon.getPersistentData().func_74771_c("NumInteractions"));
                this.interaction.counter = this.pokemon.getPersistentData().func_74765_d("InteractionCount");
                if (this.interaction.counter == -1 && this.interaction.maxInteractions != this.getNumInteractions()) {
                    this.interaction.resetCounter(this);
                }
            }
        }
    }

    public double func_70042_X() {
        return (double)this.field_70131_O * 0.9;
    }

    public void func_191986_a(float strafe, float up, float forward) {
        this.field_70138_W = 0.5f;
        SpawnLocationType location = this.getSpawnLocation();
        if (location == SpawnLocationType.AirPersistent) {
            this.field_70181_x = 0.0;
        }
        if (this.getBaseStats() == null || this.func_184188_bt().size() == 0) {
            if (this.getBaseStats() != null && !this.getBaseStats().canFly.booleanValue() && this.getSpawnLocation() == SpawnLocationType.Water && this.func_70090_H()) {
                float f4 = 0.9f;
                float f5 = 0.02f;
                float f6 = EnchantmentHelper.func_185294_d((EntityLivingBase)this);
                if (f6 > 3.0f) {
                    f6 = 3.0f;
                }
                if (!this.field_70122_E) {
                    f6 *= 0.5f;
                }
                if (f6 > 0.0f) {
                    f4 += (0.54600006f - f4) * f6 / 3.0f;
                    f5 += (this.func_70689_ay() * 1.0f - f5) * f6 / 3.0f;
                }
                this.func_191958_b(strafe, 0.0f, forward, f5);
                this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                this.field_70159_w *= (double)f4;
                this.field_70181_x *= (double)0.8f;
                this.field_70179_y *= (double)f4;
                this.field_70181_x -= 0.02;
                if (this.field_70123_F && this.func_70038_c(this.field_70159_w, this.field_70181_x + (double)0.6f, this.field_70179_y)) {
                    this.field_70181_x = 0.3f;
                }
            } else {
                super.func_191986_a(strafe, up, forward);
            }
            return;
        }
        if (this.func_184188_bt().size() > 0 && this.func_184179_bs() instanceof EntityLivingBase) {
            EntityLivingBase rider = (EntityLivingBase)this.func_184179_bs();
            if (PixelmonConfig.enablePointToSteer) {
                this.field_70126_B = this.field_70177_z = this.func_184179_bs().field_70177_z;
            }
            strafe = rider.field_70702_br * 0.5f * PixelmonServerConfig.ridingSpeedMultiplier;
            this.field_70177_z -= strafe * 10.0f;
            strafe = 0.0f;
            this.field_70125_A = this.func_184179_bs().field_70125_A * 0.5f;
            this.field_70759_as = this.field_70761_aq = this.field_70177_z;
            forward = rider.field_191988_bg * PixelmonServerConfig.ridingSpeedMultiplier;
            this.moveMounted(strafe, up, forward);
            if (PixelmonConfig.enablePointToSteer) {
                rider.field_70760_ar = rider.field_70761_aq = this.field_70761_aq;
                rider.field_70126_B = rider.field_70177_z = this.field_70177_z;
            }
            this.field_184618_aE = this.field_70721_aZ;
            double var9 = this.field_70165_t - this.field_70169_q;
            double var12 = this.field_70161_v - this.field_70166_s;
            float var11 = MathHelper.func_76133_a((double)(var9 * var9 + var12 * var12)) * 4.0f;
            if (var11 > 1.0f) {
                var11 = 1.0f;
            }
            this.field_70721_aZ += (var11 - this.field_70721_aZ) * 0.4f;
            this.field_184619_aG += this.field_70721_aZ;
            if (this.field_70170_p.field_72995_K) {
                boolean bl = this.field_70122_E = !this.field_70170_p.func_175623_d(new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76141_d((float)(MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1)), MathHelper.func_76128_c((double)this.field_70161_v)));
            }
        }
        if (location == SpawnLocationType.AirPersistent) {
            this.field_70181_x = 0.0;
        }
        if (location == SpawnLocationType.Air && this.isFlying) {
            this.field_70181_x -= 0.01;
        }
    }

    @Override
    public void func_180430_e(float distance, float damageMultiplier) {
        if (this.getBaseStats() != null && this.canFly()) {
            return;
        }
        if (this.func_184207_aI() && distance < 4.0f) {
            return;
        }
        super.func_180430_e(distance, damageMultiplier);
    }

    private void moveMounted(float strafe, float up, float forward) {
        if (this.func_184179_bs() != null && this.canSurf() && this.field_70171_ac) {
            double var9 = this.field_70163_u;
            this.func_191958_b(strafe, 0.0f, forward, this.field_70747_aH);
            this.func_70091_d(MoverType.SELF, this.field_70159_w * (double)this.mountBoost, this.field_70181_x, this.field_70179_y * (double)this.mountBoost);
            if (this.field_70123_F && this.func_70038_c(this.field_70159_w, this.field_70181_x + (double)0.6f - this.field_70163_u + var9, this.field_70179_y)) {
                this.field_70181_x = 0.3f;
            }
            this.field_70181_x *= (double)0.98f;
            this.field_70159_w *= (double)0.96f;
            this.field_70179_y *= (double)0.96f;
            return;
        }
        if (this.canFly() && !this.func_70090_H() && !this.func_180799_ab()) {
            float var3 = 0.91f;
            if (this.field_70122_E) {
                var3 = 0.54600006f;
                IBlockState state = this.field_70170_p.func_180495_p(new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1, MathHelper.func_76128_c((double)this.field_70161_v)));
                if (state.func_185904_a() != Material.field_151579_a) {
                    var3 = state.func_177230_c().field_149765_K * 0.91f;
                }
            }
            float var8 = 0.16277136f / (var3 * var3 * var3);
            float var5 = this.getRideSpeed();
            var5 = this.field_70122_E ? (var5 *= 0.6f * var8) : (var5 *= 0.8f);
            this.func_191958_b(strafe, 0.0f, forward, var5);
            this.func_70091_d(MoverType.SELF, this.field_70159_w * (double)this.mountBoost, this.field_70181_x, this.field_70179_y * (double)this.mountBoost);
            var3 = 0.91f;
            if (this.field_70122_E) {
                var3 = 0.54600006f;
                IBlockState state = this.field_70170_p.func_180495_p(new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1, MathHelper.func_76128_c((double)this.field_70161_v)));
                if (state.func_185904_a() != Material.field_151579_a) {
                    var3 = state.func_177230_c().field_149765_K * 0.91f;
                }
            }
            this.field_70181_x = !this.field_70170_p.field_72995_K && !this.field_70170_p.func_175667_e(new BlockPos((int)this.field_70165_t, 0, (int)this.field_70161_v)) ? (this.field_70163_u > 0.0 ? (this.field_70181_x -= 0.01) : 0.0) : (this.field_70181_x -= 0.02);
            this.field_70181_x *= (double)0.98f;
            this.field_70159_w *= (double)var3;
            this.field_70179_y *= (double)var3;
            return;
        }
        this.moveEntityRidden(strafe, forward * this.mountBoost);
        super.func_191986_a(strafe, up, forward * this.mountBoost);
    }

    private void moveEntityRidden(float strafe, float forward) {
        if (this.func_70090_H()) {
            double d0 = this.field_70163_u;
            this.func_191958_b(strafe, 0.0f, forward, 0.05f);
            this.func_70091_d(MoverType.SELF, this.field_70159_w * (double)this.mountBoost, this.field_70181_x, this.field_70179_y * (double)this.mountBoost);
            this.field_70159_w *= (double)0.8f;
            this.field_70181_x *= (double)0.8f;
            this.field_70179_y *= (double)0.8f;
            this.field_70181_x -= 0.019;
            if (this.field_70123_F && this.func_70038_c(this.field_70159_w, this.field_70181_x + (double)0.6f - this.field_70163_u + d0, this.field_70179_y)) {
                this.field_70181_x = 0.3f;
            }
        } else if (this.func_180799_ab()) {
            double d0 = this.field_70163_u;
            this.func_191958_b(strafe, 0.0f, forward, 0.02f);
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= 0.6;
            this.field_70181_x *= 0.6;
            this.field_70179_y *= 0.6;
            this.field_70181_x -= 0.02;
            if (this.field_70123_F && this.func_70038_c(this.field_70159_w, this.field_70181_x + (double)0.6f - this.field_70163_u + d0, this.field_70179_y)) {
                this.field_70181_x = 0.3f;
            }
        } else {
            float sh;
            if (SpawnLocationType.containsOnly(this.getBaseStats().spawnLocations, SpawnLocationType.Water)) {
                return;
            }
            float f2 = 0.91f;
            if (this.field_70122_E) {
                f2 = 0.54600006f;
                IBlockState state = this.field_70170_p.func_180495_p(new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1, MathHelper.func_76128_c((double)this.field_70161_v)));
                if (state.func_185904_a() != Material.field_151579_a) {
                    f2 = state.func_177230_c().field_149765_K * 0.91f;
                }
            }
            float f3 = 0.16277136f / (f2 * f2 * f2);
            float f4 = this.getRideSpeed();
            if (this.field_70122_E) {
                f4 *= f3 * 2.8f;
            }
            this.func_191958_b(strafe, 0.0f, forward, f4);
            f2 = 0.91f;
            if (this.field_70122_E) {
                f2 = 0.54600006f;
                IBlockState state = this.field_70170_p.func_180495_p(new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1, MathHelper.func_76128_c((double)this.field_70161_v)));
                if (state.func_185904_a() != Material.field_151579_a) {
                    f2 = state.func_177230_c().field_149765_K * 0.91f;
                }
            }
            this.field_70138_W = sh = (float)Math.ceil(this.getBaseStats().height.floatValue() * this.getScaleFactor() / 5.0f);
            this.func_70091_d(MoverType.PLAYER, this.field_70159_w * (double)this.mountBoost, this.field_70181_x, this.field_70179_y * (double)this.mountBoost);
            this.field_70181_x = this.field_70170_p.field_72995_K && (!this.field_70170_p.func_175667_e(new BlockPos((int)this.field_70165_t, 0, (int)this.field_70161_v)) || this.field_70170_p instanceof WorldServer && !((WorldServer)this.field_70170_p).func_72863_F().func_73149_a(this.field_70176_ah, this.field_70164_aj)) ? (this.field_70163_u > 0.0 ? -0.1 : 0.0) : (this.field_70181_x -= 0.04);
            this.field_70181_x *= (double)0.98f;
            this.field_70159_w *= (double)f2;
            this.field_70179_y *= (double)f2;
        }
    }

    private float getRideSpeed() {
        return 0.07f + 0.05f * (float)this.pokemon.getStat(StatsType.Speed) / 500.0f;
    }

    public void func_70106_y() {
        if (this.interaction != null && !this.field_70170_p.field_72995_K) {
            this.pokemon.getPersistentData().func_74774_a("NumInteractions", (byte)this.numInteractions);
            this.pokemon.getPersistentData().func_74777_a("InteractionCount", (short)this.interaction.counter);
        }
        super.func_70106_y();
    }

    public void func_70636_d() {
        if (!(this.field_70170_p.field_72995_K || !PixelmonConfig.disabledNonPlayerPixelmonMovement || this.pokemon.getStorageAndPosition() != null && this.pokemon.getStorage() != null && this.pokemon.getStorage() instanceof PlayerPartyStorage)) {
            return;
        }
        if (this.func_184179_bs() != null && this.getBaseStats() != null) {
            if (this.canSurf() && this.ridingInitialised) {
                this.func_184179_bs().func_70050_g(this.initAir);
            }
            this.field_191988_bg = !this.func_184179_bs().func_70090_H() && this.canSurf() ? 0.0f : (this.field_191988_bg *= 0.4f);
            if ((double)this.field_191988_bg > -0.1 && (double)this.field_191988_bg < 0.1) {
                this.field_191988_bg = 0.0f;
            }
            if (!this.func_70090_H() && this.ridingPlayerVertical > 0) {
                if (this.field_70122_E) {
                    this.func_70664_aZ();
                    this.field_70181_x *= (double)(1.0f + (float)this.pokemon.getStat(StatsType.Speed) / 500.0f);
                } else if (this.canFly()) {
                    double moty = 0.04f + 0.06f * ((float)this.pokemon.getStat(StatsType.Speed) / 500.0f);
                    this.field_70181_x = this.field_70181_x + moty <= 0.4 ? (this.field_70181_x += moty) : (this.field_70181_x += Math.max(0.0, 0.4 - this.field_70181_x));
                    this.isFlying = true;
                }
            } else if (this.func_70090_H()) {
                if (this.ridingPlayerVertical > 0) {
                    this.field_70181_x = this.canSurf() ? (this.field_70181_x += (double)0.03f) : (this.field_70181_x += (double)0.1f);
                } else if (this.ridingPlayerVertical < 0) {
                    this.field_70181_x -= (double)0.03f;
                }
            }
            this.ridingPlayerVertical = 0;
            if (this.field_70122_E && this.isFlying) {
                this.isFlying = false;
            }
        }
        super.func_70636_d();
    }

    public void func_70624_b(EntityLivingBase entity) {
        this.skillId = null;
        super.func_70624_b(entity);
    }

    public void setAttackTarget(EntityLivingBase entity, ResourceLocation skillId) {
        this.func_70624_b(entity);
        this.skillId = skillId;
    }

    public void setBlockTarget(int x, int y, int z, EnumFacing side, ResourceLocation skillId) {
        this.targetX = x;
        this.targetY = y;
        this.targetZ = z;
        this.targetSide = side;
        this.skillId = skillId;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.interaction != null) {
            if (this.interaction.counter > 0) {
                --this.interaction.counter;
            }
            if (this.interaction.counter == 0) {
                this.setNumInteractions(Math.min(this.interaction.maxInteractions, this.getNumInteractions() + 1));
                if (this.interaction.maxInteractions > this.getNumInteractions()) {
                    this.interaction.resetCounter(this);
                } else {
                    --this.interaction.counter;
                }
            }
        }
        if (this.func_184179_bs() != null && !this.ridingInitialised) {
            this.field_70714_bg.field_75782_a.clear();
            this.initAir = this.func_184179_bs().func_70086_ai();
            this.ridingInitialised = true;
        } else if (this.func_184179_bs() == null && this.ridingInitialised) {
            this.ridingInitialised = false;
            this.resetAI();
        }
        if (!this.field_70170_p.field_72995_K && this.aiHelper == null && this.getBaseStats() != null) {
            this.resetAI();
        }
        if (this.aggressionTimer > 0) {
            --this.aggressionTimer;
        }
    }

    public void func_184232_k(Entity passenger) {
        if (this.getBaseStats() != null) {
            try {
                if (this.getBaseStats().ridingOffsets == null) {
                    this.getBaseStats().ridingOffsets = new RidingOffsets();
                }
                Vector3f offsets = this.getBaseStats().ridingOffsets.standing != null ? this.getBaseStats().ridingOffsets.standing : new Vector3f();
                if (this.getBaseStats().ridingOffsets.moving != null && (this.flyingDelayCounter >= flyingDelayLimit || this.getUsingRidingSpecialConditions())) {
                    offsets = this.getBaseStats().ridingOffsets.moving;
                }
                Vec3d vec = new Vec3d((double)(offsets.x * this.getPixelmonScale() * this.getScaleFactor()), (double)((offsets.y + this.field_70131_O) * this.getPixelmonScale() * this.getScaleFactor()), (double)(offsets.z * this.getPixelmonScale() * this.getScaleFactor()));
                vec = vec.func_178785_b(-1.0f * this.field_70761_aq * (float)Math.PI / 180.0f);
                passenger.func_70107_b(this.field_70165_t + vec.field_72450_a, this.field_70163_u + vec.field_72448_b, this.field_70161_v + vec.field_72449_c);
            }
            catch (Exception e) {
                passenger.func_184210_p();
            }
        }
    }

    public int getNumInteractions() {
        return this.numInteractions;
    }

    public void setNumInteractions(int newValue) {
        this.field_70180_af.func_187227_b(EntityPixelmon.dwNumInteractions, (Object)((byte)Math.max(0, newValue)));
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        if (this.interaction != null && !this.field_70170_p.field_72995_K) {
            this.pokemon.getPersistentData().func_74774_a("NumInteractions", (byte)this.numInteractions);
            this.pokemon.getPersistentData().func_74777_a("InteractionCount", (short)this.interaction.counter);
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        if (!this.field_70170_p.field_72995_K && this.interaction != null) {
            this.setNumInteractions(this.pokemon.getPersistentData().func_74771_c("NumInteractions"));
            this.interaction.counter = this.pokemon.getPersistentData().func_74765_d("InteractionCount");
        }
    }

    @Override
    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (key.func_187155_a() == dwNumInteractions.func_187155_a()) {
            this.numInteractions = ((Byte)this.field_70180_af.func_187225_a(dwNumInteractions)).byteValue();
        }
    }

    private boolean getUsingRidingSpecialConditions() {
        if (Math.abs(this.field_70159_w) > 0.01 || Math.abs(this.field_70179_y) > 0.01) {
            if (this.getBaseStats().pokemon == EnumSpecies.Gyarados) {
                return this.func_70090_H();
            }
            return this.getBaseStats().pokemon == EnumSpecies.Onix;
        }
        return false;
    }

    public boolean shouldDismountInWater(Entity rider) {
        return this.canFly() && !this.canSurf();
    }

    public void unloadEntity() {
        if (this.func_184179_bs() != null) {
            this.func_184179_bs().func_184210_p();
            this.resetAI();
        }
    }

    public Entity func_184179_bs() {
        return this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
    }
}

