/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.npcs;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.events.NPCChatEvent;
import com.pixelmonmod.pixelmon.comm.packetHandlers.OpenScreen;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.SetChattingNPCTextures;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.SetNPCData;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.SetNPCEditData;
import com.pixelmonmod.pixelmon.entities.SpawnLocationType;
import com.pixelmonmod.pixelmon.entities.npcs.EntityIndexedNPC;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ClientNPCData;
import com.pixelmonmod.pixelmon.entities.npcs.registry.GeneralNPCData;
import com.pixelmonmod.pixelmon.entities.npcs.registry.GymNPCData;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ServerNPCRegistry;
import com.pixelmonmod.pixelmon.enums.EnumGuiScreen;
import com.pixelmonmod.pixelmon.items.ItemNPCEditor;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class NPCChatting
extends EntityIndexedNPC {
    private ArrayList<String> chatPages = new ArrayList();
    boolean usingDefaultName = true;
    boolean usingDefaultChat = true;

    public NPCChatting(World world) {
        super(world);
    }

    public void init(GeneralNPCData data) {
        this.npcIndex = data.id;
        this.nameIndex = data.getRandomNameIndex();
        this.chatIndex = data.getRandomChatIndex();
        if (this.getId() == -1) {
            this.setId(idIndex++);
        }
        this.npcLocation = SpawnLocationType.LandVillager;
    }

    public void init(GymNPCData data) {
        this.npcIndex = "_gym_" + data.id;
        this.nameIndex = data.getRandomNameIndex();
        this.chatIndex = data.getRandomChatIndex();
        if (this.getId() == -1) {
            this.setId(idIndex++);
        }
        this.npcLocation = SpawnLocationType.LandVillager;
    }

    @Override
    public void init(String name) {
        super.init(name);
        this.setCustomSteveTexture("npcchat1.png");
    }

    @Override
    public boolean func_70104_M() {
        return false;
    }

    @Override
    public String getTexture() {
        return "pixelmon:textures/steve/" + this.getCustomSteveTexture();
    }

    @Override
    public String getDisplayText() {
        return "";
    }

    @Override
    public void func_70024_g(double par1, double par3, double par5) {
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74757_a("DefaultName", this.usingDefaultName);
        nbt.func_74757_a("DefaultGreet", this.usingDefaultChat);
        nbt.func_74768_a("chatNum", this.chatPages.size());
        int i = 0;
        for (String page : this.chatPages) {
            nbt.func_74778_a("chat" + i, page);
            ++i;
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.usingDefaultName = nbt.func_74767_n("DefaultName");
        this.usingDefaultChat = nbt.func_74767_n("DefaultGreet");
        int numPages = nbt.func_74762_e("chatNum");
        for (int i = 0; i < numPages; ++i) {
            this.chatPages.add(nbt.func_74779_i("chat" + i));
        }
        if (this.getProfession() != 0) {
            this.initDefaultAI();
        }
    }

    @Override
    public boolean interactWithNPC(EntityPlayer player, EnumHand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (player instanceof EntityPlayerMP) {
            EntityPlayerMP playerMP = (EntityPlayerMP)player;
            String loc = playerMP.field_71148_cg;
            if (!itemstack.func_190926_b() && itemstack.func_77973_b() instanceof ItemNPCEditor) {
                if (!ItemNPCEditor.checkPermission(playerMP)) {
                    return false;
                }
                Pixelmon.network.sendTo((IMessage)new SetNPCEditData(this.getName(loc), this.getChat(loc)), playerMP);
                Pixelmon.network.sendTo((IMessage)new SetChattingNPCTextures(), playerMP);
                OpenScreen.open(player, EnumGuiScreen.NPCChatEditor, this.getId());
            } else if (!this.getChat(loc).isEmpty()) {
                NPCChatEvent event = new NPCChatEvent(this, player, this.getChat(loc));
                if (Pixelmon.EVENT_BUS.post((Event)event)) {
                    return false;
                }
                Pixelmon.network.sendTo((IMessage)new SetNPCData(this.getName(loc), event.getChat()), (EntityPlayerMP)player);
                OpenScreen.open(player, EnumGuiScreen.NPCChat, this.getId());
            }
        } else {
            this.field_70714_bg.field_75782_a.clear();
        }
        return true;
    }

    @Override
    public ArrayList<String> getChat(String langCode) {
        if (this.usingDefaultChat) {
            int index = this.chatIndex;
            if (this.npcIndex.startsWith("_gym_")) {
                return new ArrayList<String>(Arrays.asList(ServerNPCRegistry.getTranslatedGymMemberChat(langCode, this.npcIndex.substring(5), index)));
            }
            return new ArrayList<String>(Arrays.asList(ServerNPCRegistry.villagers.getTranslatedChat(langCode, this.npcIndex, index)));
        }
        return this.chatPages;
    }

    @Override
    public String getName(String langCode) {
        if (this.usingDefaultName) {
            int index = this.nameIndex;
            if (this.npcIndex.startsWith("_gym_")) {
                return ServerNPCRegistry.getTranslatedGymMemberName(langCode, this.npcIndex.substring(5), index);
            }
            return ServerNPCRegistry.villagers.getTranslatedName(langCode, this.npcIndex, index);
        }
        return this.func_70005_c_();
    }

    public void setChat(ArrayList<String> pages) {
        this.chatPages = pages;
        this.usingDefaultChat = false;
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        this.usingDefaultName = false;
    }

    public void cycleTexture(EntityPlayerMP p, ClientNPCData newData) {
        GeneralNPCData data = ServerNPCRegistry.villagers.getData(newData.getID());
        if (data == null) {
            return;
        }
        this.init(data);
        this.setCustomSteveTexture(newData.getTexture());
        Pixelmon.network.sendTo((IMessage)new SetNPCEditData(this.getName(p.field_71148_cg), this.getChat(p.field_71148_cg)), p);
    }
}

