/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.config;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.config.PixelmonBlocks;
import com.pixelmonmod.pixelmon.config.PixelmonItems;
import com.pixelmonmod.pixelmon.config.PixelmonItemsApricorns;
import com.pixelmonmod.pixelmon.config.PixelmonItemsBadges;
import com.pixelmonmod.pixelmon.config.PixelmonItemsFossils;
import com.pixelmonmod.pixelmon.config.PixelmonItemsHeld;
import com.pixelmonmod.pixelmon.config.PixelmonItemsMail;
import com.pixelmonmod.pixelmon.config.PixelmonItemsPokeballs;
import com.pixelmonmod.pixelmon.config.PixelmonItemsTMs;
import com.pixelmonmod.pixelmon.config.PixelmonItemsTools;
import com.pixelmonmod.pixelmon.config.PixelmonPotions;
import com.pixelmonmod.pixelmon.items.ItemCoveredFossil;
import com.pixelmonmod.pixelmon.items.ItemPokeball;
import com.pixelmonmod.pixelmon.items.PixelmonItem;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IFixType;
import net.minecraft.util.datafix.IFixableData;
import net.minecraftforge.common.util.ModFixs;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class RemapHandler {
    public static ModFixs modfix = null;

    static void remapBlocks(List<RegistryEvent.MissingMappings.Mapping<Block>> mappings) {
        block57: for (RegistryEvent.MissingMappings.Mapping<Block> mapping : mappings) {
            try {
                String name = mapping.key.toString();
                if (name.startsWith("pixelmon:pokedoll_") || name.startsWith("pixelmon:shinypokedoll_") || name.matches("pixelmon:([a-z]+)_fossil_display") || name.matches("pixelmon:castle([a-z0-9]+)") || name.matches("pixelmon:ice([a-z0-9]+)")) {
                    mapping.ignore();
                    continue;
                }
                switch (name.substring("pixelmon:".length())) {
                    case "lightgrey_clock": 
                    case "grey_clock": 
                    case "lightgrey_vending_machine": 
                    case "grey_vending_machine": 
                    case "lightgrey_cushion_chair": 
                    case "grey_cushion_chair": 
                    case "lightgrey_rug": 
                    case "grey_rug": 
                    case "lightgrey_water_float": 
                    case "grey_water_float": 
                    case "lightgrey_umbrella": 
                    case "grey_umbrella": 
                    case "magenta_clock": 
                    case "magenta_vending_machine": 
                    case "magenta_cushion_chair": 
                    case "magenta_rug": 
                    case "magenta_water_float": 
                    case "magenta_umbrella": 
                    case "lime_clock": 
                    case "lime_vending_machine": 
                    case "lime_cushion_chair": 
                    case "lime_rug": 
                    case "lime_water_float": 
                    case "lime_umbrella": 
                    case "lightblue_clock": 
                    case "lightblue_vending_machine": 
                    case "lightblue_cushion_chair": 
                    case "lightblue_rug": 
                    case "lightblue_water_float": 
                    case "lightblue_umbrella": 
                    case "bluepicketfence": 
                    case "tablepc": 
                    case "whitepillar": 
                    case "ultra_pillar": 
                    case "zygardemachine": 
                    case "ultra_sand": 
                    case "ultra_sandstone": 
                    case "celestial_altar": 
                    case "ultra": {
                        mapping.ignore();
                        continue block57;
                    }
                }
                switch (name) {
                    case "pixelmon:clefairy_pokedoll": 
                    case "pixelmon:cyndaquil_pokedoll": 
                    case "pixelmon:blastoise_pokedoll": 
                    case "pixelmon:charizard_pokedoll": {
                        mapping.ignore();
                        continue block57;
                    }
                    case "pixelmon:chair": {
                        mapping.remap((IForgeRegistryEntry)PixelmonBlocks.redChairBlock);
                        continue block57;
                    }
                }
                Block block = RemapHandler.getNewBlockFromBlockName(mapping.key.toString().toLowerCase().replace(":tile.", ":").replace("_", ""));
                if (block == null && mapping.key.toString().endsWith("Block")) {
                    block = RemapHandler.getNewBlockFromBlockName(mapping.key.toString().substring(0, mapping.key.toString().length() - 5).toLowerCase().replace("_", ""));
                }
                if (block == null) continue;
                mapping.remap((IForgeRegistryEntry)block);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    static void remapItems(List<RegistryEvent.MissingMappings.Mapping<Item>> mappings) {
        block102: for (RegistryEvent.MissingMappings.Mapping<Item> mapping : mappings) {
            try {
                Optional<RegistryEvent.MissingMappings.Mapping> duplicate;
                String name = mapping.key.toString();
                if (name.startsWith("pixelmon:pokedoll_") || name.startsWith("pixelmon:shinypokedoll_") || name.matches("pixelmon:([a-z]+)_fossil_display") || name.matches("pixelmon:([a-z]+)_bike") || name.matches("pixelmon:([a-z_]+)_poke_puff") || name.matches("pixelmon:castle([a-z0-9]+)") || name.matches("pixelmon:ice([a-z0-9_]+)") || name.matches("pixelmon:(aether|flare|skull)_(helm|plate|legs|boots)")) {
                    mapping.ignore();
                    continue;
                }
                if (name.endsWith("_memory_drive")) {
                    boolean exit = false;
                    for (Item item : PixelmonItemsHeld.getHeldItemList()) {
                        if (!Objects.equals(item.getRegistryName().toString(), name.substring(0, name.lastIndexOf(95)))) continue;
                        mapping.remap((IForgeRegistryEntry)item);
                        exit = true;
                        break;
                    }
                    if (exit) continue;
                }
                switch (name.substring("pixelmon:".length())) {
                    case "lightgrey_clock": 
                    case "lightgrey_vending_machine": 
                    case "lightgrey_cushion_chair": 
                    case "lightgrey_rug": 
                    case "lightgrey_water_float": 
                    case "lightgrey_umbrella": 
                    case "magenta_clock": 
                    case "magenta_vending_machine": 
                    case "magenta_cushion_chair": 
                    case "magenta_rug": 
                    case "magenta_water_float": 
                    case "magenta_umbrella": 
                    case "lime_clock": 
                    case "lime_vending_machine": 
                    case "lime_cushion_chair": 
                    case "lime_rug": 
                    case "lime_water_float": 
                    case "lime_umbrella": 
                    case "lightblue_clock": 
                    case "lightblue_vending_machine": 
                    case "lightblue_cushion_chair": 
                    case "lightblue_rug": 
                    case "lightblue_water_float": 
                    case "lightblue_umbrella": 
                    case "faded_blue_orb": 
                    case "faded_red_orb": 
                    case "green_shard": 
                    case "tm175": 
                    case "tm176": 
                    case "tm177": 
                    case "bluepicketfence": 
                    case "tablepc": 
                    case "whitepillar": 
                    case "legend_finder": 
                    case "rockstar_costume": 
                    case "belle_costume": 
                    case "libre_costume": 
                    case "popstar_costume": 
                    case "phd_costume": 
                    case "yellow_shard": 
                    case "ultra": 
                    case "ultra_pillar": 
                    case "ultra_sand": 
                    case "ultra_sandstone": 
                    case "celestial_altar": 
                    case "dream_ball": 
                    case "bike_frame": 
                    case "bike_wheel": 
                    case "bike_seat": 
                    case "bike_handlebars": 
                    case "moon_flute": 
                    case "sun_flute": 
                    case "pink_nectar": 
                    case "purple_nectar": 
                    case "red_nectar": 
                    case "yellow_nectar": 
                    case "meltan_box": 
                    case "zygarde_cube": 
                    case "zygardemachine": 
                    case "searuby_badge": 
                    case "coraleye_badge": 
                    case "spikeshell_badge": 
                    case "jadestar_badge": {
                        mapping.ignore();
                        continue block102;
                    }
                }
                if (name.startsWith("pixelmon:record.") || name.startsWith("pixelmon:item.record.")) {
                    mapping.ignore();
                    continue;
                }
                if (name.endsWith("_apricorn_tree")) {
                    mapping.ignore();
                    continue;
                }
                switch (name) {
                    case "pixelmon:aluminium_torso": {
                        mapping.remap((IForgeRegistryEntry)PixelmonItemsTools.chestplateAluminium);
                        continue block102;
                    }
                    case "pixelmon:chair": 
                    case "pixelmon:red_chair": {
                        mapping.remap((IForgeRegistryEntry)PixelmonBlocks.itemMapping.get(PixelmonBlocks.redChairBlock));
                        continue block102;
                    }
                }
                switch (name) {
                    case "pixelmon:charizard_pokedoll": 
                    case "pixelmon:blastoise_pokedoll": 
                    case "pixelmon:cyndaquil_pokedoll": 
                    case "pixelmon:clefairy_pokedoll": 
                    case "pixelmon:rayquazaite": 
                    case "pixelmon:rayquazanite": {
                        mapping.ignore();
                        continue block102;
                    }
                    case "pixelmon:dna_splicer": {
                        mapping.remap((IForgeRegistryEntry)PixelmonItemsHeld.dnaSplicers);
                    }
                    case "pixelmon:mewtwonitex": {
                        mapping.remap((IForgeRegistryEntry)PixelmonItemsHeld.mewtwonite_x);
                        continue block102;
                    }
                    case "pixelmon:mewtwonitey": {
                        mapping.remap((IForgeRegistryEntry)PixelmonItemsHeld.mewtwonite_y);
                        continue block102;
                    }
                    case "pixelmon:revealglass": {
                        mapping.remap((IForgeRegistryEntry)PixelmonItems.reveal_glass);
                        continue block102;
                    }
                    case "pixelmon:prisonbottle": {
                        mapping.remap((IForgeRegistryEntry)PixelmonItemsHeld.prison_bottle);
                        continue block102;
                    }
                    case "pixelmon:griseousorb": {
                        mapping.remap((IForgeRegistryEntry)PixelmonItemsHeld.griseous_orb);
                        continue block102;
                    }
                }
                if (name.equals("pixelmon:PicketFence") || name.equals("pixelmon:item.HiddenWoodenDoor") || name.equals("pixelmon:item.HiddenIronDoor") || name.equals("pixelmon:tile.PokeGift") && mappings.stream().anyMatch(m -> m.key.toString().equals("pixelmon:item.pokeGift")) || name.equals("pixelmon:tile.trademachine") && mappings.stream().anyMatch(m -> m.key.toString().equals("pixelmon:item.Trade_Machine")) || name.equals("pixelmon:tile.cloningMachine") && mappings.stream().anyMatch(m -> m.key.toString().equals("pixelmon:item.Cloning_Machine")) || name.equals("pixelmon:tile.fossilmachine") && mappings.stream().anyMatch(m -> m.key.toString().equals("pixelmon:item.Fossil_Machine")) || name.equals("pixelmon:tile.icyrock") && mappings.stream().anyMatch(m -> m.key.toString().equals("pixelmon:Icy_Rock")) || name.equals("pixelmon:tile.mossyrock") && mappings.stream().anyMatch(m -> m.key.toString().equals("pixelmon:item.Mossy_Rock")) || name.equals("pixelmon:tile.hiddenPressurePlate") || name.equals("pixelmon:tile.hiddenCube") || name.equals("pixelmon:PokeHealer") && mappings.stream().anyMatch(m -> m.key.toString().equals("pixelmon:item.Healer")) || name.equals("pixelmon:Trading_Machine") || name.equals("pixelmon:Articuno_Shrine") && mappings.stream().anyMatch(m -> m.key.toString().equals("pixelmon:item.Uno_Shrine")) || name.equals("pixelmon:Zapdos_Shrine") && mappings.stream().anyMatch(m -> m.key.toString().equals("pixelmon:item.Dos_Shrine")) || name.equals("pixelmon:Moltres_Shrine") && mappings.stream().anyMatch(m -> m.key.toString().equals("pixelmon:item.Tres_Shrine")) || name.equals("pixelmon:Pixelmon_Anvil") && mappings.stream().anyMatch(m -> m.key.toString().equals("pixelmon:item.Anvil")) || (duplicate = mappings.stream().filter(m -> !m.key.toString().equals(name) && m.key.toString().replace("item.", "").replace("_Block", "").replace("_", "").equalsIgnoreCase(name.replace("_Block", "").replace("_", ""))).findFirst()).isPresent()) continue;
                Item item = RemapHandler.getNewItem(name);
                if (item != null) {
                    mapping.remap((IForgeRegistryEntry)item);
                    continue;
                }
                if (name.equals("pixelmon:item.Icy_Rock")) continue;
                Block block = RemapHandler.getNewBlockForItemBlock(name);
                if (block == null && name.endsWith("Block")) {
                    block = RemapHandler.getNewBlockFromBlockName(name.substring(0, name.length() - 5).toLowerCase().replace("_", ""));
                } else if (block == null) {
                    block = RemapHandler.getNewBlockFromBlockName(name.toLowerCase().replace(":tile.", ":").replace(":item.", ":").replace("_", ""));
                }
                if (block == null || (item = PixelmonBlocks.itemMapping.get(block)) == null || item == PixelmonItems.treeItem) continue;
                mapping.remap((IForgeRegistryEntry)item);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    static void remapPotions(List<RegistryEvent.MissingMappings.Mapping<Potion>> mappings) {
        mappings.forEach(p -> {
            switch (p.key.toString()) {
                case "pixelmon:luck": 
                case "pixelmon:attract": 
                case "pixelmon:potion.luck": 
                case "pixelmon:potion.attract": {
                    p.ignore();
                    break;
                }
                case "pixelmon:potion.repel": {
                    p.remap((IForgeRegistryEntry)PixelmonPotions.repel);
                }
            }
        });
    }

    static void remapEntities(List<RegistryEvent.MissingMappings.Mapping<EntityEntry>> mappings) {
        mappings.forEach(e -> {
            switch (e.key.toString()) {
                case "pixelmon:hallwoeen": 
                case "pixelmon:halloween": 
                case "pixelmon:chairmount": 
                case "pixelmon:legend_finder": 
                case "pixelmon:npc_groomer": 
                case "pixelmon:bike": 
                case "pixelmon:zygardecell": {
                    e.ignore();
                }
            }
        });
    }

    public static Block getNewBlockFromBlockName(String name) {
        switch (name) {
            case "pixelmon:fossilmachineblock": {
                return PixelmonBlocks.fossilMachine;
            }
            case "pixelmon:fossilcleanerblock": {
                return PixelmonBlocks.fossilCleaner;
            }
            case "pixelmon:picketfencecross": 
            case "pixelmon:picketfencecorner": {
                return PixelmonBlocks.picketFenceNormalBlock;
            }
            case "pixelmon:pokegiftblock": {
                return PixelmonBlocks.pokegiftBlock;
            }
            case "pixelmon:eventpokegift": 
            case "pixelmon:pokegifteventblock": {
                return PixelmonBlocks.pokegiftEventBlock;
            }
            case "pixelmon:amethystblock": {
                return PixelmonBlocks.amethystBlock;
            }
            case "pixelmon:amethystore": {
                return PixelmonBlocks.amethystOre;
            }
            case "pixelmon:ancientpillar": {
                return PixelmonBlocks.fancyPillar;
            }
            case "pixelmon:articunoshrine": {
                return PixelmonBlocks.shrineUno;
            }
            case "pixelmon:bauxite": {
                return PixelmonBlocks.bauxite;
            }
            case "pixelmon:blueclock": {
                return PixelmonBlocks.blueClockBlock;
            }
            case "pixelmon:bluerug": 
            case "pixelmon:bluepokeballrug": {
                return PixelmonBlocks.blueRugBlock;
            }
            case "pixelmon:blueumbrella": {
                return PixelmonBlocks.blueUmbrellaBlock;
            }
            case "pixelmon:bluevendingmachine": {
                return PixelmonBlocks.blueVendingMachineBlock;
            }
            case "pixelmon:bluewaterfloat": {
                return PixelmonBlocks.blueWaterFloatBlock;
            }
            case "pixelmon:bolder": {
                return PixelmonBlocks.bolderBlock;
            }
            case "pixelmon:box": {
                return PixelmonBlocks.boxBlock;
            }
            case "pixelmon:brailleblock": {
                return PixelmonBlocks.blockBraille;
            }
            case "pixelmon:brailleblock2": {
                return PixelmonBlocks.blockBraille2;
            }
            case "pixelmon:bridgeblock": {
                return PixelmonBlocks.bridgeBlockBlock;
            }
            case "pixelmon:caverock": {
                return PixelmonBlocks.caveRockBlock;
            }
            case "pixelmon:tile.cloningmachine": 
            case "pixelmon:cloningmachine": {
                return PixelmonBlocks.cloningMachine;
            }
            case "pixelmon:clothtable": 
            case "pixelmon:clothedtable": {
                return PixelmonBlocks.clothedTableBlock;
            }
            case "pixelmon:crystalblock": {
                return PixelmonBlocks.crystalBlock;
            }
            case "pixelmon:crystalore": {
                return PixelmonBlocks.crystalOre;
            }
            case "pixelmon:dawnduskore": 
            case "pixelmon:dawnduskstoneore": {
                return PixelmonBlocks.dawnduskStoneOre;
            }
            case "pixelmon:elevator": {
                return PixelmonBlocks.elevator;
            }
            case "pixelmon:endtable": {
                return PixelmonBlocks.endTableBlock;
            }
            case "pixelmon:firestoneore": {
                return PixelmonBlocks.fireStoneOre;
            }
            case "pixelmon:fossil": {
                return PixelmonBlocks.fossil;
            }
            case "pixelmon:fossilcleaner": {
                return PixelmonBlocks.fossilCleaner;
            }
            case "pixelmon:fossilmachine": {
                return PixelmonBlocks.fossilMachine;
            }
            case "pixelmon:fossildisplay": {
                return PixelmonBlocks.fossilDisplayBlock;
            }
            case "pixelmon:fridge": {
                return PixelmonBlocks.fridgeBlock;
            }
            case "pixelmon:greenfoldingchair": {
                return PixelmonBlocks.greenFoldingChairBlock;
            }
            case "pixelmon:greenrug": 
            case "pixelmon:greenpokeballrug": {
                return PixelmonBlocks.greenRugBlock;
            }
            case "pixelmon:greenumbrella": {
                return PixelmonBlocks.greenUmbrellaBlock;
            }
            case "pixelmon:greenvendingmachine": {
                return PixelmonBlocks.greenVendingMachineBlock;
            }
            case "pixelmon:greenwaterfloat": {
                return PixelmonBlocks.greenWaterFloatBlock;
            }
            case "pixelmon:gymsign": {
                return PixelmonBlocks.gymSignBlock;
            }
            case "pixelmon:hiddencube": {
                return PixelmonBlocks.hiddenCube;
            }
            case "pixelmon:hiddenirondoor": {
                return PixelmonBlocks.hiddenIronDoor;
            }
            case "pixelmon:hiddenpressureplate": {
                return PixelmonBlocks.hiddenPressurePlate;
            }
            case "pixelmon:hiddenwoodendoor": {
                return PixelmonBlocks.hiddenWoodenDoor;
            }
            case "pixelmon:insidewall": {
                return PixelmonBlocks.insideWallBlock;
            }
            case "pixelmon:insidewallmolding": {
                return PixelmonBlocks.insideWallMoldingBlock;
            }
            case "pixelmon:leafstoneore": {
                return PixelmonBlocks.leafStoneOre;
            }
            case "pixelmon:masterchest": {
                return PixelmonBlocks.masterChest;
            }
            case "pixelmon:mechanicalanvil": {
                return PixelmonBlocks.mechanicalAnvil;
            }
            case "pixelmon:moltresshrine": {
                return PixelmonBlocks.shrineTres;
            }
            case "pixelmon:movementplate": {
                return PixelmonBlocks.movementPlate;
            }
            case "pixelmon:orangevendingmachine": {
                return PixelmonBlocks.orangeVendingMachineBlock;
            }
            case "pixelmon:orangewaterfloat": {
                return PixelmonBlocks.orangeWaterFloatBlock;
            }
            case "pixelmon:outsidewall": {
                return PixelmonBlocks.outsideWallBlock;
            }
            case "pixelmon:pc": {
                return PixelmonBlocks.pc;
            }
            case "pixelmon:picketfencenormal": {
                return PixelmonBlocks.picketFenceNormalBlock;
            }
            case "pixelmon:pinkclock": {
                return PixelmonBlocks.pinkClockBlock;
            }
            case "pixelmon:pinkvendingmachine": {
                return PixelmonBlocks.pinkVendingMachineBlock;
            }
            case "pixelmon:pinkwaterfloat": {
                return PixelmonBlocks.pinkWaterFloatBlock;
            }
            case "pixelmon:pixelmonanvil": {
                return PixelmonBlocks.anvil;
            }
            case "pixelmon:pixelmonspawner": {
                return PixelmonBlocks.pixelmonSpawner;
            }
            case "pixelmon:spawnercaverock": {
                return PixelmonBlocks.caveRockBlock;
            }
            case "pixelmon:pixelmongrass": {
                return PixelmonBlocks.pixelmonGrassBlock;
            }
            case "pixelmon:pokechest": {
                return PixelmonBlocks.pokeChest;
            }
            case "pixelmon:pokecentersign": {
                return PixelmonBlocks.pokeCenterSignBlock;
            }
            case "pixelmon:pokegrass": {
                return PixelmonBlocks.pokeGrassBlock;
            }
            case "pixelmon:pokedirt": {
                return PixelmonBlocks.pokeDirtBlock;
            }
            case "pixelmon:pokegift": {
                return PixelmonBlocks.pokegiftBlock;
            }
            case "pixelmon:pokegiftevent": {
                return PixelmonBlocks.pokegiftEventBlock;
            }
            case "pixelmon:pokehealer": {
                return PixelmonBlocks.healer;
            }
            case "pixelmon:pokemartsign": {
                return PixelmonBlocks.pokeMartSignBlock;
            }
            case "pixelmon:pokesand": {
                return PixelmonBlocks.pokeSandBlock;
            }
            case "pixelmon:pokesandc1": {
                return PixelmonBlocks.pokeSandCorner1Block;
            }
            case "pixelmon:pokesandc2": {
                return PixelmonBlocks.pokeSandCorner2Block;
            }
            case "pixelmon:pokesandc3": {
                return PixelmonBlocks.pokeSandCorner3Block;
            }
            case "pixelmon:pokesandc4": {
                return PixelmonBlocks.pokeSandCorner4Block;
            }
            case "pixelmon:pokesands1": {
                return PixelmonBlocks.pokeSandSide1Block;
            }
            case "pixelmon:pokesands2": {
                return PixelmonBlocks.pokeSandSide2Block;
            }
            case "pixelmon:pokesands3": {
                return PixelmonBlocks.pokeSandSide3Block;
            }
            case "pixelmon:pokesands4": {
                return PixelmonBlocks.pokeSandSide4Block;
            }
            case "pixelmon:purplewaterfloat": {
                return PixelmonBlocks.purpleWaterFloatBlock;
            }
            case "pixelmon:ranch": {
                return PixelmonBlocks.ranchBlock;
            }
            case "pixelmon:redcushionchair": {
                return PixelmonBlocks.redCushionChairBlock;
            }
            case "pixelmon:redrug": 
            case "pixelmon:redpokeballrug": {
                return PixelmonBlocks.redRugBlock;
            }
            case "pixelmon:redumbrella": {
                return PixelmonBlocks.redUmbrellaBlock;
            }
            case "pixelmon:redvendingmachine": {
                return PixelmonBlocks.redVendingMachineBlock;
            }
            case "pixelmon:redwaterfloat": {
                return PixelmonBlocks.redWaterFloatBlock;
            }
            case "pixelmon:rock": {
                return PixelmonBlocks.rockBlock;
            }
            case "pixelmon:rubyblock": {
                return PixelmonBlocks.rubyBlock;
            }
            case "pixelmon:rubyore": {
                return PixelmonBlocks.rubyOre;
            }
            case "pixelmon:sandygrass": {
                return PixelmonBlocks.sandyGrassBlock;
            }
            case "pixelmon:sapphireblock": {
                return PixelmonBlocks.sapphireBlock;
            }
            case "pixelmon:sapphireore": {
                return PixelmonBlocks.sapphireOre;
            }
            case "pixelmon:shingles": {
                return PixelmonBlocks.shinglesBlock;
            }
            case "pixelmon:shinglesc1": {
                return PixelmonBlocks.shinglesCorner1Block;
            }
            case "pixelmon:shinglesc2": {
                return PixelmonBlocks.shinglesCorner2Block;
            }
            case "pixelmon:shrineblock": {
                return PixelmonBlocks.templeBlock;
            }
            case "pixelmon:shrinebrick": {
                return PixelmonBlocks.templeBrick;
            }
            case "pixelmon:shrinebrickstairs": {
                return PixelmonBlocks.templeBrickStairs;
            }
            case "pixelmon:shrinestairs": {
                return PixelmonBlocks.templeStairs;
            }
            case "pixelmon:ruinswall": {
                return PixelmonBlocks.ruinsWallBlock;
            }
            case "pixelmon:dustyruinswall": {
                return PixelmonBlocks.dustyRuinsWallBlock;
            }
            case "pixelmon:siliconore": {
                return PixelmonBlocks.siliconOre;
            }
            case "pixelmon:stickplate": {
                return PixelmonBlocks.stickPlate;
            }
            case "pixelmon:sunstoneore": {
                return PixelmonBlocks.sunStoneOre;
            }
            case "pixelmon:thunderstoneore": {
                return PixelmonBlocks.thunderStoneOre;
            }
            case "pixelmon:icyrock": {
                return PixelmonBlocks.icyRock;
            }
            case "pixelmon:mossyrock": {
                return PixelmonBlocks.mossyRock;
            }
            case "pixelmon:trademachine": 
            case "pixelmon:tradingmachine": {
                return PixelmonBlocks.tradeMachine;
            }
            case "pixelmon:timedfall": {
                return PixelmonBlocks.timedFall;
            }
            case "pixelmon:trashcan": {
                return PixelmonBlocks.trashcanBlock;
            }
            case "pixelmon:tree": {
                return PixelmonBlocks.treeBlock;
            }
            case "pixelmon:treebottom": {
                return PixelmonBlocks.treeBottomBlock;
            }
            case "pixelmon:treetop": {
                return PixelmonBlocks.treeTopBlock;
            }
            case "pixelmon:tv": {
                return PixelmonBlocks.tvBlock;
            }
            case "pixelmon:ultrachest": {
                return PixelmonBlocks.ultraChest;
            }
            case "pixelmon:unownblock": {
                return PixelmonBlocks.blockUnown;
            }
            case "pixelmon:unownblock2": {
                return PixelmonBlocks.blockUnown2;
            }
            case "pixelmon:warpplate": {
                return PixelmonBlocks.warpPlate;
            }
            case "pixelmon:waterstoneore": {
                return PixelmonBlocks.waterStoneOre;
            }
            case "pixelmon:window1": {
                return PixelmonBlocks.window1Block;
            }
            case "pixelmon:window2": {
                return PixelmonBlocks.window2Block;
            }
            case "pixelmon:woodenflooring": {
                return PixelmonBlocks.woodenFlooringBlock;
            }
            case "pixelmon:yellowcushionchair": {
                return PixelmonBlocks.yellowCushionChairBlock;
            }
            case "pixelmon:yellowrug": 
            case "pixelmon:yellowpokeballrug": {
                return PixelmonBlocks.yellowRugBlock;
            }
            case "pixelmon:yellowumbrella": {
                return PixelmonBlocks.yellowUmbrellaBlock;
            }
            case "pixelmon:yellowvendingmachine": {
                return PixelmonBlocks.yellowVendingMachineBlock;
            }
            case "pixelmon:yellowwaterfloat": {
                return PixelmonBlocks.yellowWaterFloatBlock;
            }
            case "pixelmon:zapdosshrine": {
                return PixelmonBlocks.shrineDos;
            }
        }
        return null;
    }

    public static Block getNewBlockForItemBlock(String name) {
        switch (name) {
            case "pixelmon:AmethystBlock": {
                return PixelmonBlocks.amethystBlock;
            }
            case "pixelmon:AmethystOre": {
                return PixelmonBlocks.amethystOre;
            }
            case "pixelmon:Ancient_Pillar": {
                return PixelmonBlocks.fancyPillar;
            }
            case "pixelmon:Bauxite": {
                return PixelmonBlocks.bauxite;
            }
            case "pixelmon:BlueClock": {
                return PixelmonBlocks.blueClockBlock;
            }
            case "pixelmon:item.BluePokeballRug": {
                return PixelmonBlocks.blueRugBlock;
            }
            case "pixelmon:BlueUmbrella": {
                return PixelmonBlocks.blueUmbrellaBlock;
            }
            case "pixelmon:item.BlueVendingMachine": {
                return PixelmonBlocks.blueVendingMachineBlock;
            }
            case "pixelmon:item.BlueWaterFloat": {
                return PixelmonBlocks.blueWaterFloatBlock;
            }
            case "pixelmon:Bolder": {
                return PixelmonBlocks.bolderBlock;
            }
            case "pixelmon:Box": {
                return PixelmonBlocks.boxBlock;
            }
            case "pixelmon:BrailleBlock": {
                return PixelmonBlocks.blockBraille;
            }
            case "pixelmon:BrailleBlock2": {
                return PixelmonBlocks.blockBraille2;
            }
            case "pixelmon:BridgeBlock": {
                return PixelmonBlocks.bridgeBlockBlock;
            }
            case "pixelmon:CaveRock": {
                return PixelmonBlocks.caveRockBlock;
            }
            case "pixelmon:redChair": {
                return PixelmonBlocks.redChairBlock;
            }
            case "pixelmon:yellowChair": {
                return PixelmonBlocks.yellowChairBlock;
            }
            case "pixelmon:orangeChair": {
                return PixelmonBlocks.orangeChairBlock;
            }
            case "pixelmon:pinkChair": {
                return PixelmonBlocks.pinkChairBlock;
            }
            case "pixelmon:purpleChair": {
                return PixelmonBlocks.purpleChairBlock;
            }
            case "pixelmon:whiteChair": {
                return PixelmonBlocks.whiteChairBlock;
            }
            case "pixelmon:grayChair": {
                return PixelmonBlocks.grayChairBlock;
            }
            case "pixelmon:blackChair": {
                return PixelmonBlocks.blackChairBlock;
            }
            case "pixelmon:greenChair": {
                return PixelmonBlocks.greenChairBlock;
            }
            case "pixelmon:brownChair": {
                return PixelmonBlocks.brownChairBlock;
            }
            case "pixelmon:cyanChair": {
                return PixelmonBlocks.cyanChairBlock;
            }
            case "pixelmon:blueChair": {
                return PixelmonBlocks.blueChairBlock;
            }
            case "pixelmon:item.Cloning_Machine": {
                return PixelmonBlocks.cloningMachine;
            }
            case "pixelmon:item.ClothedTable": {
                return PixelmonBlocks.clothedTableBlock;
            }
            case "pixelmon:CrystalBlock": {
                return PixelmonBlocks.crystalBlock;
            }
            case "pixelmon:CrystalOre": {
                return PixelmonBlocks.crystalOre;
            }
            case "pixelmon:DawnDuskstone_Ore": {
                return PixelmonBlocks.dawnduskStoneOre;
            }
            case "pixelmon:Elevator": {
                return PixelmonBlocks.elevator;
            }
            case "pixelmon:EndTable": {
                return PixelmonBlocks.endTableBlock;
            }
            case "pixelmon:Firestone_Ore": {
                return PixelmonBlocks.fireStoneOre;
            }
            case "pixelmon:Fossil": {
                return PixelmonBlocks.fossil;
            }
            case "pixelmon:item.Fossil_Cleaner": {
                return PixelmonBlocks.fossilCleaner;
            }
            case "pixelmon:item.FossilDisplay": {
                return PixelmonBlocks.fossilDisplayBlock;
            }
            case "pixelmon:item.Fossil_Machine": {
                return PixelmonBlocks.fossilMachine;
            }
            case "pixelmon:item.Fridge": {
                return PixelmonBlocks.fridgeBlock;
            }
            case "pixelmon:GreenFoldingChair": {
                return PixelmonBlocks.greenFoldingChairBlock;
            }
            case "pixelmon:item.GreenPokeballRug": {
                return PixelmonBlocks.greenRugBlock;
            }
            case "pixelmon:GreenUmbrella": {
                return PixelmonBlocks.greenUmbrellaBlock;
            }
            case "pixelmon:item.GreenVendingMachine": {
                return PixelmonBlocks.greenVendingMachineBlock;
            }
            case "pixelmon:item.GreenWaterFloat": {
                return PixelmonBlocks.greenWaterFloatBlock;
            }
            case "pixelmon:GymSign": {
                return PixelmonBlocks.gymSignBlock;
            }
            case "pixelmon:item.Anvil": {
                return PixelmonBlocks.anvil;
            }
            case "pixelmon:item.HiddenCube": {
                return PixelmonBlocks.hiddenCube;
            }
            case "pixelmon:Hidden_Iron_Door": {
                return PixelmonBlocks.hiddenIronDoor;
            }
            case "pixelmon:item.HiddenPressurePlate": {
                return PixelmonBlocks.hiddenPressurePlate;
            }
            case "pixelmon:Hidden_Wooden_Door": {
                return PixelmonBlocks.hiddenWoodenDoor;
            }
            case "pixelmon:InsideWall": {
                return PixelmonBlocks.insideWallBlock;
            }
            case "pixelmon:InsideWallMolding": {
                return PixelmonBlocks.insideWallMoldingBlock;
            }
            case "pixelmon:Icy_Rock": {
                return PixelmonBlocks.icyRock;
            }
            case "pixelmon:Leafstone_Ore": {
                return PixelmonBlocks.leafStoneOre;
            }
            case "pixelmon:item.masterChest": {
                return PixelmonBlocks.masterChest;
            }
            case "pixelmon:item.MechanicalAnvil": {
                return PixelmonBlocks.mechanicalAnvil;
            }
            case "pixelmon:item.Mossy_Rock": {
                return PixelmonBlocks.mossyRock;
            }
            case "pixelmon:item.OrangeVendingMachine": {
                return PixelmonBlocks.orangeVendingMachineBlock;
            }
            case "pixelmon:item.OrangeWaterFloat": {
                return PixelmonBlocks.orangeWaterFloatBlock;
            }
            case "pixelmon:item.PC": {
                return PixelmonBlocks.pc;
            }
            case "pixelmon:item.PinkVendingMachine": {
                return PixelmonBlocks.pinkVendingMachineBlock;
            }
            case "pixelmon:item.PinkWaterFloat": {
                return PixelmonBlocks.pinkWaterFloatBlock;
            }
            case "pixelmon:item.pokeChest": {
                return PixelmonBlocks.pokeChest;
            }
            case "pixelmon:item.pokeGift": {
                return PixelmonBlocks.pokegiftBlock;
            }
            case "pixelmon:item.PurpleWaterFloat": {
                return PixelmonBlocks.purpleWaterFloatBlock;
            }
            case "pixelmon:item.Ranch_Block": {
                return PixelmonBlocks.ranchBlock;
            }
            case "pixelmon:item.RedPokeballRug": {
                return PixelmonBlocks.redRugBlock;
            }
            case "pixelmon:item.RedVendingMachine": {
                return PixelmonBlocks.redVendingMachineBlock;
            }
            case "pixelmon:item.RedWaterFloat": {
                return PixelmonBlocks.redWaterFloatBlock;
            }
            case "pixelmon:item.Trade_Machine": {
                return PixelmonBlocks.tradeMachine;
            }
            case "pixelmon:item.Tree": {
                return PixelmonBlocks.treeBlock;
            }
            case "pixelmon:item.Tres_Shrine": {
                return PixelmonBlocks.shrineTres;
            }
            case "pixelmon:item.TV": {
                return PixelmonBlocks.tvBlock;
            }
            case "pixelmon:item.ultraChest": {
                return PixelmonBlocks.ultraChest;
            }
            case "pixelmon:item.Uno_Shrine": {
                return PixelmonBlocks.shrineUno;
            }
            case "pixelmon:item.YellowPokeballRug": {
                return PixelmonBlocks.yellowRugBlock;
            }
            case "pixelmon:item.YellowVendingMachine": {
                return PixelmonBlocks.yellowVendingMachineBlock;
            }
            case "pixelmon:item.YellowWaterFloat": {
                return PixelmonBlocks.yellowWaterFloatBlock;
            }
            case "pixelmon:MovementPlate": {
                return PixelmonBlocks.movementPlate;
            }
            case "pixelmon:OutsideWall": {
                return PixelmonBlocks.outsideWallBlock;
            }
            case "pixelmon:PicketFenceNormal": {
                return PixelmonBlocks.picketFenceNormalBlock;
            }
            case "pixelmon:PinkClock": {
                return PixelmonBlocks.pinkClockBlock;
            }
            case "pixelmon:Pixelmon_Spawner": {
                return PixelmonBlocks.pixelmonSpawner;
            }
            case "pixelmon:SpawnerCaveRock": {
                return PixelmonBlocks.caveRockBlock;
            }
            case "pixelmon:PixelmonGrass": {
                return PixelmonBlocks.pixelmonGrassBlock;
            }
            case "pixelmon:PokeCenterSign": {
                return PixelmonBlocks.pokeCenterSignBlock;
            }
            case "pixelmon:PokeGrass": {
                return PixelmonBlocks.pokeGrassBlock;
            }
            case "pixelmon:PokeDirt": {
                return PixelmonBlocks.pokeDirtBlock;
            }
            case "pixelmon:tile.EventPokeGift": {
                return PixelmonBlocks.pokegiftEventBlock;
            }
            case "pixelmon:item.Healer": {
                return PixelmonBlocks.healer;
            }
            case "pixelmon:PokeMartSign": {
                return PixelmonBlocks.pokeMartSignBlock;
            }
            case "pixelmon:PokeSand": {
                return PixelmonBlocks.pokeSandBlock;
            }
            case "pixelmon:PokeSandC1": {
                return PixelmonBlocks.pokeSandCorner1Block;
            }
            case "pixelmon:PokeSandC2": {
                return PixelmonBlocks.pokeSandCorner2Block;
            }
            case "pixelmon:PokeSandC3": {
                return PixelmonBlocks.pokeSandCorner3Block;
            }
            case "pixelmon:PokeSandC4": {
                return PixelmonBlocks.pokeSandCorner4Block;
            }
            case "pixelmon:PokeSandS1": {
                return PixelmonBlocks.pokeSandSide1Block;
            }
            case "pixelmon:PokeSandS2": {
                return PixelmonBlocks.pokeSandSide2Block;
            }
            case "pixelmon:PokeSandS3": {
                return PixelmonBlocks.pokeSandSide3Block;
            }
            case "pixelmon:PokeSandS4": {
                return PixelmonBlocks.pokeSandSide4Block;
            }
            case "pixelmon:RedCushionChair": {
                return PixelmonBlocks.redCushionChairBlock;
            }
            case "pixelmon:RedUmbrella": {
                return PixelmonBlocks.redUmbrellaBlock;
            }
            case "pixelmon:Rock": {
                return PixelmonBlocks.rockBlock;
            }
            case "pixelmon:RubyBlock": {
                return PixelmonBlocks.rubyBlock;
            }
            case "pixelmon:RubyOre": {
                return PixelmonBlocks.rubyOre;
            }
            case "pixelmon:SandyGrass": {
                return PixelmonBlocks.sandyGrassBlock;
            }
            case "pixelmon:SapphireBlock": {
                return PixelmonBlocks.sapphireBlock;
            }
            case "pixelmon:SapphireOre": {
                return PixelmonBlocks.sapphireOre;
            }
            case "pixelmon:Shingles": {
                return PixelmonBlocks.shinglesBlock;
            }
            case "pixelmon:ShinglesC1": {
                return PixelmonBlocks.shinglesCorner1Block;
            }
            case "pixelmon:ShinglesC2": {
                return PixelmonBlocks.shinglesCorner2Block;
            }
            case "pixelmon:ShrineBlock": {
                return PixelmonBlocks.templeBlock;
            }
            case "pixelmon:ShrineBrick": {
                return PixelmonBlocks.templeBrick;
            }
            case "pixelmon:ShrineBrickStairs": {
                return PixelmonBlocks.templeBrickStairs;
            }
            case "pixelmon:ShrineStairs": {
                return PixelmonBlocks.templeStairs;
            }
            case "pixelmon:RuinsWall": {
                return PixelmonBlocks.ruinsWallBlock;
            }
            case "pixelmon:DustyRuinsWall": {
                return PixelmonBlocks.dustyRuinsWallBlock;
            }
            case "pixelmon:SiliconOre": {
                return PixelmonBlocks.siliconOre;
            }
            case "pixelmon:StickPlate": {
                return PixelmonBlocks.stickPlate;
            }
            case "pixelmon:Sun_Stone_Ore": {
                return PixelmonBlocks.sunStoneOre;
            }
            case "pixelmon:Thunderstone_Ore": {
                return PixelmonBlocks.thunderStoneOre;
            }
            case "pixelmon:TimedFall": {
                return PixelmonBlocks.timedFall;
            }
            case "pixelmon:Trashcan": {
                return PixelmonBlocks.trashcanBlock;
            }
            case "pixelmon:TreeBottom": {
                return PixelmonBlocks.treeBottomBlock;
            }
            case "pixelmon:TreeTop": {
                return PixelmonBlocks.treeTopBlock;
            }
            case "pixelmon:UnownBlock": {
                return PixelmonBlocks.blockUnown;
            }
            case "pixelmon:UnownBlock2": {
                return PixelmonBlocks.blockUnown2;
            }
            case "pixelmon:WarpPlate": {
                return PixelmonBlocks.warpPlate;
            }
            case "pixelmon:Waterstone_Ore": {
                return PixelmonBlocks.waterStoneOre;
            }
            case "pixelmon:Window1": {
                return PixelmonBlocks.window1Block;
            }
            case "pixelmon:Window2": {
                return PixelmonBlocks.window2Block;
            }
            case "pixelmon:WoodenFlooring": {
                return PixelmonBlocks.woodenFlooringBlock;
            }
            case "pixelmon:YellowCushionChair": {
                return PixelmonBlocks.yellowCushionChairBlock;
            }
            case "pixelmon:YellowUmbrella": {
                return PixelmonBlocks.yellowUmbrellaBlock;
            }
            case "pixelmon:item.Dos_Shrine": {
                return PixelmonBlocks.shrineDos;
            }
        }
        return null;
    }

    private static Item getNewItem(String name) {
        PixelmonItem item;
        String number;
        if ("pixelmon:fig_berry".equals(name)) {
            return PixelmonItemsHeld.figyBerry;
        }
        switch (name) {
            case "pixelmon:item.IcyRock": {
                return PixelmonItemsHeld.icyRock;
            }
            case "pixelmon:item.spawnGrotto": 
            case "pixelmon:spawn_grotto": {
                return PixelmonItems.grottoSpawner;
            }
        }
        if (name.matches("pixelmon:TM\\d+_-_.*")) {
            number = name.substring("pixelmon:TM".length(), name.indexOf("_-_"));
            return PixelmonItemsTMs.TMs.stream().filter(c -> c.getRegistryName().func_110623_a().equals("tm" + number)).findFirst().get();
        }
        if (name.matches("pixelmon:HM\\d+_-_.*")) {
            number = name.substring("pixelmon:HM".length(), name.indexOf("_-_"));
            return PixelmonItemsTMs.HMs.stream().filter(c -> c.getRegistryName().func_110623_a().equals("hm" + number)).findFirst().get();
        }
        if (name.matches("pixelmon:item\\..*_Ball")) {
            String ball = name.substring("pixelmon:item.".length()).toLowerCase();
            for (Field field : PixelmonItemsPokeballs.class.getFields()) {
                try {
                    if (field.get(null) instanceof ItemPokeball && (item = (ItemPokeball)((Object)field.get(null))).getRegistryName().func_110623_a().equals(ball)) {
                        return item;
                    }
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }
        if (name.matches("pixelmon:item.*Badge")) {
            String badge = name.substring("pixelmon:item.".length()).toLowerCase();
            try {
                for (Field field : PixelmonItemsBadges.class.getFields()) {
                    if (!(field.get(null) instanceof Item) || !(item = (Item)field.get(null)).getRegistryName().func_110623_a().equals(badge)) continue;
                    return item;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (name.matches("pixelmon:item.*Apricorn")) {
            String apricorn = name.substring("pixelmon:item.".length()).toLowerCase();
            try {
                for (Field field : PixelmonItemsApricorns.class.getFields()) {
                    if (!(field.get(null) instanceof Item) || !(item = (Item)field.get(null)).getRegistryName().func_110623_a().equals(apricorn)) continue;
                    return item;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (name.startsWith("pixelmon:item.coveredFossil")) {
            String fossil = "covered_fossil_" + name.substring("pixelmon:item.coveredFossil".length());
            for (Field field : PixelmonItemsFossils.class.getFields()) {
                try {
                    if (field.get(null) instanceof ItemCoveredFossil && (item = (ItemCoveredFossil)((Object)field.get(null))).getRegistryName().func_110623_a().equals(fossil)) {
                        return item;
                    }
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }
        if (name.startsWith("pixelmon:PokeMail-")) {
            String mailName = name.substring("pixelmon:PokeMail-".length());
            return PixelmonItemsMail.items.stream().filter(c -> c.getRegistryName().func_110623_a().equals("pokemail_" + mailName)).findFirst().get();
        }
        if (name.toLowerCase().contains("icy_rock")) {
            return null;
        }
        if (name.toLowerCase().contains("icyrock")) {
            return null;
        }
        Object itemName = name.replace(":item.", ":");
        if (itemName.startsWith("pixelmon:")) {
            itemName = itemName.substring("pixelmon:".length());
        }
        switch (itemName) {
            case "ranchupgrade": {
                return PixelmonItems.ranchUpgrade;
            }
            case "King's_Rock": {
                return PixelmonItemsHeld.kingsRock;
            }
            case "Fossil_Machine_Tank": {
                return PixelmonItemsFossils.fossilMachineTank;
            }
            case "Fossil_Machine_Display": {
                return PixelmonItemsFossils.fossilMachineDisplay;
            }
            case "Fossil_Machine_Top": {
                return PixelmonItemsFossils.fossilMachineTop;
            }
            case "Fossil_Machine_Base": {
                return PixelmonItemsFossils.fossilMachineBase;
            }
            case "hourglasssilver": {
                return PixelmonItems.hourglassSilver;
            }
            case "hourglassgold": {
                return PixelmonItems.hourglassGold;
            }
            case "Exp._Share": {
                return PixelmonItemsHeld.expShare;
            }
            case "EntityPixelmonPaintingItem": 
            case "painting_item": {
                return PixelmonItems.pixelmonPaintingItem;
            }
        }
        if (itemName.contains("Hidden_Iron_Door") || itemName.contains("HiddenIronDoor") || itemName.contains("Hidden_Wooden_Door") || itemName.contains("HiddenWoodenDoor") || itemName.contains("Hidden_Pressure_Plate") || itemName.contains("Hidden_Cube") || itemName.contains("Tree")) {
            return null;
        }
        if (itemName.contains("-")) {
            itemName = itemName.toLowerCase();
        }
        if (itemName.contains(" ")) {
            itemName = itemName.replace(" ", "_").toLowerCase();
        }
        if (!itemName.contains("_")) {
            itemName = RemapHandler.toSnakeCase((String)itemName);
            itemName = itemName.replace("stone", "_stone");
        }
        itemName = itemName.toLowerCase();
        try {
            for (Field field : PixelmonItemsHeld.class.getFields()) {
                if (!(field.get(null) instanceof Item) || !(item = (Item)field.get(null)).getRegistryName().func_110623_a().equals(itemName)) continue;
                return item;
            }
            for (Field field : PixelmonItemsTools.class.getFields()) {
                if (!(field.get(null) instanceof Item) || !(item = (Item)field.get(null)).getRegistryName().func_110623_a().equals(itemName)) continue;
                return item;
            }
            for (Field field : PixelmonItemsPokeballs.class.getFields()) {
                if (!(field.get(null) instanceof PixelmonItem) || !(item = (PixelmonItem)((Object)field.get(null))).getRegistryName().func_110623_a().equals(itemName)) continue;
                return item;
            }
            for (Field field : PixelmonItems.class.getFields()) {
                if (!(field.get(null) instanceof Item) || (item = (Item)field.get(null)).getRegistryName() == null || !item.getRegistryName().func_110623_a().equals(itemName)) continue;
                return item;
            }
            for (Field field : PixelmonItemsFossils.class.getFields()) {
                if (!(field.get(null) instanceof PixelmonItem) || !(item = (PixelmonItem)((Object)field.get(null))).getRegistryName().func_110623_a().equals(itemName)) continue;
                return item;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private static String toSnakeCase(String text) {
        return StringUtils.join((Object[])text.split("(?<!(^|[A-Z]))(?=[A-Z])|(?<!^)(?=[A-Z][a-z])"), (String)"_");
    }

    public static void attemptHackyFixForRipOffPixelmonMappingIssues(MinecraftServer server) {
        File file1 = server.func_71254_M().func_186352_b(server.func_71270_I(), "level.dat");
        try {
            NBTTagCompound registries;
            NBTTagCompound compound = CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(file1));
            NBTTagCompound dataVersions = compound.func_74775_l("Data").func_74775_l("ForgeDataVersion");
            NBTTagList modList = compound.func_74775_l("FML").func_150295_c("ModList", 10);
            String oldPixelmonVer = null;
            for (NBTBase base : modList) {
                NBTTagCompound modInfo = (NBTTagCompound)base;
                if (!modInfo.func_74779_i("ModId").equals("pixelmon")) continue;
                oldPixelmonVer = modInfo.func_74779_i("ModVersion");
            }
            if (oldPixelmonVer != null && (oldPixelmonVer.startsWith("2") || oldPixelmonVer.startsWith("3"))) {
                if (modfix == null) {
                    modfix = FMLCommonHandler.instance().getDataFixer().init("pixelmon", 7);
                }
                FileUtils.copyFile((File)file1, (File)server.func_71254_M().func_186352_b(server.func_71270_I(), "level-pixelmonBackup.dat"));
                registries = compound.func_74775_l("FML").func_74775_l("Registries");
                NBTTagCompound blocksReg = registries.func_74775_l("minecraft:blocks");
                for (Object entry : blocksReg.func_150295_c("ids", 10)) {
                    String name;
                    NBTTagCompound block = (NBTTagCompound)entry;
                    String id = block.func_74779_i("K");
                    if (!id.startsWith("pixelmon:") || !(name = id.substring("pixelmon:".length())).startsWith("grey")) continue;
                    block.func_74778_a("K", id.replace("grey", "gray"));
                }
                NBTTagCompound itemsReg = registries.func_74775_l("minecraft:items");
                for (NBTBase entry2 : itemsReg.func_150295_c("ids", 10)) {
                    NBTTagCompound item = (NBTTagCompound)entry2;
                    String id = item.func_74779_i("K");
                    if (!id.startsWith("pixelmon:")) continue;
                    String name = id.substring("pixelmon:".length());
                    if (name.endsWith("_memory_drive")) {
                        Pixelmon.LOGGER.warn("Renaming " + id + " to " + id.replace("_memory_drive", "_memory") + " generations conversion");
                        item.func_74778_a("K", id.replace("_memory_drive", "_memory"));
                        continue;
                    }
                    if (name.equals("faded_blue_orb")) {
                        Pixelmon.LOGGER.warn("Renaming " + id + " to " + id.replace("faded_blue_orb", "blue_orb") + " generations conversion");
                        item.func_74778_a("K", id.replace("faded_blue_orb", "blue_orb"));
                        continue;
                    }
                    if (name.equals("faded_red_orb")) {
                        Pixelmon.LOGGER.warn("Renaming " + id + " to " + id.replace("faded_red_orb", "red_orb") + " generations conversion");
                        item.func_74778_a("K", id.replace("faded_red_orb", "red_orb"));
                        continue;
                    }
                    if (name.equals("green_shard")) {
                        Pixelmon.LOGGER.warn("Renaming " + id + " to " + id.replace("green_shard", "jade_shard") + " generations conversion");
                        item.func_74778_a("K", id.replace("green_shard", "jade_shard"));
                        continue;
                    }
                    if (name.startsWith("grey")) {
                        Pixelmon.LOGGER.warn("Renaming " + id + " to " + id.replace("grey", "gray") + " generations conversion");
                        item.func_74778_a("K", id.replace("grey", "gray"));
                        continue;
                    }
                    if (!name.equals("chair")) continue;
                    Pixelmon.LOGGER.warn("Renaming " + id + " to " + id.replace("chair", "red_chair") + " generations conversion");
                    item.func_74778_a("K", id.replace("chair", "red_chair"));
                }
                CompressedStreamTools.func_74799_a((NBTTagCompound)compound, (OutputStream)new FileOutputStream(file1));
            }
            if (modfix != null || dataVersions.func_74764_b("pixelmon")) {
                if (modfix == null) {
                    modfix = FMLCommonHandler.instance().getDataFixer().init("pixelmon", 7);
                }
                modfix.registerFix((IFixType)FixTypes.ITEM_INSTANCE, new IFixableData(){

                    public int func_188216_a() {
                        return 2;
                    }

                    public NBTTagCompound func_188217_a(NBTTagCompound item) {
                        String id = item.func_74779_i("id");
                        if (!id.startsWith("pixelmon:")) {
                            return item;
                        }
                        String name = id.substring("pixelmon:".length());
                        if (name.endsWith("_memory_drive")) {
                            item.func_74778_a("id", id.replace("_memory_drive", "_memory"));
                        }
                        if (name.endsWith("_fossil_display")) {
                            item.func_74778_a("id", "pixelmon:fossil_display");
                        }
                        if (name.equals("tm175")) {
                            item.func_74778_a("id", id.replace("tm175", "hm2"));
                        }
                        if (name.equals("tm176")) {
                            item.func_74778_a("id", id.replace("tm176", "hm3"));
                        }
                        if (name.equals("tm177")) {
                            item.func_74778_a("id", id.replace("tm177", "hm7"));
                        }
                        if (name.equals("faded_blue_orb")) {
                            item.func_74778_a("id", id.replace("faded_blue_orb", "blue_orb"));
                        }
                        if (name.equals("faded_red_orb")) {
                            item.func_74778_a("id", id.replace("faded_red_orb", "red_orb"));
                        }
                        if (name.equals("green_shard")) {
                            item.func_74778_a("id", id.replace("green_shard", "jade_shard"));
                        }
                        if (name.startsWith("lightgrey_")) {
                            item.func_74778_a("id", id.replace("lightgrey_", "gray_"));
                        }
                        if (name.startsWith("magenta_")) {
                            item.func_74778_a("id", id.replace("magenta_", "purple_"));
                        }
                        if (name.startsWith("lime_")) {
                            item.func_74778_a("id", id.replace("lime_", "green_"));
                        }
                        if (name.startsWith("lightblue_")) {
                            item.func_74778_a("id", id.replace("lightblue_", "blue_"));
                        }
                        if (name.startsWith("grey")) {
                            item.func_74778_a("id", id.replace("grey", "gray"));
                        }
                        if (name.equals("chair")) {
                            item.func_74778_a("id", id.replace("chair", "red_chair"));
                        }
                        return item;
                    }
                });
            }
            if (compound.func_74775_l("Data").func_74762_e("DataVersion") < 1343) {
                NBTTagCompound entry;
                NBTBase entry2;
                FileUtils.copyFile((File)file1, (File)server.func_71254_M().func_186352_b(server.func_71270_I(), "level-pixelmonBackup.dat"));
                registries = compound.func_74775_l("FML").func_74775_l("Registries");
                NBTTagList blocks = registries.func_74775_l("minecraft:blocks").func_150295_c("aliases", 10);
                NBTTagList items = registries.func_74775_l("minecraft:items").func_150295_c("aliases", 10);
                Iterator i = blocks.iterator();
                while (i.hasNext()) {
                    entry2 = (NBTTagCompound)i.next();
                    if (!entry2.func_74779_i("K").equalsIgnoreCase(entry2.func_74779_i("V"))) continue;
                    Pixelmon.LOGGER.debug("Removing block alias: " + entry2.func_74779_i("K"));
                    i.remove();
                }
                i = items.iterator();
                while (i.hasNext()) {
                    entry2 = (NBTTagCompound)i.next();
                    if (!entry2.func_74779_i("K").equalsIgnoreCase(entry2.func_74779_i("V"))) continue;
                    Pixelmon.LOGGER.debug("Removing item alias: " + entry2.func_74779_i("K"));
                    i.remove();
                }
                NBTTagList dummiedBlocks = registries.func_74775_l("minecraft:blocks").func_150295_c("dummied", 10);
                NBTTagList dummiedItems = registries.func_74775_l("minecraft:items").func_150295_c("dummied", 10);
                Iterator i2 = dummiedBlocks.iterator();
                while (i2.hasNext()) {
                    entry = (NBTTagCompound)i2.next();
                    if (!entry.func_74779_i("K").startsWith("pixelmon:")) continue;
                    Pixelmon.LOGGER.debug("Removing dummied block: " + entry.func_74779_i("K"));
                    i2.remove();
                }
                i2 = dummiedItems.iterator();
                while (i2.hasNext()) {
                    entry = (NBTTagCompound)i2.next();
                    if (!entry.func_74779_i("K").startsWith("pixelmon:")) continue;
                    Pixelmon.LOGGER.debug("Removing dummied item: " + entry.func_74779_i("K"));
                    i2.remove();
                }
                CompressedStreamTools.func_74799_a((NBTTagCompound)compound, (OutputStream)new FileOutputStream(file1));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

