/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.config;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.items.ItemTM;
import java.util.ArrayList;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class PixelmonItemsTMs {
    public static ArrayList<Item> TMs = new ArrayList();
    public static ArrayList<Item> HMs = new ArrayList();
    private static ArrayList<String> TMNames = Lists.newArrayList((Object[])new String[]{"Hone Claws", "Dragon Claw", "Psyshock", "Calm Mind", "Roar", "Toxic", "Hail", "Bulk Up", "Venoshock", "Hidden Power", "Sunny Day", "Taunt", "Ice Beam", "Blizzard", "Hyper Beam", "Light Screen", "Protect", "Rain Dance", "Telekinesis", "Safeguard", "Frustration", "Solar Beam", "Smack Down", "Thunderbolt", "Thunder", "Earthquake", "Return", "Dig", "Psychic", "Shadow Ball", "Brick Break", "Double Team", "Reflect", "Sludge Wave", "Flamethrower", "Sludge Bomb", "Sandstorm", "Fire Blast", "Rock Tomb", "Aerial Ace", "Torment", "Facade", "Flame Charge", "Rest", "Attract", "Thief", "Low Sweep", "Round", "Echoed Voice", "Overheat", "Ally Switch", "Focus Blast", "Energy Ball", "False Swipe", "Scald", "Fling", "Charge Beam", "Sky Drop", "Incinerate", "Quash", "Will-O-Wisp", "Acrobatics", "Embargo", "Explosion", "Shadow Claw", "Payback", "Retaliate", "Giga Impact", "Rock Polish", "Flash", "Stone Edge", "Volt Switch", "Thunder Wave", "Gyro Ball", "Swords Dance", "Struggle Bug", "Psych Up", "Bulldoze", "Frost Breath", "Rock Slide", "X-Scissor", "Dragon Tail", "Work Up", "Poison Jab", "Dream Eater", "Grass Knot", "Swagger", "Pluck", "U-Turn", "Substitute", "Flash Cannon", "Trick Room", "Wild Charge", "Rock Smash", "Snarl", "Mega Punch", "Razor Wind", "Whirlwind", "Mega Kick", "Horn Drill", "Body Slam", "Take Down", "Double-Edge", "Bubble Beam", "Water Gun", "Pay Day", "Submission", "Counter", "Seismic Toss", "Rage", "Mega Drain", "Dragon Rage", "Fissure", "Teleport", "Mimic", "Bide", "Metronome", "Self-Destruct", "Egg Bomb", "Swift", "Skull Bash", "Soft-Boiled", "Sky Attack", "Psywave", "Tri Attack", "Dynamic Punch", "Headbutt", "Curse", "Rollout", "Zap Cannon", "Sweet Scent", "Snore", "Icy Wind", "Giga Drain", "Endure", "Iron Tail", "Dragon Breath", "Mud-Slap", "Ice Punch", "Sleep Talk", "Defense Curl", "Thunder Punch", "Detect", "Steel Wing", "Fire Punch", "Fury Cutter", "Nightmare", "Focus Punch", "Water Pulse", "Bullet Seed", "Shock Wave", "Secret Power", "Skill Swap", "Snatch", "Roost", "Brine", "Dragon Pulse", "Drain Punch", "Silver Wind", "Recycle", "Avalanche", "Stealth Rock", "Captivate", "Dark Pulse", "Natural Gift", "Infestation", "Nature Power", "Power-Up Punch", "Dazzling Gleam", "Confide", "Aurora Veil", "Brutal Swing", "Smart Strike", "Leech Life"});
    private static ArrayList<String> HMNames = Lists.newArrayList((Object[])new String[]{"Cut", "Fly", "Surf", "Strength", "Defog", "Rock Smash", "Waterfall", "Rock Climb", "Whirlpool", "Dive"});

    static void load() {
        Pixelmon.LOGGER.info("Loading TM/HMs.");
        for (String tm : TMNames) {
            TMs.add(new ItemTM(tm, TMNames.indexOf(tm) + 1, false));
        }
        for (String hm : HMNames) {
            HMs.add(new ItemTM(hm, HMNames.indexOf(hm) + 1, true));
        }
    }

    static void registerItems(RegistryEvent.Register<Item> event) {
        PixelmonItemsTMs.load();
        for (Item item : TMs) {
            event.getRegistry().register((IForgeRegistryEntry)item);
        }
        for (Item item : HMs) {
            event.getRegistry().register((IForgeRegistryEntry)item);
        }
    }

    static void registerRenderers() {
        try {
            for (Item item : TMs) {
                ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), "inventory"));
            }
            for (Item item : HMs) {
                ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), "inventory"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

