/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.commands.client;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommand;
import com.pixelmonmod.pixelmon.comm.packetHandlers.PlayerExtrasPacket;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import com.pixelmonmod.pixelmon.storage.extras.PixelExtrasData;
import com.pixelmonmod.pixelmon.storage.extras.PlayerExtraDataStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.commons.lang3.StringUtils;

public class RedeemCommand
extends PixelmonCommand {
    @Override
    public String func_71517_b() {
        return "redeem";
    }

    @Override
    public String func_71518_a(ICommandSender icommandsender) {
        return "/redeem <slot number/hat name/remove hat/toggle sash>";
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return true;
    }

    @Override
    public void execute(ICommandSender sender, String[] args) throws CommandException {
        EntityPlayer player = (EntityPlayer)sender;
        PixelExtrasData data = PlayerExtraDataStore.get(player);
        if (args.length == 0) {
            PlayerExtraDataStore.refreshClient(newData -> {
                StringBuilder sb = new StringBuilder("Available:");
                if (newData.hasData()) {
                    for (PixelExtrasData.HatType hat : newData.getAvailableHats()) {
                        sb.append(" ").append(hat.name().toLowerCase());
                    }
                    for (PixelExtrasData.MonocleType monocle : newData.getAvailableMonocles()) {
                        sb.append(" ").append(monocle.name().toLowerCase());
                    }
                    for (EnumSpecies species : newData.getAvailableTextures()) {
                        sb.append(" ").append(species == EnumSpecies.Lugia ? "shadow_lugia" : (species == EnumSpecies.Haunter ? "spectral_jeweller" : (species == EnumSpecies.Wobbuffet ? "wobeefet" : "")));
                    }
                    for (PixelExtrasData.RobeType robe : newData.getAvailableRobes()) {
                        sb.append(" ").append(robe.name().toLowerCase()).append("_robe");
                    }
                    if (newData.hasBoostedNecklace()) {
                        sb.append(" boosted_necklace");
                    }
                    if (newData.getSashType() != PixelExtrasData.SashType.NONE) {
                        switch (newData.getSashType()) {
                            case REGULAR: {
                                sb.append(" sash");
                                break;
                            }
                            case RAINBOW: {
                                sb.append(" rainbow_sash");
                                break;
                            }
                            default: {
                                sb.append(" team_sash");
                                break;
                            }
                        }
                    }
                } else {
                    sb.append(" No data found");
                }
                player.func_145747_a((ITextComponent)new TextComponentString(sb.toString()));
            });
        } else if (data.hasData()) {
            if (args.length == 2 && StringUtils.containsAny((CharSequence)args[0], (CharSequence[])new CharSequence[]{"enable", "disable", "toggle"}) && StringUtils.containsAny((CharSequence)args[1], (CharSequence[])new CharSequence[]{"hat", "sash", "robe", "monocle"})) {
                PixelExtrasData.Category category;
                PixelExtrasData.Category category2 = args[1].equalsIgnoreCase("hat") ? PixelExtrasData.Category.HAT : (args[1].equalsIgnoreCase("sash") ? PixelExtrasData.Category.SASH : (category = args[1].equalsIgnoreCase("robe") ? PixelExtrasData.Category.ROBE : PixelExtrasData.Category.MONOCLE));
                if (args[0].equalsIgnoreCase("enable")) {
                    data.setEnabled(category, true);
                    PlayerExtraDataStore.saveAndSend();
                    this.sendMessage(sender, TextFormatting.GREEN, "pixelmon.command.general.enabled", category.toString().toLowerCase());
                } else if (args[0].equalsIgnoreCase("disable")) {
                    data.setEnabled(category, false);
                    PlayerExtraDataStore.saveAndSend();
                    this.sendMessage(sender, TextFormatting.RED, "pixelmon.command.general.disabled", category.toString().toLowerCase());
                } else if (args[0].equalsIgnoreCase("toggle")) {
                    data.setEnabled(category, !data.isEnabled(category));
                    if (data.isEnabled(category)) {
                        this.sendMessage(sender, TextFormatting.GREEN, "pixelmon.command.general.enabled", category.toString().toLowerCase());
                    } else {
                        this.sendMessage(sender, TextFormatting.RED, "pixelmon.command.general.disabled", category.toString().toLowerCase());
                    }
                    PlayerExtraDataStore.saveAndSend();
                } else {
                    this.sendMessage(sender, TextFormatting.RED, "pixelmon.command.general.invalid", new Object[0]);
                }
            } else if (StringUtils.containsAny((CharSequence)args[0], (CharSequence[])new CharSequence[]{"trainerhat", "trainercap"})) {
                if (data.setHatType(PixelExtrasData.HatType.TRAINER_CAP)) {
                    if (args.length == 4) {
                        try {
                            int r = Integer.parseInt(args[1]);
                            int g = Integer.parseInt(args[2]);
                            int b = Integer.parseInt(args[3]);
                            if (r > 255 || r < -1 || g > 255 || g < 0 || b > 255 || b < 0) {
                                this.sendMessage(sender, TextFormatting.RED, "pixelmon.command.trainerhat.invalidcolour", new Object[0]);
                            } else {
                                data.setColours(PixelExtrasData.Category.HAT, new int[]{r, g, b});
                            }
                        }
                        catch (NumberFormatException e) {
                            this.sendMessage(sender, TextFormatting.RED, "pixelmon.command.trainerhat.invalidcolour", new Object[0]);
                        }
                    }
                    PlayerExtraDataStore.saveAndSend();
                    this.sendMessage(sender, TextFormatting.GREEN, "pixelmon.command.general.enabled", "trainercap");
                } else {
                    RedeemCommand.endCommand("pixelmon.command.general.cannot", new Object[0]);
                }
            } else if (args[0].equalsIgnoreCase("sash")) {
                if (data.getSashType() == PixelExtrasData.SashType.REGULAR) {
                    if (args.length == 4) {
                        try {
                            int r = Integer.parseInt(args[1]);
                            int g = Integer.parseInt(args[2]);
                            int b = Integer.parseInt(args[3]);
                            if (r > 255 || r < -1 || g > 255 || g < 0 || b > 255 || b < 0) {
                                this.sendMessage(sender, TextFormatting.RED, "pixelmon.command.trainerhat.invalidcolour", new Object[0]);
                            } else {
                                data.setColours(PixelExtrasData.Category.SASH, new int[]{r, g, b});
                            }
                        }
                        catch (NumberFormatException e) {
                            this.sendMessage(sender, TextFormatting.RED, "pixelmon.command.trainerhat.invalidcolour", new Object[0]);
                        }
                    }
                    PlayerExtraDataStore.saveAndSend();
                }
            } else if (args[0].equalsIgnoreCase("tophat")) {
                if (data.setHatType(PixelExtrasData.HatType.TOP_HAT)) {
                    PlayerExtraDataStore.saveAndSend();
                    this.sendMessage(sender, TextFormatting.GREEN, "pixelmon.command.general.enabled", "tophat");
                } else {
                    RedeemCommand.endCommand("pixelmon.command.general.cannot", new Object[0]);
                }
            } else if (args[0].equalsIgnoreCase("fez")) {
                if (data.setHatType(PixelExtrasData.HatType.FEZ)) {
                    PlayerExtraDataStore.saveAndSend();
                    this.sendMessage(sender, TextFormatting.GREEN, "pixelmon.command.general.enabled", "fez");
                } else {
                    RedeemCommand.endCommand("pixelmon.command.general.cannot", new Object[0]);
                }
            } else if (args[0].equalsIgnoreCase("fedora")) {
                if (data.setHatType(PixelExtrasData.HatType.FEDORA)) {
                    PlayerExtraDataStore.saveAndSend();
                    this.sendMessage(sender, TextFormatting.GREEN, "pixelmon.command.general.enabled", "fedora");
                } else {
                    RedeemCommand.endCommand("pixelmon.command.general.cannot", new Object[0]);
                }
            } else if (args[0].equalsIgnoreCase("blackmonocle")) {
                if (data.setMonocleType(PixelExtrasData.MonocleType.BLACK_MONOCLE)) {
                    PlayerExtraDataStore.saveAndSend();
                    this.sendMessage(sender, TextFormatting.GREEN, "pixelmon.command.general.enabled", "blackmonocle");
                } else {
                    RedeemCommand.endCommand("pixelmon.command.general.cannot", new Object[0]);
                }
            } else if (args[0].equalsIgnoreCase("goldmonocle")) {
                if (data.setMonocleType(PixelExtrasData.MonocleType.GOLD_MONOCLE)) {
                    PlayerExtraDataStore.saveAndSend();
                    this.sendMessage(sender, TextFormatting.GREEN, "pixelmon.command.general.enabled", "goldmonocle");
                } else {
                    RedeemCommand.endCommand("pixelmon.command.general.cannot", new Object[0]);
                }
            } else if (args[0].equalsIgnoreCase("pikahood")) {
                if (data.setHatType(PixelExtrasData.HatType.PIKA_HOOD)) {
                    PlayerExtraDataStore.saveAndSend();
                    this.sendMessage(sender, TextFormatting.GREEN, "pixelmon.command.general.enabled", "pikahood");
                } else {
                    RedeemCommand.endCommand("pixelmon.command.general.cannot", new Object[0]);
                }
            } else if (args[0].equalsIgnoreCase("eeveehood")) {
                if (data.setHatType(PixelExtrasData.HatType.EEVEE_HOOD)) {
                    PlayerExtraDataStore.saveAndSend();
                    this.sendMessage(sender, TextFormatting.GREEN, "pixelmon.command.general.enabled", "eeveehood");
                } else {
                    RedeemCommand.endCommand("pixelmon.command.general.cannot", new Object[0]);
                }
            } else if (args[0].equalsIgnoreCase("scorhood")) {
                if (data.setHatType(PixelExtrasData.HatType.SCOR_HOOD)) {
                    PlayerExtraDataStore.saveAndSend();
                    this.sendMessage(sender, TextFormatting.GREEN, "pixelmon.command.general.enabled", "scorhood");
                } else {
                    RedeemCommand.endCommand("pixelmon.command.general.cannot", new Object[0]);
                }
            } else if (args[0].equalsIgnoreCase("wizardlyrobe") || args[0].equalsIgnoreCase("robe")) {
                if (data.setRobeType(PixelExtrasData.RobeType.WIZARD)) {
                    PlayerExtraDataStore.saveAndSend();
                    this.sendMessage(sender, TextFormatting.GREEN, "pixelmon.command.general.enabled", "wizardlyrobe");
                } else {
                    RedeemCommand.endCommand("pixelmon.command.general.cannot", new Object[0]);
                }
            } else if (args[0].equalsIgnoreCase("wiki") || args[0].equalsIgnoreCase("grandcap")) {
                if (data.setHatType(PixelExtrasData.HatType.WIKI)) {
                    PlayerExtraDataStore.saveAndSend();
                    this.sendMessage(sender, TextFormatting.GREEN, "pixelmon.command.general.enabled", "grandcap");
                } else {
                    RedeemCommand.endCommand("pixelmon.command.general.cannot", new Object[0]);
                }
            } else if (data.canSeeTexture(EnumSpecies.Lugia) || data.canSeeTexture(EnumSpecies.Haunter) || data.canSeeTexture(EnumSpecies.Wobbuffet)) {
                try {
                    int slot = Integer.parseInt(args[0]);
                    Pixelmon.network.sendToServer((IMessage)PlayerExtrasPacket.getSetTexturePacket(slot));
                }
                catch (NumberFormatException e) {
                    this.sendMessage(sender, TextFormatting.RED, "pixelmon.command.general.invalid", new Object[0]);
                }
            } else {
                this.sendMessage(sender, TextFormatting.RED, "pixelmon.command.general.invalid", new Object[0]);
            }
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        EntityPlayer player = (EntityPlayer)sender;
        PixelExtrasData data = PlayerExtraDataStore.get(player);
        if (!data.hasData()) {
            return Lists.newArrayList();
        }
        ArrayList list = Lists.newArrayList();
        if (data.hasData() && args.length == 1) {
            for (PixelExtrasData.HatType hatType : data.getAvailableHats()) {
                list.add(hatType.toString().toLowerCase().replace("_", ""));
            }
            for (PixelExtrasData.MonocleType monocleType : data.getAvailableMonocles()) {
                list.add(monocleType.toString().toLowerCase().replace("_", ""));
            }
            for (PixelExtrasData.RobeType robeType : data.getAvailableRobes()) {
                list.add(robeType.toString().toLowerCase() + "robe");
            }
            list.add("enable");
            list.add("disable");
            list.add("toggle");
        }
        if (args.length == 2 && StringUtils.containsAny((CharSequence)args[0], (CharSequence[])new CharSequence[]{"enable", "disable", "toggle"})) {
            list.add("sash");
            list.add("robe");
            list.add("hat");
            list.add("monocle");
        }
        return RedeemCommand.func_175762_a((String[])args, (Collection)list);
    }
}

