/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.commands;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommand;
import com.pixelmonmod.pixelmon.api.dialogue.Choice;
import com.pixelmonmod.pixelmon.api.dialogue.Dialogue;
import com.pixelmonmod.pixelmon.api.overlay.notice.EnumOverlayLayout;
import com.pixelmonmod.pixelmon.api.overlay.notice.NoticeOverlay;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonSpec;
import com.pixelmonmod.pixelmon.api.pokemon.SpecValue;
import com.pixelmonmod.pixelmon.api.pokemon.SpecValueTypeAdapter;
import com.pixelmonmod.pixelmon.api.spawning.SpawnInfo;
import com.pixelmonmod.pixelmon.api.spawning.SpawnSet;
import com.pixelmonmod.pixelmon.api.spawning.conditions.LocationType;
import com.pixelmonmod.pixelmon.api.spawning.util.SetLoader;
import com.pixelmonmod.pixelmon.api.world.BlockCollection;
import com.pixelmonmod.pixelmon.api.world.WeatherType;
import com.pixelmonmod.pixelmon.api.world.WorldTime;
import com.pixelmonmod.pixelmon.battles.attacks.AttackBase;
import com.pixelmonmod.pixelmon.blocks.enums.EnumAxis;
import com.pixelmonmod.pixelmon.client.models.PixelmonModelBase;
import com.pixelmonmod.pixelmon.client.models.PixelmonModelRegistry;
import com.pixelmonmod.pixelmon.client.models.PixelmonModelSmd;
import com.pixelmonmod.pixelmon.client.models.blocks.GenericSmdModel;
import com.pixelmonmod.pixelmon.client.models.smd.ValveStudioModel;
import com.pixelmonmod.pixelmon.config.PixelmonItems;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.RidingOffsets;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.StatsType;
import com.pixelmonmod.pixelmon.enums.EnumFeatureState;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import com.pixelmonmod.pixelmon.enums.forms.IEnumForm;
import com.pixelmonmod.pixelmon.pokedex.EnumPokedexRegisterStatus;
import com.pixelmonmod.pixelmon.storage.PlayerPartyStorage;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.vecmath.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.biome.Biome;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class DebugCommand
extends PixelmonCommand {
    private final HashMap<String, Execute> subCommands = new HashMap();
    private final HashMap<String, TabCompletion> subCompletions = new HashMap();

    public DebugCommand() {
        super("pixeldebug", "", 4);
        this.registerSubCommand("dexfill", this::dexFill);
        this.registerSubCommand("lang", this::langCheck);
        this.registerSubCommand("spec", this::spec);
        this.registerSubCommand("hween", this::hween);
        this.registerSubCommand("moveflags", this::moveFlags);
        this.registerSubCommand("fov", this::fov);
        this.registerSubCommand("render", this::render);
        this.registerSubCommand("reloadmodels", this::reloadModels);
        this.registerSubCommand("itemsprite", this::itemSprite);
        this.registerSubCommand("collection", this::collection);
        this.registerSubCommand("modelscale", this::modelScale, "model-scale");
        this.registerSubCommand("ridingoffset", this::ridingOffset);
        this.registerSubCommand("dialogue", this::dialogue);
        this.registerSubCommand("noticeoverlay", this::noticeoverlay);
        this.registerSubCommand("spawnwiki", this::spawnwiki);
        this.registerSubCompletion("hween", (sender, args, pos) -> args.length == 1 ? DebugCommand.tabComplete(args, "true", "false") : DebugCommand.tabComplete(args, new String[0]));
        this.registerSubCompletion("moveflags", (sender, args, pos) -> args.length == 1 ? DebugCommand.tabComplete(args, "authentic", "sound") : DebugCommand.tabComplete(args, new String[0]));
        this.registerSubCompletion("modelscale", (sender, args, pos) -> args.length == 1 ? DebugCommand.tabCompletePokemon(args) : DebugCommand.tabComplete(args, new String[0]));
        this.registerSubCompletion("ridingoffset", (sender, args, pos) -> args.length == 1 ? DebugCommand.tabCompletePokemon(args) : (args.length == 2 ? DebugCommand.tabComplete(args, "moving", "standing") : (args.length == 3 ? DebugCommand.tabComplete(args, "x", "y", "z") : DebugCommand.tabComplete(args, new String[0]))));
        this.registerSubCompletion("noticeoverlay", (sender, args, pos) -> args.length == 1 ? DebugCommand.tabComplete(args, "pokemonsprite", "pokemon3d", "itemstack") : DebugCommand.tabComplete(args, new String[0]));
    }

    public void dexFill(ICommandSender sender, String[] args) throws CommandException {
        if (sender instanceof EntityPlayerMP) {
            EntityPlayerMP player = DebugCommand.requireEntityPlayer(sender);
            PlayerPartyStorage store = Pixelmon.storageManager.getParty(player);
            for (EnumSpecies species : EnumSpecies.values()) {
                store.pokedex.set(species.getNationalPokedexInteger(), EnumPokedexRegisterStatus.caught);
            }
        }
    }

    public void langCheck(ICommandSender sender, String[] args) throws CommandException {
        DebugCommand.checkMissingBlockLangEntries();
        DebugCommand.checkMissingItemLangEntries();
        DebugCommand.checkMissingPokemonLangEntries();
    }

    public void spec(ICommandSender sender, String[] args) throws CommandException {
        PlayerPartyStorage storage = Pixelmon.storageManager.getParty((EntityPlayerMP)sender);
        this.sendMessage(sender, "" + storage.get(0).getIVs().get(StatsType.HP), new Object[0]);
        PokemonSpec spec = new PokemonSpec("pikachu", "lvl:50", "ivhp:31");
        Gson gson = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(SpecValue.class, (Object)new SpecValueTypeAdapter()).create();
        String json = gson.toJson((Object)spec);
        System.out.println(json);
        spec = (PokemonSpec)gson.fromJson(json, PokemonSpec.class);
    }

    public void hween(ICommandSender sender, String[] args) throws CommandException {
        boolean enable = args.length == 1 && args[0].equalsIgnoreCase("true");
        PlayerPartyStorage storage = Pixelmon.storageManager.getParty(DebugCommand.requireEntityPlayer(sender));
        if (enable) {
            storage.setHweenRobe(EnumFeatureState.Active);
            this.sendMessage(sender, "Active", new Object[0]);
        } else {
            storage.setHweenRobe(EnumFeatureState.Available);
            this.sendMessage(sender, "Available", new Object[0]);
        }
    }

    public void moveFlags(ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 1) {
            Predicate<AttackBase> predicate;
            if (args[0].equalsIgnoreCase("authentic")) {
                predicate = att -> att != null && att.getFlags().authentic;
            } else if (args[0].equalsIgnoreCase("sound")) {
                predicate = att -> att != null && att.getFlags().sound;
            } else {
                this.sendMessage(sender, "flag must be one of: authentic, sound", new Object[0]);
                return;
            }
            List moves = AttackBase.ATTACKS.stream().filter(predicate).map(AttackBase::getAttackName).collect(Collectors.toList());
            this.sendMessage(sender, "Moves with " + args[0] + ": " + StringUtils.join(moves, (String)", "), new Object[0]);
        } else {
            this.sendMessage(sender, "/pixeldebug moveflags <flag>", new Object[0]);
        }
    }

    public void fov(ICommandSender sender, String[] args) throws CommandException {
        Minecraft.func_71410_x().field_71474_y.field_74334_X = Integer.parseInt(args[1]);
    }

    public void render(ICommandSender sender, String[] args) throws CommandException {
        Minecraft.func_71410_x().field_71474_y.field_151451_c = 1000;
    }

    public void reloadModels(ICommandSender sender, String[] args) throws CommandException {
        try {
            Method m = PixelmonModelRegistry.class.getDeclaredMethod("init", new Class[0]);
            m.setAccessible(true);
            m.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
        GenericSmdModel.loadedModels.forEach(GenericSmdModel::reloadModel);
    }

    public void itemSprite(ICommandSender sender, String[] args) throws CommandException {
        ItemStack stack = new ItemStack(PixelmonItems.itemPixelmonSprite);
        NBTTagCompound tagCompound = new NBTTagCompound();
        tagCompound.func_74778_a("SpriteName", args[0]);
        stack.func_77982_d(tagCompound);
        ((EntityPlayerMP)sender).field_71071_by.func_70441_a(stack);
    }

    public void collection(ICommandSender sender, String[] args) throws CommandException {
        EntityPlayerMP player = (EntityPlayerMP)sender;
        int n = Integer.parseInt(args[0]);
        int radius = Integer.parseInt(args[1]);
        long tic = System.currentTimeMillis();
        for (int i = 0; i < n; ++i) {
            new BlockCollection((Entity)player, player.field_70170_p, (int)player.field_70165_t - radius, (int)player.field_70165_t + radius, (int)player.field_70163_u - radius, (int)player.field_70163_u + radius, (int)player.field_70161_v - radius, (int)player.field_70161_v + radius);
        }
        long toc = System.currentTimeMillis();
        this.sendMessage(sender, "Time to process " + n + " collections of diameter " + radius + " (" + n * 8 * radius * radius * radius + " blocks): " + (toc - tic) + " milliseconds.", new Object[0]);
    }

    public void modelScale(ICommandSender sender, String[] args) throws CommandException {
        block7: {
            if (args.length == 2) {
                try {
                    String name = args[0];
                    int form = -1;
                    if (args[0].contains(":")) {
                        name = args[0].split(":")[0];
                        form = DebugCommand.func_175755_a((String)args[0].split(":")[1]);
                    }
                    EnumSpecies species = EnumSpecies.getFromNameAnyCase(name);
                    double scale = DebugCommand.func_175765_c((String)args[1]);
                    PixelmonModelBase model = (PixelmonModelBase)PixelmonModelRegistry.getModel(species, species.getFormEnum(form));
                    if (model instanceof PixelmonModelSmd) {
                        ValveStudioModel valve = ((PixelmonModelSmd)model).theModel;
                        Field field = ValveStudioModel.class.getDeclaredField("scale");
                        field.setAccessible(true);
                        field.setFloat(valve, (float)scale);
                        sender.func_145747_a((ITextComponent)new TextComponentString("scale changed. This does not effect pokemon already spawned in the world."));
                        break block7;
                    }
                    sender.func_145747_a((ITextComponent)new TextComponentString("That model is not smd!"));
                }
                catch (IllegalArgumentException e) {
                    sender.func_145747_a((ITextComponent)new TextComponentString("No model by that name found!"));
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    e.printStackTrace();
                }
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentString("Usage: /pixeldebug model-scale <pokemon:form> <scale>"));
            }
        }
    }

    public void ridingOffset(ICommandSender sender, String[] args) throws CommandException {
        if (args.length >= 1) {
            String name = args[0];
            int form = -1;
            if (args[0].contains(":")) {
                name = args[0].split(":")[0];
                form = DebugCommand.func_175755_a((String)args[0].split(":")[1]);
            }
            EnumSpecies species = DebugCommand.require(EnumSpecies.getFromNameAnyCase(name), "Could not find a species by that name!", new Object[0]);
            RidingOffsets offsets = species.getBaseStats((IEnumForm)species.getFormEnum((int)form)).ridingOffsets;
            if (args.length == 1) {
                if (offsets != null) {
                    sender.func_145747_a((ITextComponent)new TextComponentString("Standing: " + offsets.standing.toString()));
                    sender.func_145747_a((ITextComponent)new TextComponentString("Moving: " + offsets.moving.toString()));
                } else {
                    sender.func_145747_a((ITextComponent)new TextComponentString("This pokemon does not have offsets."));
                }
            } else if (args.length == 4) {
                boolean standing = args[1].equalsIgnoreCase("standing");
                EnumAxis axis = EnumAxis.valueOf(args[2].toUpperCase());
                float pos = (float)DebugCommand.func_175765_c((String)args[3]);
                if (offsets == null) {
                    species.getBaseStats((IEnumForm)species.getFormEnum((int)form)).ridingOffsets = offsets = new RidingOffsets();
                }
                Vector3f vec = standing ? offsets.standing : offsets.moving;
                switch (axis) {
                    case X: {
                        vec.setX(pos);
                        break;
                    }
                    case Y: {
                        vec.setY(pos);
                        break;
                    }
                    case Z: {
                        vec.setZ(pos);
                        break;
                    }
                    default: {
                        DebugCommand.endCommand("Axis must be one of x, y, z", new Object[0]);
                        break;
                    }
                }
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentString("Usage: /pixeldebug ridingoffset <pokemon:form> <axis> <pos>"));
            }
        } else {
            sender.func_145747_a((ITextComponent)new TextComponentString("Usage: /pixeldebug ridingoffset <pokemon:form> <standing|moving> <axis> <pos>"));
        }
    }

    public void dialogue(ICommandSender sender, String[] args) throws CommandException {
        ArrayList<Dialogue> dialogues = new ArrayList<Dialogue>();
        dialogues.add(Dialogue.builder().setName("Gus").setText("Hello, friend").addChoice(Choice.builder().setText("Hello, Gus").setHandle(e -> e.reply(Dialogue.builder().setName("Gus").setText("Enjoy your day!").build())).build()).addChoice(Choice.builder().setText("You are everything wrong with the world.").setHandle(e -> e.reply(Dialogue.builder().setName("Gus").setText("Wow, ok then.").build())).build()).build());
        Dialogue.setPlayerDialogueData((EntityPlayerMP)sender, dialogues, true);
    }

    public void noticeoverlay(ICommandSender sender, String[] args) throws CommandException {
        if (!(sender instanceof EntityPlayerMP)) {
            throw new CommandException("pls be in game thanks bye.", new Object[0]);
        }
        EntityPlayerMP player = (EntityPlayerMP)sender;
        NoticeOverlay.Builder builder = NoticeOverlay.builder().setLayout(EnumOverlayLayout.LEFT_AND_RIGHT).setLines("Debug");
        if (args.length >= 1) {
            switch (args[0].toLowerCase()) {
                case "pokemonsprite": {
                    if (args.length >= 2) {
                        builder.setPokemonSprite(new PokemonSpec((String[])ArrayUtils.subarray((Object[])args, (int)1, (int)args.length)));
                        break;
                    }
                    builder.setPokemonSprite(new PokemonSpec("pikachu", "s"));
                    break;
                }
                case "pokemon3d": {
                    if (args.length >= 2) {
                        builder.setPokemon3D(new PokemonSpec((String[])ArrayUtils.subarray((Object[])args, (int)1, (int)args.length)));
                        break;
                    }
                    builder.setPokemon3D(new PokemonSpec("pikachu", "s"));
                    break;
                }
                case "itemstack": {
                    builder.setItemStack(player.func_184614_ca());
                    break;
                }
                default: {
                    throw new CommandException("invalid argument: " + args[0].toLowerCase(), new Object[0]);
                }
            }
        }
        builder.sendTo(player);
    }

    public void spawnwiki(ICommandSender sender, String[] args) throws CommandException {
        Function<String, String> raiseFirstCap = s -> s.toUpperCase().charAt(0) + s.substring(1).toLowerCase();
        BiFunction<ArrayList, Boolean, String> listToString = (list, cap) -> {
            if (list.isEmpty()) {
                return "";
            }
            String str = cap != false ? (String)raiseFirstCap.apply(list.get(0).toString()) : list.get(0).toString();
            for (int i = 1; i < list.size(); ++i) {
                str = str + ", " + (cap != false ? (String)raiseFirstCap.apply(list.get(i).toString()) : list.get(i).toString());
            }
            return str + "\n";
        };
        File file = new File("wikidata.txt");
        try {
            file.createNewFile();
            PrintWriter pw = new PrintWriter(file);
            for (EnumSpecies species : EnumSpecies.values()) {
                SpawnSet set = (SpawnSet)SetLoader.getSet(species.name);
                if (set == null) {
                    System.out.println("Empty: " + species.name);
                    continue;
                }
                String wikiBit = "|'''#" + species.getNationalPokedexNumber() + "'''\n";
                wikiBit = wikiBit + "|" + species.name + "\n";
                ArrayList<LocationType> locations = new ArrayList<LocationType>();
                ArrayList<String> biomes = new ArrayList<String>();
                ArrayList<WorldTime> times = new ArrayList<WorldTime>();
                ArrayList<WeatherType> weathers = new ArrayList<WeatherType>();
                for (SpawnInfo info : set.spawnInfos) {
                    for (LocationType location : info.locationTypes) {
                        if (locations.contains(location)) continue;
                        locations.add(location);
                    }
                    for (Biome biome : info.condition.biomes) {
                        biomes.add(biome.field_76791_y);
                    }
                    for (WorldTime time : info.condition.times) {
                        if (times.contains((Object)time)) continue;
                        times.add(time);
                    }
                    for (WeatherType weather : info.condition.weathers) {
                        if (weathers.contains((Object)weather)) continue;
                        weathers.add(weather);
                    }
                }
                String locString = listToString.apply(locations, true);
                if (locString.equals("")) continue;
                wikiBit = wikiBit + "|" + locString;
                String biomeString = listToString.apply(biomes, false);
                if (biomeString.equals("")) continue;
                wikiBit = wikiBit + "|" + biomeString;
                String timeString = listToString.apply(times, true);
                if (timeString.equals("")) continue;
                wikiBit = wikiBit + "|" + timeString;
                String weatherString = listToString.apply(weathers, true);
                if (weatherString.equals("")) continue;
                wikiBit = wikiBit + "|" + weatherString;
                wikiBit = wikiBit + "|-\n";
                pw.write(wikiBit);
            }
            pw.flush();
            pw.close();
            System.out.println("Done");
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    @Override
    public String func_71518_a(ICommandSender sender) {
        return "/pixeldebug [lang/camera/fov/reloadmodels/itemsprite/render/collection]";
    }

    @Override
    public final void execute(ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 0) {
            if (this.subCommands.containsKey("")) {
                this.subCommands.get("").execute(sender, args);
            } else {
                this.sendUsage(sender);
            }
        } else if (this.subCommands.containsKey(args[0].toLowerCase())) {
            this.subCommands.get(args[0]).execute(sender, DebugCommand.popFirst(args));
        } else {
            this.sendUsage(sender);
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos pos) {
        if (args.length == 1) {
            return DebugCommand.tabComplete(args, this.subCommands.keySet());
        }
        if (args.length > 1 && this.subCompletions.containsKey(args[0])) {
            return this.subCompletions.get(args[0]).completion(sender, DebugCommand.popFirst(args), pos);
        }
        return Collections.emptyList();
    }

    public void sendUsage(ICommandSender sender) {
        sender.func_145747_a((ITextComponent)new TextComponentTranslation("Usage: /" + this.name + " <" + DebugCommand.arrayToString(0, this.subCommands.keySet().toArray(new String[0]), "|") + ">", new Object[0]));
    }

    protected void registerSubCommand(String name, Execute command) {
        this.subCommands.put(name.toLowerCase(), command);
    }

    protected void registerSubCommand(String name, Execute command, String ... aliases) {
        this.subCommands.put(name.toLowerCase(), command);
        for (String str : aliases) {
            this.subCommands.put(str.toLowerCase(), command);
        }
    }

    protected void registerSubCompletion(String name, TabCompletion completion) {
        this.subCompletions.put(name.toLowerCase(), completion);
    }

    public static void recursiveJsonSearch(String dir, ArrayList<File> jsons) {
        File file = new File(dir);
        for (String name : file.list()) {
            File subFile = new File(dir + "/" + name);
            if (subFile.isFile() && name.endsWith(".json")) {
                jsons.add(subFile);
                continue;
            }
            if (!subFile.isDirectory()) continue;
            DebugCommand.recursiveJsonSearch(dir + "/" + name, jsons);
        }
    }

    private static void checkMissingPokemonLangEntries() {
        for (EnumSpecies species : EnumSpecies.values()) {
            String langEntryName = "pixelmon." + species.name.toLowerCase() + ".name";
            if (!I18n.func_74838_a((String)langEntryName).equals(langEntryName)) continue;
            System.out.println("Pokemon " + species.name + " Doesn't have a lang entry " + langEntryName);
        }
    }

    private static void checkMissingItemLangEntries() {
    }

    private static void checkMissingBlockLangEntries() {
    }

    public static List<String> tabCompleteUsernames(ICommandSender sender, String[] args, BlockPos pos) {
        return DebugCommand.tabCompleteUsernames(args);
    }

    private static String[] popFirst(String[] array) {
        String[] pop = new String[array.length - 1];
        System.arraycopy(array, 1, pop, 0, pop.length);
        return pop;
    }

    private static String arrayToString(int index, String[] args, String intersect) {
        StringBuilder builder = new StringBuilder();
        if (args.length - index > 0) {
            builder.append(args[index++]);
        }
        for (int i = index; i < args.length; ++i) {
            builder.append(intersect).append(args[i]);
        }
        return builder.toString().trim();
    }

    protected static interface TabCompletion {
        public List<String> completion(ICommandSender var1, String[] var2, @Nullable BlockPos var3);
    }

    protected static interface Execute {
        public void execute(ICommandSender var1, String[] var2) throws CommandException;
    }
}

