/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.vendingMachine;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.comm.ISyncHandler;
import com.pixelmonmod.pixelmon.api.economy.IPixelmonBankAccount;
import com.pixelmonmod.pixelmon.blocks.machines.BlockVendingMachine;
import com.pixelmonmod.pixelmon.config.PixelmonBlocks;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ShopItemWithVariation;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class VendingMachinePacket
implements IMessage {
    String itemID;
    int amount;
    BlockPos pos;

    public VendingMachinePacket() {
    }

    public VendingMachinePacket(BlockPos pos, String itemName, int amount) {
        this.pos = pos;
        this.itemID = itemName;
        this.amount = amount;
    }

    public void fromBytes(ByteBuf buf) {
        int x = buf.readInt();
        int y = buf.readInt();
        int z = buf.readInt();
        this.pos = new BlockPos(x, y, z);
        this.itemID = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.amount = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.itemID);
        buf.writeInt(this.amount);
    }

    public static class Handler
    implements ISyncHandler<VendingMachinePacket> {
        @Override
        public void onSyncMessage(VendingMachinePacket message, MessageContext ctx) {
            EntityPlayerMP p = ctx.getServerHandler().field_147369_b;
            BlockVendingMachine vendingMachine = (BlockVendingMachine)p.field_70170_p.func_180495_p(message.pos).func_177230_c();
            if (vendingMachine == null || message.amount <= 0 || message.amount > 64) {
                return;
            }
            IPixelmonBankAccount account = Pixelmon.moneyManager.getBankAccount(p).orElse(null);
            if (account != null) {
                ArrayList<ShopItemWithVariation> itemList = ((BlockVendingMachine)PixelmonBlocks.blueVendingMachineBlock).getShop().getItems();
                for (ShopItemWithVariation s : itemList) {
                    if (!s.getBaseShopItem().id.equals(message.itemID) || account.getMoney() < s.getBuyCost() * message.amount) continue;
                    ItemStack item = s.getItem();
                    ItemStack buyStack = item.func_77946_l();
                    int initialAmount = message.amount;
                    buyStack.func_190920_e(message.amount);
                    if (p.func_191521_c(buyStack)) {
                        account.changeMoney(-s.getBuyCost() * message.amount);
                        p.field_71069_bz.func_75142_b();
                        p.func_71053_j();
                        continue;
                    }
                    if (initialAmount <= buyStack.func_190916_E()) continue;
                    int actualAmount = initialAmount - buyStack.func_190916_E();
                    account.changeMoney(-s.getBuyCost() * actualAmount);
                    p.field_71069_bz.func_75142_b();
                    p.func_71053_j();
                }
            }
        }
    }
}

