/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.moveskills;

import com.pixelmonmod.pixelmon.api.moveskills.MoveSkill;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonSpec;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class RegisterMoveSkillPacket
implements IMessage {
    public MoveSkill moveSkill;
    public boolean unregister = false;

    public RegisterMoveSkillPacket() {
    }

    public RegisterMoveSkillPacket(MoveSkill moveSkill) {
        this.moveSkill = moveSkill;
    }

    public RegisterMoveSkillPacket(MoveSkill moveSkill, boolean unregister) {
        this.moveSkill = moveSkill;
        this.unregister = unregister;
    }

    public void fromBytes(ByteBuf buf) {
        this.moveSkill = new MoveSkill(new ResourceLocation(ByteBufUtils.readUTF8String((ByteBuf)buf)));
        this.unregister = buf.readBoolean();
        if (!this.unregister) {
            int i;
            this.moveSkill.setName(ByteBufUtils.readUTF8String((ByteBuf)buf));
            int descCount = buf.readByte();
            for (int i2 = 0; i2 < descCount; ++i2) {
                this.moveSkill.descriptions.add(ByteBufUtils.readUTF8String((ByteBuf)buf));
            }
            this.moveSkill.sprite = new ResourceLocation(ByteBufUtils.readUTF8String((ByteBuf)buf));
            this.moveSkill.anyMoves = new ArrayList();
            int n = buf.readUnsignedByte();
            for (i = 0; i < n; ++i) {
                this.moveSkill.anyMoves.add(Integer.valueOf(buf.readShort()));
            }
            this.moveSkill.combinationMoves = new ArrayList();
            n = buf.readUnsignedByte();
            for (i = 0; i < n; ++i) {
                this.moveSkill.combinationMoves.add(Integer.valueOf(buf.readShort()));
            }
            this.moveSkill.ableSpecs = new ArrayList();
            n = buf.readUnsignedByte();
            for (i = 0; i < n; ++i) {
                this.moveSkill.ableSpecs.add(new PokemonSpec(buf));
            }
            n = buf.readUnsignedByte();
            for (i = 0; i < n; ++i) {
                this.moveSkill.intrinsicSpecs.add(new PokemonSpec(buf));
            }
            n = buf.readByte();
            for (i = 0; i < n; ++i) {
                this.moveSkill.behaviours.put(MoveSkill.EnumTargetType.values()[buf.readByte()], (pix, o) -> 1);
            }
        }
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.moveSkill.skillId.toString());
        buf.writeBoolean(this.unregister);
        if (!this.unregister) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.moveSkill.name);
            buf.writeByte(this.moveSkill.descriptions.size());
            for (String description : this.moveSkill.descriptions) {
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)description);
            }
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.moveSkill.sprite.toString());
            buf.writeByte(this.moveSkill.anyMoves.size());
            for (Integer moveID : this.moveSkill.anyMoves) {
                buf.writeShort(moveID.intValue());
            }
            buf.writeByte(this.moveSkill.combinationMoves.size());
            for (Integer moveID : this.moveSkill.combinationMoves) {
                buf.writeShort(moveID.intValue());
            }
            buf.writeByte(this.moveSkill.ableSpecs.size());
            for (PokemonSpec spec : this.moveSkill.ableSpecs) {
                spec.toBytes(buf);
            }
            buf.writeByte(this.moveSkill.intrinsicSpecs.size());
            for (PokemonSpec spec : this.moveSkill.intrinsicSpecs) {
                spec.toBytes(buf);
            }
            buf.writeByte(this.moveSkill.behaviours.keySet().size());
            for (MoveSkill.EnumTargetType targetType : this.moveSkill.behaviours.keySet()) {
                buf.writeByte((int)((byte)targetType.ordinal()));
            }
        }
    }

    public static class Handler
    implements IMessageHandler<RegisterMoveSkillPacket, IMessage> {
        public IMessage onMessage(RegisterMoveSkillPacket message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                ClientProxy.moveSkills.removeIf(moveSkill -> moveSkill.skillId.equals((Object)message.moveSkill.skillId));
                if (!message.unregister) {
                    ClientProxy.moveSkills.add(message.moveSkill);
                }
            });
            return null;
        }
    }
}

