/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.customOverlays;

import com.pixelmonmod.pixelmon.client.gui.custom.overlays.CustomScoreboardOverlay;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class CustomScoreboardUpdatePacket
implements IMessage {
    private String title;
    private Collection<String> lines;
    private Collection<String> scores;

    public CustomScoreboardUpdatePacket() {
    }

    public CustomScoreboardUpdatePacket(String title, Collection<String> lines, Collection<String> scores) {
        this.title = title;
        this.lines = lines;
        this.scores = scores;
    }

    public void fromBytes(ByteBuf buf) {
        this.title = ByteBufUtils.readUTF8String((ByteBuf)buf);
        int lineAmount = buf.readByte();
        this.lines = new ArrayList<String>(lineAmount);
        for (int i = 0; i < lineAmount; ++i) {
            this.lines.add(ByteBufUtils.readUTF8String((ByteBuf)buf));
        }
        int scoreAmount = buf.readShort();
        if (scoreAmount != 254) {
            this.scores = new ArrayList<String>(scoreAmount);
            for (int i = 0; i < scoreAmount; ++i) {
                this.scores.add(ByteBufUtils.readUTF8String((ByteBuf)buf));
            }
        }
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.title);
        buf.writeByte(this.lines.size());
        for (String line : this.lines) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)line);
        }
        if (this.scores != null) {
            buf.writeShort(this.scores.size());
            for (String score : this.scores) {
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)score);
            }
        } else {
            buf.writeShort(254);
        }
    }

    public static class Handler
    implements IMessageHandler<CustomScoreboardUpdatePacket, IMessage> {
        public IMessage onMessage(CustomScoreboardUpdatePacket message, MessageContext ctx) {
            CustomScoreboardOverlay.resetBoard();
            CustomScoreboardOverlay.populate(null, message.title, message.lines, message.scores);
            return null;
        }
    }
}

