/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.clientStorage;

import com.pixelmonmod.pixelmon.api.comm.ISyncHandler;
import com.pixelmonmod.pixelmon.client.storage.ClientStorageManager;
import com.pixelmonmod.pixelmon.enums.EnumMegaItem;
import com.pixelmonmod.pixelmon.enums.EnumTrainerCardColor;
import com.pixelmonmod.pixelmon.storage.ClientData;
import io.netty.buffer.ByteBuf;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class UpdateClientPlayerData
implements IMessage {
    private ClientDataType type;
    private int playerMoney;
    private EnumMegaItem megaItem;
    private boolean giveChoice;
    private EnumTrainerCardColor color;
    private ItemStack lureStack;

    public UpdateClientPlayerData() {
    }

    public UpdateClientPlayerData(int playerMoney) {
        this.playerMoney = playerMoney;
        this.type = ClientDataType.Currency;
    }

    public UpdateClientPlayerData(EnumMegaItem megaItem, boolean openMegaItemGui) {
        this.megaItem = megaItem;
        this.type = ClientDataType.MegaItem;
        this.giveChoice = openMegaItemGui;
    }

    public UpdateClientPlayerData(EnumTrainerCardColor color) {
        this.type = ClientDataType.TrainerCardColor;
        this.color = color;
    }

    public UpdateClientPlayerData(ItemStack lureStack) {
        this.type = ClientDataType.Lure;
        this.lureStack = lureStack;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.type.ordinal());
        switch (this.type) {
            case Currency: {
                buf.writeInt(this.playerMoney);
                break;
            }
            case MegaItem: {
                buf.writeInt(this.megaItem.ordinal());
                buf.writeBoolean(this.giveChoice);
                break;
            }
            case TrainerCardColor: {
                buf.writeInt(this.color.ordinal());
                break;
            }
            case Lure: {
                if (this.lureStack == null || this.lureStack.func_190926_b()) {
                    buf.writeBoolean(false);
                    break;
                }
                buf.writeBoolean(true);
                ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.lureStack);
            }
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.type = ClientDataType.values()[buf.readInt()];
        switch (this.type) {
            case Currency: {
                this.playerMoney = buf.readInt();
                break;
            }
            case MegaItem: {
                this.megaItem = EnumMegaItem.values()[buf.readInt()];
                this.giveChoice = buf.readBoolean();
                break;
            }
            case TrainerCardColor: {
                this.color = EnumTrainerCardColor.values()[buf.readInt()];
                break;
            }
            case Lure: {
                this.lureStack = buf.readBoolean() ? ByteBufUtils.readItemStack((ByteBuf)buf) : ItemStack.field_190927_a;
            }
        }
    }

    public static class Handler
    implements ISyncHandler<UpdateClientPlayerData> {
        @Override
        public void onSyncMessage(UpdateClientPlayerData message, MessageContext ctx) {
            switch (message.type) {
                case Currency: {
                    ClientData.playerMoney = message.playerMoney;
                    break;
                }
                case MegaItem: {
                    ClientData.openMegaItemGui = message.giveChoice;
                    break;
                }
                case TrainerCardColor: {
                    ClientData.color = message.color;
                    break;
                }
                case Lure: {
                    ClientStorageManager.party.setLureStack(message.lureStack);
                }
            }
        }
    }

    public static enum ClientDataType {
        Currency,
        MegaItem,
        TrainerCardColor,
        Lure;

    }
}

