/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.render.tileEntities;

import com.pixelmonmod.pixelmon.api.pokemon.PokemonBase;
import com.pixelmonmod.pixelmon.blocks.MultiBlock;
import com.pixelmonmod.pixelmon.blocks.machines.BlockFossilMachine;
import com.pixelmonmod.pixelmon.blocks.tileEntities.TileEntityFossilMachine;
import com.pixelmonmod.pixelmon.client.models.blocks.GenericSmdModel;
import com.pixelmonmod.pixelmon.client.models.pokeballs.ModelPokeballs;
import com.pixelmonmod.pixelmon.client.render.BlockModelHolder;
import com.pixelmonmod.pixelmon.client.render.tileEntities.SharedModels;
import com.pixelmonmod.pixelmon.client.render.tileEntities.TileEntityRenderer;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityStatue;
import com.pixelmonmod.pixelmon.enums.EnumGrowth;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import com.pixelmonmod.pixelmon.enums.EnumStatueTextureType;
import com.pixelmonmod.pixelmon.enums.items.EnumFossils;
import com.pixelmonmod.pixelmon.enums.items.EnumPokeballs;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class RenderTileFossilMachine
extends TileEntityRenderer<TileEntityFossilMachine> {
    private static final ResourceLocation MACHINE_TEXTURE = new ResourceLocation("pixelmon", "textures/blocks/Fossil_Extractor.png");
    private static final BlockModelHolder<GenericSmdModel> machineBase = new BlockModelHolder("blocks/fossil_machine/fossil_extractor.pqc");
    private static final GenericSmdModel machineGlass = new GenericSmdModel("models/blocks/fossil_machine", "fossil_extractor_glass.pqc");

    public RenderTileFossilMachine() {
        RenderTileFossilMachine.machineGlass.modelRenderer.setTransparent(0.5f);
        this.correctionAngles = 180;
    }

    @Override
    public void renderTileEntity(TileEntityFossilMachine machine, IBlockState state, double x, double y, double z, float partialTicks, int destroyStage) {
        this.func_147499_a(MACHINE_TEXTURE);
        if (machine.renderPass == 1) {
            machineGlass.renderModel(1.0f);
            return;
        }
        ((GenericSmdModel)((Object)machineBase.getModel())).renderModel(1.0f);
        GlStateManager.func_179101_C();
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        int rotate = this.getRotation(state);
        EnumFacing facing = EnumFacing.NORTH;
        if (state.func_177230_c() instanceof BlockFossilMachine) {
            facing = (EnumFacing)state.func_177229_b((IProperty)MultiBlock.FACING);
        }
        this.renderCompletionLevel(machine, machine.completionRate + "%", facing, rotate, x, y, z, false, -1);
        if (machine.staticFlicker && machine.completionRate == 100 && machine.pokeball == null) {
            this.renderCompletionLevel(machine, I18n.func_135052_a((String)"pixelmon.blocks.fossilmachine.pokeball", (Object[])new Object[0]), facing, rotate, x, y + (double)0.08f, z, true, -65536);
        } else if (machine.completionRate > 0 && machine.completionRate < 100) {
            this.renderCompletionLevel(machine, I18n.func_135052_a((String)"pixelmon.blocks.fossilmachine.working", (Object[])new Object[0]) + machine.dots, facing, rotate, x, y + (double)0.08f, z, true, -16711936);
        } else if (machine.staticFlicker && machine.completionRate == 0 && machine.currentFossil == null) {
            this.renderCompletionLevel(machine, I18n.func_135052_a((String)"pixelmon.blocks.fossilmachine.fossil", (Object[])new Object[0]), facing, rotate, x, y + (double)0.08f, z, true, -65536);
        } else if (machine.staticFlicker && machine.completionRate == 100 && machine.pokeball != null) {
            this.renderCompletionLevel(machine, I18n.func_135052_a((String)"pixelmon.blocks.fossilmachine.retrieve", (Object[])new Object[0]), facing, rotate, x, y + (double)0.08f, z, true, -16711936);
        }
        this.renderBarLevel(machine, facing, rotate, x, y, z);
        if (machine.currentFossil != null) {
            this.renderFossil(machine.currentFossil.getFossil(), machine, rotate, x, y, z, facing);
        }
        if (machine.pokeball != null) {
            this.renderPokeball(machine.pokeball, machine, rotate, x, y, z, facing);
        }
        if (!(machine.statue != null && machine.statue.func_70005_c_().equalsIgnoreCase(machine.currentPokemon) || machine.currentPokemon.equals("") || !EnumSpecies.hasPokemon(machine.currentPokemon))) {
            machine.statue = new EntityStatue(this.func_178459_a());
            machine.statue.setPokemon(new PokemonBase(EnumSpecies.get(machine.currentPokemon)));
            machine.statue.setGrowth(EnumGrowth.Small);
            if (machine.isShiny) {
                machine.statue.setTextureType(EnumStatueTextureType.Shiny);
            }
        }
        if (machine.statue != null) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)((float)x + 0.5f), (float)((float)y + 0.9f), (float)((float)z + 0.5f));
            GlStateManager.func_179114_b((float)rotate, (float)0.0f, (float)1.0f, (float)0.0f);
            float scale = machine.currentPokemon.equals("Aerodactyl") ? Math.max(machine.pokemonProgress / 1000.0f / 4.0f - 0.55f, 0.0f) : Math.max(machine.pokemonProgress / 1000.0f / 4.0f - 0.15f, 0.0f);
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
            machine.statue.func_70012_b(x, y, z, 0.0f, 0.0f);
            Minecraft.func_71410_x().func_175598_ae().func_188391_a((Entity)machine.statue, 0.0, 0.0, 0.0, 0.0f, partialTicks, false);
            GlStateManager.func_179121_F();
        }
    }

    @Override
    protected int getRotation(IBlockState state) {
        if (state.func_177230_c() instanceof BlockFossilMachine) {
            EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)MultiBlock.FACING);
            if (facing == EnumFacing.WEST) {
                return 90;
            }
            if (facing == EnumFacing.SOUTH) {
                return 180;
            }
            if (facing == EnumFacing.EAST) {
                return 270;
            }
            return 0;
        }
        return 0;
    }

    private void renderBarLevel(TileEntityFossilMachine tile, EnumFacing facing, int rotate, double x1, double y1, double z1) {
        GlStateManager.func_179094_E();
        float f2 = 1.5f;
        float f3 = 0.00666667f * f2;
        float x = (float)x1;
        float y = (float)y1 + 0.32f;
        float z = (float)z1;
        if (facing == EnumFacing.NORTH) {
            GlStateManager.func_179109_b((float)(x + 0.5f), (float)y, (float)(z + 0.97f));
        } else if (facing == EnumFacing.WEST) {
            GlStateManager.func_179109_b((float)(x + 0.97f), (float)y, (float)(z + 0.5f));
        } else if (facing == EnumFacing.SOUTH) {
            GlStateManager.func_179109_b((float)(x + 0.5f), (float)y, (float)(z + 0.03f));
        } else {
            GlStateManager.func_179109_b((float)(x + 0.03f), (float)y, (float)(z + 0.5f));
        }
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(rotate + 180), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)(-f3), (float)(-f3), (float)f3);
        GlStateManager.func_179140_f();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        int byte0 = -20;
        GlStateManager.func_179090_x();
        float f8 = tile.completionRate / 2;
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        buffer.func_181662_b((double)(-25.0f + f8), (double)(-7 + byte0), 0.0).func_181666_a(0.0039f, 0.03137f, 0.4196f, 1.0f).func_181675_d();
        buffer.func_181662_b((double)(-25.0f + f8), (double)(-6 + byte0), 0.0).func_181666_a(0.0039f, 0.03137f, 0.4196f, 1.0f).func_181675_d();
        buffer.func_181662_b(25.0, (double)(-6 + byte0), 0.0).func_181666_a(0.0039f, 0.03137f, 0.4196f, 1.0f).func_181675_d();
        buffer.func_181662_b(25.0, (double)(-7 + byte0), 0.0).func_181666_a(0.0039f, 0.03137f, 0.4196f, 1.0f).func_181675_d();
        buffer.func_181662_b(-25.0, (double)(-7 + byte0), 0.0).func_181666_a(0.0f, 0.8901f, 0.8901f, 1.0f).func_181675_d();
        buffer.func_181662_b(-25.0, (double)(-6 + byte0), 0.0).func_181666_a(0.0f, 0.8901f, 0.8901f, 1.0f).func_181675_d();
        buffer.func_181662_b((double)(f8 - 25.0f), (double)(-6 + byte0), 0.0).func_181666_a(0.0f, 0.8901f, 0.8901f, 1.0f).func_181675_d();
        buffer.func_181662_b((double)(f8 - 25.0f), (double)(-7 + byte0), 0.0).func_181666_a(0.0f, 0.8901f, 0.8901f, 1.0f).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179145_e();
        GlStateManager.func_179084_k();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    private void renderCompletionLevel(TileEntityFossilMachine tile, String text, EnumFacing facing, int rotation, double x1, double y1, double z1, boolean par10, int color) {
        FontRenderer fontRenderer = this.func_147498_b();
        GlStateManager.func_179094_E();
        float var13 = 1.5f;
        float var14 = 0.011666667f * var13;
        float x = (float)x1;
        float y = (float)y1 + 0.75f;
        float z = (float)z1;
        if (facing == EnumFacing.NORTH) {
            GlStateManager.func_179109_b((float)(x + 0.5f), (float)y, (float)(z + 0.97f));
        } else if (facing == EnumFacing.WEST) {
            GlStateManager.func_179109_b((float)(x + 0.97f), (float)y, (float)(z + 0.5f));
        } else if (facing == EnumFacing.SOUTH) {
            GlStateManager.func_179109_b((float)(x + 0.5f), (float)y, (float)(z + 0.03f));
        } else {
            GlStateManager.func_179109_b((float)(x + 0.03f), (float)y, (float)(z + 0.5f));
        }
        GlStateManager.func_179114_b((float)(rotation + 180), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        if (!par10) {
            GlStateManager.func_179152_a((float)(-var14), (float)(-var14), (float)var14);
        } else {
            GlStateManager.func_179152_a((float)(-var14 + 0.012f), (float)(-var14 + 0.012f), (float)(var14 + 0.012f));
        }
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        GlStateManager.func_179090_x();
        int stringWidth = fontRenderer.func_78256_a(text) / 2;
        GlStateManager.func_179098_w();
        fontRenderer.func_78276_b(text, -stringWidth, 0, color);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        buffer.func_181662_b((double)(-stringWidth - 1), -1.0, 0.0).func_181675_d();
        buffer.func_181662_b((double)(-stringWidth - 1), 8.0, 0.0).func_181675_d();
        buffer.func_181662_b((double)(stringWidth + 1), 8.0, 0.0).func_181675_d();
        buffer.func_181662_b((double)(stringWidth + 1), -1.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        fontRenderer.func_78276_b(text, -stringWidth, 0, color);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179145_e();
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }

    private void renderFossil(EnumFossils fossil, TileEntityFossilMachine machine, int rotate, double x, double y, double z, EnumFacing facing) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)x + 0.5f), (float)((float)y + 1.0f + machine.fossilJitter), (float)((float)z + 0.5f));
        GlStateManager.func_179152_a((float)(0.8f - machine.fossilProgress / 1000.0f / 2.0f), (float)(-0.8f + machine.fossilProgress / 1000.0f / 2.0f), (float)(-0.8f + machine.fossilProgress / 1000.0f / 2.0f));
        if (facing == EnumFacing.NORTH || facing == EnumFacing.SOUTH) {
            GlStateManager.func_179114_b((float)rotate, (float)0.0f, (float)1.0f, (float)0.0f);
        } else {
            GlStateManager.func_179114_b((float)((float)rotate + 180.0f), (float)0.0f, (float)0.5f, (float)0.0f);
        }
        this.func_147499_a(fossil.getTexture());
        ((BlockModelHolder)fossil.getModel()).render(1.0f);
        GlStateManager.func_179121_F();
    }

    private void renderPokeball(EnumPokeballs pokeBall, TileEntityFossilMachine machine, int rotate, double x, double y, double z, EnumFacing facing) {
        GlStateManager.func_179094_E();
        if (rotate == 270) {
            GlStateManager.func_179137_b((double)(x - 0.1), (double)(y + (double)0.42f), (double)(z + 0.86));
        } else if (rotate == 180) {
            GlStateManager.func_179137_b((double)(x + 0.14), (double)(y + (double)0.42f), (double)(z - 0.1));
        } else if (rotate == 90) {
            GlStateManager.func_179137_b((double)(x + 1.1), (double)(y + (double)0.42f), (double)(z + 0.14));
        } else {
            GlStateManager.func_179137_b((double)(x + 0.86), (double)(y + (double)0.42f), (double)(z + 1.1));
        }
        GlStateManager.func_179114_b((float)rotate, (float)0.0f, (float)1.0f, (float)0.0f);
        this.func_147499_a(pokeBall.getTextureLocation());
        BlockModelHolder<? extends ModelPokeballs> pokeball = SharedModels.getPokeballModel(pokeBall);
        ((ModelPokeballs)((Object)pokeball.getModel())).theModel.setAnimation("idle");
        ((ModelPokeballs)((Object)pokeball.getModel())).theModel.animate();
        pokeball.render(0.002f);
        GlStateManager.func_179121_F();
    }
}

