/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.render.tileEntities;

import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.blocks.BlockRotation;
import com.pixelmonmod.pixelmon.blocks.tileEntities.TileEntityTimespaceAltar;
import com.pixelmonmod.pixelmon.client.models.PixelmonModelRegistry;
import com.pixelmonmod.pixelmon.client.models.blocks.GenericSmdModel;
import com.pixelmonmod.pixelmon.client.particle.ParticleArcanery;
import com.pixelmonmod.pixelmon.client.particle.ParticleSystems;
import com.pixelmonmod.pixelmon.client.particle.particles.SmallRising;
import com.pixelmonmod.pixelmon.client.render.BlockModelHolder;
import com.pixelmonmod.pixelmon.client.render.tileEntities.TileEntityRenderer;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import com.pixelmonmod.pixelmon.enums.forms.EnumGiratina;
import com.pixelmonmod.pixelmon.enums.forms.EnumNoForm;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;

public class RenderTileEntityTimespaceShrine
extends TileEntityRenderer<TileEntityTimespaceAltar> {
    private static final BlockModelHolder<GenericSmdModel> main_shrine = new BlockModelHolder("blocks/shrines/timespace/timespacealtar.pqc");
    private static final BlockModelHolder<GenericSmdModel> arceus_ring = new BlockModelHolder("blocks/shrines/timespace/arceus_ring.pqc");
    private static final BlockModelHolder<GenericSmdModel> palkia_symbol = new BlockModelHolder("blocks/shrines/timespace/palkia_symbol.pqc");
    private static final BlockModelHolder<GenericSmdModel> dialga_symbol = new BlockModelHolder("blocks/shrines/timespace/dialga_symbol.pqc");
    private static final BlockModelHolder<GenericSmdModel> giratina_symbol = new BlockModelHolder("blocks/shrines/timespace/giratina_symbol.pqc");
    private static final ResourceLocation main_texture = new ResourceLocation("pixelmon", "textures/blocks/shrines/timespace/timespacealtar.png");
    private static final BlockModelHolder<GenericSmdModel> lustrous_orb = new BlockModelHolder("blocks/shrines/timespace/lustrous_orb.pqc");
    private static final ResourceLocation lustrous_orb_texture = new ResourceLocation("pixelmon", "textures/blocks/shrines/timespace/lustrous_orb.png");
    private static final BlockModelHolder<GenericSmdModel> adamant_orb = new BlockModelHolder("blocks/shrines/timespace/adamant_orb.pqc");
    private static final ResourceLocation adamant_orb_texture = new ResourceLocation("pixelmon", "textures/blocks/shrines/timespace/adamant_orb.png");
    private static final BlockModelHolder<GenericSmdModel> griseous_orb = new BlockModelHolder("blocks/shrines/timespace/griseous_orb.pqc");
    private static final ResourceLocation griseous_orb_texture = new ResourceLocation("pixelmon", "textures/blocks/shrines/timespace/griseous_orb.png");
    private static final ResourceLocation[] dialga_textures = new ResourceLocation[]{new ResourceLocation("pixelmon", "textures/pokemon/dialga.png"), new ResourceLocation("pixelmon", "textures/pokemon/pokemon-shiny/shinydialga.png")};
    private static final ResourceLocation[] palkia_textures = new ResourceLocation[]{new ResourceLocation("pixelmon", "textures/pokemon/palkia.png"), new ResourceLocation("pixelmon", "textures/pokemon/pokemon-shiny/shinypalkia.png")};
    private static final ResourceLocation[] giratina_textures = new ResourceLocation[]{new ResourceLocation("pixelmon", "textures/pokemon/giratina-origin.png"), new ResourceLocation("pixelmon", "textures/pokemon/pokemon-shiny/shinygiratina-origin.png")};
    private static final ResourceLocation[] arceus_textures = new ResourceLocation[]{new ResourceLocation("pixelmon", "textures/pokemon/arceus-normal.png"), new ResourceLocation("pixelmon", "textures/pokemon/pokemon-shiny/shinyarceus-normal.png")};
    private double theta = 0.0;
    private double theta2 = 0.0;
    private static final double threshold = 2.3561944901923447E9;

    public RenderTileEntityTimespaceShrine() {
        this.correctionAngles = 180;
    }

    @Override
    public void renderTileEntity(TileEntityTimespaceAltar shrineBlock, IBlockState state, double x, double y, double z, float partialTicks, int destroyStage) {
        double zOffset;
        double xOffset;
        GlStateManager.func_179094_E();
        switch (shrineBlock.orbIn) {
            case PALKIA: {
                this.func_147499_a(lustrous_orb_texture);
                GlStateManager.func_179137_b((double)0.0, (double)-1.535, (double)0.0);
                GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179139_a((double)0.3, (double)0.3, (double)0.3);
                lustrous_orb.render();
                break;
            }
            case DIALGA: {
                this.func_147499_a(adamant_orb_texture);
                GlStateManager.func_179137_b((double)0.0, (double)-1.535, (double)0.0);
                GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179139_a((double)0.3, (double)0.3, (double)0.3);
                adamant_orb.render();
                break;
            }
            case GIRATINA: {
                this.func_147499_a(griseous_orb_texture);
                GlStateManager.func_179137_b((double)0.0, (double)-1.16, (double)1.165);
                GlStateManager.func_179139_a((double)0.3, (double)0.3, (double)0.3);
                griseous_orb.render();
                break;
            }
        }
        GlStateManager.func_179121_F();
        this.func_147499_a(main_texture);
        float rotate = -90.0f;
        float scale = 0.3f;
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)rotate, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        main_shrine.render();
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)rotate, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        if (shrineBlock.chainIn) {
            GlStateManager.func_179131_c((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        }
        arceus_ring.render();
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)rotate, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        palkia_symbol.render();
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)rotate, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        dialga_symbol.render();
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)rotate, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        giratina_symbol.render();
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
        GlStateManager.func_179103_j((int)7425);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179094_E();
        BlockRotation rot = BlockRotation.getRotationFromMetadata(shrineBlock.func_145832_p());
        if (rot == BlockRotation.Normal) {
            xOffset = 0.5;
            zOffset = 5.5;
        } else if (rot == BlockRotation.Rotate180) {
            xOffset = 0.5;
            zOffset = -4.5;
        } else if (rot == BlockRotation.CW) {
            xOffset = -4.5;
            zOffset = 0.5;
        } else {
            xOffset = 5.5;
            zOffset = 0.5;
        }
        BlockPos center = new BlockPos((double)shrineBlock.func_174877_v().func_177958_n() + xOffset, (double)shrineBlock.func_174877_v().func_177956_o(), (double)shrineBlock.func_174877_v().func_177952_p() + zOffset);
        if (shrineBlock.timeSpent > 0) {
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            if (shrineBlock.flutePlayed) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            } else {
                GlStateManager.func_179131_c((float)1.0f, (float)((float)shrineBlock.timeSpent / 200.0f + 0.02f), (float)((float)shrineBlock.timeSpent / 200.0f + 0.02f), (float)1.0f);
            }
            GlStateManager.func_179109_b((float)0.0f, (float)((1.0f - (float)shrineBlock.timeSpent / 200.0f) * 5.0f), (float)0.0f);
            GlStateManager.func_179109_b((float)0.0f, (float)((float)(-shrineBlock.timeSpent) / 200.0f * 5.0f), (float)0.0f);
            if (shrineBlock.flutePlayed) {
                this.func_147499_a(arceus_textures[shrineBlock.summoningShiny ? 1 : 0]);
                GlStateManager.func_179137_b((double)0.0, (double)-3.5, (double)5.0);
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179152_a((float)0.35f, (float)0.35f, (float)0.35f);
                PixelmonModelRegistry.getModel(EnumSpecies.Arceus, EnumNoForm.NoForm).func_78088_a(null, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 1.0f);
            } else {
                switch (shrineBlock.orbIn) {
                    case PALKIA: {
                        this.func_147499_a(palkia_textures[shrineBlock.summoningShiny ? 1 : 0]);
                        GlStateManager.func_179137_b((double)0.0, (double)-3.5, (double)5.0);
                        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        GlStateManager.func_179152_a((float)0.35f, (float)0.35f, (float)0.35f);
                        PixelmonModelRegistry.getModel(EnumSpecies.Palkia, EnumNoForm.NoForm).func_78088_a(null, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 1.0f);
                        break;
                    }
                    case DIALGA: {
                        this.func_147499_a(dialga_textures[shrineBlock.summoningShiny ? 1 : 0]);
                        GlStateManager.func_179137_b((double)0.0, (double)-7.0, (double)5.0);
                        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
                        PixelmonModelRegistry.getModel(EnumSpecies.Dialga, EnumNoForm.NoForm).func_78088_a(null, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 1.0f);
                        break;
                    }
                    case GIRATINA: {
                        this.func_147499_a(giratina_textures[shrineBlock.summoningShiny ? 1 : 0]);
                        GlStateManager.func_179109_b((float)0.0f, (float)-35.0f, (float)5.0f);
                        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        GlStateManager.func_179152_a((float)1.0f, (float)1.0f, (float)1.0f);
                        PixelmonModelRegistry.getModel(EnumSpecies.Giratina, EnumGiratina.ORIGIN).func_78088_a(null, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 1.0f);
                        break;
                    }
                }
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179084_k();
            int totalPoints = (int)((float)shrineBlock.timeSpent / 20.0f);
            for (int i = 0; i < totalPoints; ++i) {
                double pX = (double)shrineBlock.func_174877_v().func_177958_n() + xOffset + (double)RandomHelper.getRandomNumberBetween(-4.0f, 4.0f);
                double pZ = (double)shrineBlock.func_174877_v().func_177952_p() + zOffset + (double)RandomHelper.getRandomNumberBetween(-4.0f, 4.0f);
                if (!(center.func_177954_c(pX, (double)shrineBlock.func_174877_v().func_177956_o(), pZ) < 16.0)) continue;
                Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new ParticleArcanery(this.func_178459_a(), pX, shrineBlock.func_174877_v().func_177956_o(), pZ, 0.0, 1.0, 0.0, new SmallRising(1.0f, shrineBlock.flutePlayed ? 1.0f : 0.0f, shrineBlock.flutePlayed ? 1.0f : 0.0f, 0.5f)));
            }
            ParticleSystems.get(1).execute(Minecraft.func_71410_x(), this.func_178459_a(), (double)shrineBlock.func_174877_v().func_177958_n() + xOffset, (double)shrineBlock.func_174877_v().func_177956_o() + 0.5, (double)shrineBlock.func_174877_v().func_177952_p() + zOffset, 0.0f, false, shrineBlock.flutePlayed ? 1.0 : 0.0);
        } else if (shrineBlock.chainIn) {
            int totalPoints = 16;
            for (int i = 1; i <= totalPoints; ++i) {
                double theta = Math.PI * 2 / (double)totalPoints;
                double angle = theta * (double)i + this.theta;
                this.theta += 7.5E-4;
                if (this.theta > Math.PI) {
                    this.theta -= Math.PI;
                }
                double radius = 4.0;
                double dx = radius * Math.sin(angle);
                double dz = radius * Math.cos(angle);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new ParticleArcanery(this.func_178459_a(), (double)shrineBlock.func_174877_v().func_177958_n() + xOffset + dx, (double)shrineBlock.func_174877_v().func_177956_o() + 0.5, (double)shrineBlock.func_174877_v().func_177952_p() + zOffset + dz, 0.0, 0.0, 0.0, new SmallRising(1.0f, 0.0f, 0.0f, 0.5f)));
            }
        }
        GlStateManager.func_179121_F();
    }
}

