/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.listener;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.pixelmonmod.pixelmon.Pixelmon;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.util.ResourceLocation;

public class WallpapersListener
implements IResourceManagerReloadListener {
    public static final String DEFAULT_WALLPAPER = "default";
    private static final ResourceLocation DEFAULT = new ResourceLocation("pixelmon", String.format("textures/gui/pc/wallpapers/%s.png", "default"));
    private static final String SEARCH_WALLPAPER = "search";
    private static final ResourceLocation SEARCH = new ResourceLocation("pixelmon", String.format("textures/gui/pc/wallpapers/%s.png", "search"));
    private static Map<String, ResourceLocation> wallpapersMap = new LinkedHashMap<String, ResourceLocation>();
    private static List<String> wallpaperNames = new ArrayList<String>();
    private static final Gson GSON = new Gson();

    public static List<String> getWallpapers() {
        return wallpaperNames;
    }

    public static boolean hasWallpaper(String name) {
        if (SEARCH_WALLPAPER.equals(name)) {
            return true;
        }
        return name != null && wallpaperNames.contains(name);
    }

    public static ResourceLocation getWallpaper(String name) {
        if (SEARCH_WALLPAPER.equals(name)) {
            return SEARCH;
        }
        ResourceLocation wallpaper = wallpapersMap.get(name);
        return wallpaper == null ? DEFAULT : wallpaper;
    }

    public void func_110549_a(IResourceManager manager) {
        wallpapersMap.clear();
        wallpapersMap.put(DEFAULT_WALLPAPER, DEFAULT);
        try {
            for (IResource resource : manager.func_135056_b(new ResourceLocation("pixelmon", "textures/gui/pc/wallpapers/wallpapers.json"))) {
                try {
                    String[] wallpapers;
                    for (String fullName : wallpapers = (String[])GSON.fromJson((Reader)new InputStreamReader(resource.func_110527_b()), String[].class)) {
                        String name = fullName.substring(0, fullName.lastIndexOf("."));
                        if (name.equals(DEFAULT_WALLPAPER) || name.equals(SEARCH_WALLPAPER)) continue;
                        wallpapersMap.put(name, new ResourceLocation("pixelmon", "textures/gui/pc/wallpapers/" + fullName));
                    }
                }
                catch (JsonParseException e) {
                    Pixelmon.LOGGER.error(String.format("There was a problem trying to read 'wallpapers.json' from the resource pack '%s'.", resource.func_177240_d()), (Throwable)e);
                }
            }
        }
        catch (IOException e) {
            Pixelmon.LOGGER.error("There was a problem trying to read 'wallpapers.json'.", (Throwable)e);
        }
        wallpaperNames = ImmutableList.copyOf(wallpapersMap.keySet());
    }
}

