/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.pokemoneditor;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.client.ServerStorageDisplay;
import com.pixelmonmod.pixelmon.client.gui.pokemoneditor.GuiIndividualEditorBase;
import com.pixelmonmod.pixelmon.client.gui.pokemoneditor.GuiPokemonEditorParty;
import com.pixelmonmod.pixelmon.comm.packetHandlers.pokemoneditor.ChangePokemon;
import com.pixelmonmod.pixelmon.comm.packetHandlers.pokemoneditor.DeletePokemon;
import com.pixelmonmod.pixelmon.comm.packetHandlers.pokemoneditor.UpdatePlayerPokemon;
import com.pixelmonmod.pixelmon.config.PixelmonItems;
import com.pixelmonmod.pixelmon.config.PixelmonItemsPokeballs;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.extraStats.LakeTrioStats;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.extraStats.MeltanStats;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.extraStats.MewStats;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import com.pixelmonmod.pixelmon.items.ItemPokeball;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiPokemonEditorIndividual
extends GuiIndividualEditorBase {
    private GuiTextField pokeBallText;
    private GuiTextField cloneText;
    private GuiTextField lakeText;
    private GuiTextField smeltText;
    private ItemStack pokeBall;

    GuiPokemonEditorIndividual(Pokemon p, String titleText) {
        super(p, titleText);
    }

    @Override
    public void func_73866_w_() {
        this.textFields.clear();
        this.cloneText = null;
        this.lakeText = null;
        this.smeltText = null;
        super.func_73866_w_();
        this.pokeBallText = new GuiTextField(16, this.field_146297_k.field_71466_p, this.field_146294_l / 2 - 120, this.field_146295_m / 2 + 72, 90, 17);
        this.pokeBall = new ItemStack((Item)this.p.getCaughtBall().getItem());
        this.pokeBallText.func_146180_a(this.pokeBall.func_82833_r());
        this.textFields.add(this.pokeBallText);
        int formOffset = 20;
        if (this.p.getSpecies() == EnumSpecies.Mew) {
            this.cloneText = this.createExtraTextField(17);
            this.cloneText.field_146210_g += formOffset;
            this.cloneText.func_146180_a(Integer.toString(((MewStats)this.p.getExtraStats()).numCloned));
            this.textFields.add(this.cloneText);
        } else if (this.p.getSpecies() == EnumSpecies.Azelf || this.p.getSpecies() == EnumSpecies.Mesprit || this.p.getSpecies() == EnumSpecies.Uxie) {
            this.lakeText = this.createExtraTextField(17);
            this.lakeText.field_146210_g += formOffset;
            this.lakeText.func_146180_a(Integer.toString(((LakeTrioStats)this.p.getExtraStats()).numEnchanted));
            this.textFields.add(this.lakeText);
        } else if (this.p.getSpecies() == EnumSpecies.Meltan) {
            this.smeltText = this.createExtraTextField(17);
            this.smeltText.field_146210_g += formOffset;
            this.smeltText.func_146180_a(Integer.toString(((MeltanStats)this.p.getExtraStats()).oresSmelted));
            this.textFields.add(this.lakeText);
        }
    }

    @Override
    protected void drawBackgroundUnderMenus(float f, int i, int j) {
        super.drawBackgroundUnderMenus(f, i, j);
        if (this.pokeBallText != null) {
            this.pokeBallText.func_146194_f();
            this.field_146297_k.field_71466_p.func_78276_b(I18n.func_74838_a((String)"gui.pokemoneditor.pokeball"), this.field_146294_l / 2 - 180, this.field_146295_m / 2 + 75, 0);
            this.field_146296_j.func_180450_b(this.pokeBall, this.field_146294_l / 2 - 28, this.field_146295_m / 2 + 72);
        }
        this.drawExtraText(this.cloneText, "gui.pokemoneditor.clones");
        this.drawExtraText(this.lakeText, "gui.pokemoneditor.lake_enchants");
        this.drawExtraText(this.smeltText, "gui.pokemoneditor.smelts");
    }

    @Override
    protected void func_73869_a(char key, int keyCode) throws IOException {
        super.func_73869_a(key, keyCode);
        if (this.pokeBallText != null) {
            this.pokeBallText.func_146201_a(key, keyCode);
            if (this.pokeBallText.func_146206_l()) {
                this.updatePokeBall();
            }
        }
        if (this.cloneText != null) {
            this.cloneText.func_146201_a(key, keyCode);
        }
        if (this.lakeText != null) {
            this.lakeText.func_146201_a(key, keyCode);
        }
        if (this.smeltText != null) {
            this.smeltText.func_146201_a(key, keyCode);
        }
    }

    private void updatePokeBall() {
        Item newItem = PixelmonItems.getItemFromName(this.pokeBallText.func_146179_b());
        if (newItem instanceof ItemPokeball) {
            this.pokeBall = new ItemStack(newItem);
        } else if (!"en_us".equals(Minecraft.func_71410_x().func_135016_M().func_135041_c().func_135034_a())) {
            for (Item item : PixelmonItemsPokeballs.getPokeballListWithMaster()) {
                if (item instanceof ItemPokeball && new ItemStack(item).func_82833_r().equalsIgnoreCase(this.pokeBallText.func_146179_b())) {
                    this.pokeBall = new ItemStack(item);
                    break;
                }
                this.pokeBall = new ItemStack(PixelmonItemsPokeballs.pokeBall);
            }
        } else {
            this.pokeBall = new ItemStack(PixelmonItemsPokeballs.pokeBall);
        }
        this.p.setCaughtBall(((ItemPokeball)this.pokeBall.func_77973_b()).type);
    }

    @Override
    protected void mouseClickedUnderMenus(int x, int y, int mouseButton) throws IOException {
        super.mouseClickedUnderMenus(x, y, mouseButton);
        for (GuiTextField textField : new GuiTextField[]{this.pokeBallText, this.cloneText, this.lakeText}) {
            if (textField == null) continue;
            textField.func_146192_a(x, y, mouseButton);
        }
    }

    @Override
    protected void changePokemon(EnumSpecies newPokemon) {
        Pixelmon.network.sendToServer((IMessage)new ChangePokemon(this.p.getUUID(), newPokemon));
    }

    @Override
    protected void deletePokemon() {
        Pixelmon.network.sendToServer((IMessage)new DeletePokemon(this.p.getUUID()));
        this.field_146297_k.func_147108_a((GuiScreen)new GuiPokemonEditorParty());
    }

    @Override
    protected void saveAndClose() {
        Pixelmon.network.sendToServer((IMessage)new UpdatePlayerPokemon(this.p));
        this.field_146297_k.func_147108_a((GuiScreen)new GuiPokemonEditorParty());
    }

    @Override
    public List<Pokemon> getPokemonList() {
        return ServerStorageDisplay.editedPokemon;
    }

    @Override
    protected boolean checkFields() {
        boolean valid = super.checkFields();
        if (this.cloneText != null) {
            try {
                int numClones = Integer.parseInt(this.cloneText.func_146179_b());
                if (numClones < 0) {
                    this.cloneText.func_146180_a("0");
                    valid = false;
                } else if (numClones > 3) {
                    this.cloneText.func_146180_a(Integer.toString(3));
                    valid = false;
                } else {
                    ((MewStats)this.p.getExtraStats()).numCloned = numClones;
                }
            }
            catch (NumberFormatException e) {
                this.cloneText.func_146180_a("");
                valid = false;
            }
        }
        if (this.lakeText != null) {
            try {
                int enchants = Integer.parseInt(this.lakeText.func_146179_b());
                if (enchants < 0) {
                    this.lakeText.func_146180_a("0");
                    valid = false;
                } else if (enchants > LakeTrioStats.MAX_ENCHANTED) {
                    this.lakeText.func_146180_a(Integer.toString(LakeTrioStats.MAX_ENCHANTED));
                    valid = false;
                } else {
                    ((LakeTrioStats)this.p.getExtraStats()).numEnchanted = enchants;
                }
            }
            catch (NumberFormatException e) {
                this.lakeText.func_146180_a("");
                valid = false;
            }
        }
        if (this.smeltText != null) {
            try {
                int smelts = Integer.parseInt(this.smeltText.func_146179_b());
                if (smelts < 0) {
                    this.smeltText.func_146180_a("0");
                    valid = false;
                } else {
                    ((MeltanStats)this.p.getExtraStats()).oresSmelted = smelts;
                }
            }
            catch (NumberFormatException e) {
                this.smeltText.func_146180_a("");
                valid = false;
            }
        }
        return valid;
    }
}

