/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.pokedex;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.client.gui.GuiHelper;
import com.pixelmonmod.pixelmon.client.gui.GuiResources;
import com.pixelmonmod.pixelmon.client.render.RenderPixelmon;
import com.pixelmonmod.pixelmon.client.storage.ClientStorageManager;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.EnumSpecialTexture;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Gender;
import com.pixelmonmod.pixelmon.enums.EnumGrowth;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import com.pixelmonmod.pixelmon.enums.EnumType;
import com.pixelmonmod.pixelmon.enums.forms.EnumNoForm;
import com.pixelmonmod.pixelmon.enums.forms.IEnumForm;
import com.pixelmonmod.pixelmon.pokedex.EnumPokedexRegisterStatus;
import com.pixelmonmod.pixelmon.pokedex.Pokedex;
import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.vecmath.Vector3d;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class GuiPokedex
extends GuiScreen {
    private int frame = 0;
    private EntityPixelmon reference;
    private int currentPokemon;
    private int currentRow = 0;
    private EntityPixelmon display;
    private List<Integer> pokemon = Lists.newArrayList();
    private int currentInfoRow = 0;
    private int currentPage = 0;
    private GuiTextField searchBar;
    private GuiButton up;
    private GuiButton down;

    public GuiPokedex(int pos) {
        this.currentPokemon = pos;
        Keyboard.enableRepeatEvents((boolean)true);
        if (ClientStorageManager.pokedex.get(this.currentPokemon) == EnumPokedexRegisterStatus.unknown) {
            this.currentPokemon = ClientStorageManager.pokedex.getSeenMap().entrySet().stream().filter(e -> e.getValue() != EnumPokedexRegisterStatus.unknown).map(Map.Entry::getKey).findFirst().orElse(1);
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int centerW = this.field_146294_l / 2;
        this.searchBar = new GuiTextField(0, this.field_146297_k.field_71466_p, centerW - 83, 139, 150, 10);
        this.searchBar.func_146185_a(false);
        this.up = this.func_189646_b(new GuiButton(1, centerW + 76, 152, 10, 25, ""));
        this.down = this.func_189646_b(new GuiButton(2, centerW + 76, 181, 10, 25, ""));
        this.pokemon = Pokedex.fullPokedex.values().stream().map(e -> e.natPokedexNum).collect(Collectors.toList());
        this.pokemon.sort(Comparator.naturalOrder());
        this.currentRow = this.pokemon.indexOf(this.currentPokemon) / 7;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.drawScreenBackground(mouseX, mouseY, partialTicks);
        if (this.frame >= 60) {
            if (this.display == null) {
                this.setupDisplayedPokemon();
            }
            this.drawBottomPage(mouseX, mouseY, partialTicks);
            if (this.currentPage == 0) {
                this.drawFirstPage(mouseX, mouseY, partialTicks);
            } else if (this.currentPage == 1) {
                this.drawSecondPage(mouseX, mouseY, partialTicks);
            }
        }
    }

    private void drawScreenBackground(int mouseX, int mouseY, float partialTicks) {
        int centerW = this.field_146294_l / 2;
        double thing = this.frame >= 60 ? 45.9 : (this.frame++ < 20 ? 0.0 : 0.18143666666666666 * Math.pow(this.frame - 20, 1.5));
        this.field_146297_k.field_71446_o.func_110577_a(GuiResources.pokedexBottom);
        GuiHelper.drawImageQuad(centerW - 120, 58.65 + thing, 240.0, 133.875f, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
        this.field_146297_k.field_71446_o.func_110577_a(this.currentPage == 0 ? GuiResources.pokedexTop : GuiResources.pokedexTop2);
        GuiHelper.drawImageQuad(centerW - 120, 58.65 - thing, 240.0, 121.125f, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
    }

    private void drawFirstPage(int mouseX, int mouseY, float partialTicks) {
        int centerX = this.field_146294_l / 2;
        this.field_146297_k.field_71466_p.func_78276_b(this.display.getLocalizedName() + " #" + Pokedex.fullPokedex.get(this.currentPokemon).getPokedexDisplayNumber(), centerX - 86, 25, 0xFFFFFF);
        for (int i = 0; i < this.display.getPokemonData().getBaseStats().getTypeList().size(); ++i) {
            EnumType type = this.display.getPokemonData().getBaseStats().getTypeList().get(i);
            this.field_146297_k.field_71446_o.func_110577_a(GuiResources.types);
            float x = type.textureX;
            float y = type.textureY;
            GuiHelper.drawImageQuad(centerX + 70 - 13 * i, 24.0, 10.0, 10.0f, x / 495.0f, y / 392.0f, (x + 98.0f) / 495.0f, (y + 98.0f) / 392.0f, this.field_73735_i);
        }
        GuiHelper.drawScaledString(ClientStorageManager.pokedex.getEntry((int)this.currentPokemon).heightM, centerX - 85, 40.0f, 0xFFFFFF, 10.0f);
        GuiHelper.drawScaledStringRightAligned(ClientStorageManager.pokedex.getEntry((int)this.currentPokemon).weightM, centerX - 26, 40.0f, 0xFFFFFF, false, 10.0f);
        GuiHelper.drawScaledCenteredString(I18n.func_135052_a((String)"gui.pokedex.description", (Object[])new Object[0]), centerX + 35, 40.0f, 0xFFFFFF, 14.0f);
        String s = ClientStorageManager.pokedex.get(this.currentPokemon) == EnumPokedexRegisterStatus.caught ? I18n.func_135052_a((String)("pixelmon." + EnumSpecies.getFromDex((int)this.currentPokemon).name.replaceAll(" ", "").toLowerCase() + ".description"), (Object[])new Object[0]) : "???";
        s = GuiHelper.splitStringToFit(s, 8, 97);
        for (int i = 0; i < s.split("\n").length; ++i) {
            String s1 = s.split("\n")[i];
            GuiHelper.drawScaledString(s1, centerX - 20, 55.0f + (float)this.field_146297_k.field_71466_p.field_78288_b * 0.5f * (float)i, 0xFFFFFF, 8.0f);
        }
        if (this.display.hasForms() && ClientStorageManager.pokedex.get(this.currentPokemon) == EnumPokedexRegisterStatus.caught) {
            int i;
            List forms = EnumSpecies.formList.get((Object)this.display.getSpecies());
            if (forms.isEmpty()) {
                forms.add(EnumNoForm.NoForm);
            }
            if ((i = forms.indexOf(this.display.getPokemonData().getFormEnum()) * 2 + (this.display.getPokemonData().isShiny() ? 1 : 0)) > 0) {
                this.field_146297_k.field_71446_o.func_110577_a(GuiResources.pokedexBack);
                GuiHelper.drawImageQuad(centerX - 88, 105.0, 15.0, 15.0f, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
            }
            GuiHelper.drawScaledCenteredString(this.display.getPokemonData().getFormEnum().getLocalizedName(), centerX - 58, 112.0f, 0xFFFFFF, 13.0f);
            if (i % 2 != 0) {
                this.field_146297_k.field_71446_o.func_110577_a(GuiResources.pokedexStar);
                GuiHelper.drawImageQuad((double)(centerX - 58) + (double)(this.field_146297_k.field_71466_p.func_78256_a(this.display.getPokemonData().getFormEnum().getLocalizedName()) * 13) / 32.0, 112.0, 3.5, 3.5f, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
            }
            if (i + 1 < forms.size() * 2) {
                this.field_146297_k.field_71446_o.func_110577_a(GuiResources.pokedexForward);
                GuiHelper.drawImageQuad(centerX - 40, 105.0, 15.0, 15.0f, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
            }
        }
        this.drawEntityToScreen(centerX - 58, 105, 50, this.display, mouseX, partialTicks);
    }

    private void drawSecondPage(int mouseX, int mouseY, float partialTicks) {
        int centerX = this.field_146294_l / 2;
        this.field_146297_k.field_71466_p.func_78276_b(this.display.getLocalizedName() + " #" + Pokedex.fullPokedex.get(this.currentPokemon).getPokedexDisplayNumber(), centerX - 86, 25, 0xFFFFFF);
        for (int i = 0; i < this.display.getPokemonData().getBaseStats().getTypeList().size(); ++i) {
            EnumType type = this.display.getPokemonData().getBaseStats().getTypeList().get(i);
            this.field_146297_k.field_71446_o.func_110577_a(GuiResources.types);
            float x = type.textureX;
            float y = type.textureY;
            GuiHelper.drawImageQuad(centerX + 70 - 13 * i, 24.0, 10.0, 10.0f, x / 495.0f, y / 392.0f, (x + 98.0f) / 495.0f, (y + 98.0f) / 392.0f, this.field_73735_i);
        }
        GuiHelper.drawScaledCenteredString(I18n.func_135052_a((String)"gui.pokedex.spawns", (Object[])new Object[0]), centerX, 40.0f, 0xFFFFFF, 14.0f);
        List<String> spawnInfo = this.getSpawnInfo();
        for (int i = this.currentInfoRow; i < Math.min(this.currentInfoRow + 5, spawnInfo.size()); ++i) {
            String s = GuiHelper.splitStringToFit(spawnInfo.get(i), 9, 155);
            for (int j = 0; j < s.split("\n").length; ++j) {
                String s1 = s.split("\n")[j];
                GuiHelper.drawScaledString(s1, centerX - 86, 55.0f + (float)this.field_146297_k.field_71466_p.field_78288_b * 0.5625f * (float)j + (float)((i - this.currentInfoRow) * 9), 0xFFFFFF, 9.0f);
            }
        }
    }

    private void drawBottomPage(int mouseX, int mouseY, float partialTicks) {
        this.searchBar.func_146194_f();
        int centerW = this.field_146294_l / 2;
        for (int i = this.currentRow * 7; i < Math.min(this.pokemon.size(), this.currentRow * 7 + 21); ++i) {
            int j = i - this.currentRow * 7;
            this.field_146297_k.field_71446_o.func_110577_a(GuiResources.getPokemonSprite(EnumSpecies.getFromDex(this.pokemon.get(i)), 0, Gender.Male, "", EnumSpecialTexture.None, false));
            if (ClientStorageManager.pokedex.get(this.pokemon.get(i)) == EnumPokedexRegisterStatus.unknown) {
                GlStateManager.func_179124_c((float)0.0f, (float)0.0f, (float)0.0f);
            }
            int x = centerW + j % 7 * 23 - 86;
            int y = j / 7 * 18 + 148;
            GuiHelper.drawImageQuad(x, y, 20.0, 20.0f, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
            if (ClientStorageManager.pokedex.get(this.pokemon.get(i)) == EnumPokedexRegisterStatus.seen) {
                GlStateManager.func_179124_c((float)0.0f, (float)0.0f, (float)0.0f);
            }
            if (ClientStorageManager.pokedex.get(this.pokemon.get(i)) != EnumPokedexRegisterStatus.unknown) {
                this.field_146297_k.field_71446_o.func_110577_a(GuiResources.pokedexCaught);
                GuiHelper.drawImageQuad(x + 15, (double)y + 3.5, 5.0, 5.0f, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
            }
            GlStateManager.func_179124_c((float)255.0f, (float)255.0f, (float)255.0f);
            if (x > mouseX || mouseX > x + 20 || y + 4 > mouseY || mouseY > y + 16 || ClientStorageManager.pokedex.get(this.pokemon.get(i)) == EnumPokedexRegisterStatus.unknown) continue;
            this.field_146297_k.field_71446_o.func_110577_a(GuiResources.pixelmonCreativeInventory);
            GuiHelper.drawImageQuad(x - 2, y + 2, 24.0, 20.0f, 0.2265625, 0.72265625, 0.3046875, 0.80078125, this.field_73735_i);
        }
        String s = I18n.func_135052_a((String)"gui.pokedex.caught", (Object[])new Object[0]) + " " + ClientStorageManager.pokedex.countCaught();
        GuiHelper.drawScaledString(s, centerW - 45, 210.0f, 0xFFFFFF, 8.0f);
        s = I18n.func_135052_a((String)"gui.pokedex.seen", (Object[])new Object[0]) + " " + ClientStorageManager.pokedex.countSeen();
        GuiHelper.drawScaledString(s, centerW, 210.0f, 0xFFFFFF, 8.0f);
        s = I18n.func_135052_a((String)"gui.pokedex.completion", (Object[])new Object[0]) + " " + (int)((double)ClientStorageManager.pokedex.countCaught() / (double)Pokedex.pokedexSize * 100.0) + "%";
        GuiHelper.drawScaledString(s, centerW + 46, 210.0f, 0xFFFFFF, 8.0f);
    }

    protected void func_73869_a(char p_keyTyped_1_, int p_keyTyped_2_) throws IOException {
        super.func_73869_a(p_keyTyped_1_, p_keyTyped_2_);
        if (this.searchBar.func_146201_a(p_keyTyped_1_, p_keyTyped_2_)) {
            this.pokemon = Pokedex.fullPokedex.values().stream().filter(e -> e.name.toLowerCase().contains(this.searchBar.func_146179_b().toLowerCase())).map(e -> e.natPokedexNum).collect(Collectors.toList());
            this.pokemon.sort(Comparator.naturalOrder());
            this.currentRow = 0;
        }
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (button == this.up) {
            this.currentRow = Math.max(0, this.currentRow - 1);
        } else if (button == this.down) {
            this.currentRow = Math.min((int)Math.ceil((double)this.pokemon.size() / 7.0) - 1, this.currentRow + 1);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int button) throws IOException {
        int i;
        if (this.frame != 60) {
            return;
        }
        if (this.searchBar.func_146192_a(mouseX, mouseY, button)) {
            return;
        }
        super.func_73864_a(mouseX, mouseY, button);
        int centerX = this.field_146294_l / 2;
        int mouseCenterX = mouseX - centerX;
        if (mouseCenterX >= -86 && mouseCenterX <= 72 && mouseY >= 148 && mouseY <= 202 && (i = (this.currentRow + (mouseY - 148) / 18) * 7 + (mouseX - (centerX - 86)) / 23) >= 0 && i < this.pokemon.size() && ClientStorageManager.pokedex.get(this.pokemon.get(i)) != EnumPokedexRegisterStatus.unknown) {
            this.currentInfoRow = 0;
            this.currentPokemon = this.pokemon.get(i);
            this.setupDisplayedPokemon();
        }
        if (this.currentPage == 0) {
            if (ClientStorageManager.pokedex.get(this.currentPokemon) == EnumPokedexRegisterStatus.caught) {
                int i2;
                List forms = EnumSpecies.formList.get((Object)this.display.getSpecies());
                if (forms.isEmpty()) {
                    forms.add(EnumNoForm.NoForm);
                }
                if ((i2 = forms.indexOf(this.display.getPokemonData().getFormEnum()) * 2 + (this.display.getPokemonData().isShiny() ? 1 : 0)) - 1 >= 0 && mouseCenterX >= -88 && mouseCenterX <= -74 && mouseY >= 105 && mouseY <= 120) {
                    this.display.getPokemonData().setForm((IEnumForm)forms.get((i2 - 1) / 2));
                    this.display.getPokemonData().setShiny((i2 - 1) % 2 != 0);
                } else if (i2 + 1 < forms.size() * 2 && mouseCenterX >= -42 && mouseCenterX <= -26 && mouseY >= 105 && mouseY <= 120) {
                    this.display.getPokemonData().setForm((IEnumForm)forms.get((i2 + 1) / 2));
                    this.display.getPokemonData().setShiny((i2 + 1) % 2 != 0);
                }
            }
            if (mouseCenterX >= 54 && mouseCenterX <= 80 && mouseY >= 100 && mouseY <= 125) {
                ++this.currentPage;
            }
        } else if (mouseCenterX >= -81 && mouseCenterX <= -55 && mouseY >= 100 && mouseY <= 125) {
            --this.currentPage;
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int i = Mouse.getEventDWheel();
        int mouseX = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int mouseY = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        int mouseCenterX = mouseX - this.field_146294_l / 2;
        if (mouseCenterX >= -86 && mouseCenterX <= 72 && mouseY >= 148 && mouseY <= 202) {
            if (i > 0) {
                this.currentRow = Math.max(0, this.currentRow - 1);
            } else if (i < 0) {
                this.currentRow = Math.min((int)Math.ceil((double)this.pokemon.size() / 7.0) - 1, this.currentRow + 1);
            }
        } else if (this.currentPage == 1 && mouseCenterX >= -90 && mouseCenterX <= 88 && mouseY >= 40 && mouseY <= 85) {
            if (i > 0) {
                this.currentInfoRow = Math.max(0, this.currentInfoRow - 1);
            } else if (i < 0) {
                this.currentInfoRow = Math.min(Math.max(this.getSpawnInfo().size() - 5, 0), this.currentInfoRow + 1);
            }
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    private void setupDisplayedPokemon() {
        this.display = new EntityPixelmon((World)this.field_146297_k.field_71441_e);
        this.display.setPokemon((Pokemon)Pixelmon.pokemonFactory.create(EnumSpecies.getFromDex(this.currentPokemon)));
        this.display.getPokemonData().setShiny(false);
        this.display.getPokemonData().setGrowth(EnumGrowth.Ordinary);
        this.display.getPokemonData().setGender(Gender.Male);
        this.currentPage = 0;
        if (this.reference == null) {
            this.reference = new EntityPixelmon((World)this.field_146297_k.field_71441_e);
            this.reference.setPokemon((Pokemon)Pixelmon.pokemonFactory.create(EnumSpecies.Bulbasaur));
            this.reference.getPokemonData().setShiny(false);
            this.reference.getPokemonData().setGrowth(EnumGrowth.Ordinary);
        }
    }

    private List<String> getSpawnInfo() {
        return ClientStorageManager.pokedex.getSpawnData(this.currentPokemon).stream().map(Object::toString).collect(Collectors.toList());
    }

    private void drawEntityToScreen(int x, int y, int l, EntityPixelmon e, int mouseX, float pt) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179142_g();
        GlStateManager.func_179126_j();
        GlStateManager.func_179109_b((float)x, (float)y, (float)100.0f);
        Vector3d size = e.getModelSize();
        float scalar = (float)l * this.getScalar(size.getX(), size.getY());
        GlStateManager.func_179152_a((float)scalar, (float)scalar, (float)scalar);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)((float)(x - mouseX) / 2.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.func_74519_b();
        try {
            RenderManager renderManager = Minecraft.func_71410_x().func_175598_ae();
            Render entityClassRenderObject = renderManager.func_78715_a(EntityPixelmon.class);
            RenderPixelmon rp = (RenderPixelmon)entityClassRenderObject;
            rp.renderPixelmon(e, 0.0, 0.0, 0.0, pt, true);
            renderManager.field_78735_i = 180.0f;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        GlStateManager.func_179114_b((float)(-((float)(x - mouseX) / 2.0f)), (float)0.0f, (float)-1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)-180.0f, (float)0.0f, (float)0.0f, (float)-1.0f);
        GlStateManager.func_179152_a((float)(1.0f / scalar), (float)(1.0f / scalar), (float)(1.0f / scalar));
        GlStateManager.func_179121_F();
    }

    private float getScalar(double width, double height) {
        Vector3d size = this.reference.getModelSize();
        double referenceW = size.getX();
        double referenceH = size.getY();
        if (referenceH < 0.0 || referenceW < 0.0 || width < 0.0 || height < 0.0) {
            return 1.0f;
        }
        double dh = height - referenceH;
        double dw = width - referenceW;
        double scalar = 1.0;
        if (dh > dw) {
            scalar = referenceH / height;
        } else if (dw >= dh) {
            scalar = referenceW / width;
        }
        return (float)scalar;
    }
}

