/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.pokechecker;

import com.google.common.base.Preconditions;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.PokemonStorage;
import com.pixelmonmod.pixelmon.api.storage.StoragePosition;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.client.SoundHelper;
import com.pixelmonmod.pixelmon.client.gui.GuiHelper;
import com.pixelmonmod.pixelmon.client.gui.GuiResources;
import com.pixelmonmod.pixelmon.client.gui.pokechecker.GuiPokeCheckerTabs;
import com.pixelmonmod.pixelmon.client.gui.pokechecker.GuiRenamePokemon;
import com.pixelmonmod.pixelmon.client.gui.pokechecker.GuiScreenPokeCheckerMoves;
import com.pixelmonmod.pixelmon.client.gui.pokechecker.GuiScreenPokeCheckerStats;
import com.pixelmonmod.pixelmon.client.gui.pokechecker.GuiScreenPokeCheckerWarningLevel;
import com.pixelmonmod.pixelmon.client.storage.ClientStorageManager;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.config.PixelmonServerConfig;
import com.pixelmonmod.pixelmon.entities.pixelmon.Entity1Base;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.StatsType;
import com.pixelmonmod.pixelmon.enums.EnumType;
import java.io.IOException;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.Tuple;
import org.lwjgl.opengl.GL11;

public class GuiScreenPokeChecker
extends GuiScreen {
    protected int xSize = 176;
    protected int ySize = 166;
    protected int guiLeft;
    protected int guiTop;
    protected PokemonStorage storage;
    protected StoragePosition position;
    protected Pokemon pokemon;
    @Nullable
    protected GuiScreen parent;
    private GuiButton renameButton;

    public GuiScreenPokeChecker(PokemonStorage storage, StoragePosition position, @Nullable GuiScreen parent) {
        this.storage = (PokemonStorage)Preconditions.checkNotNull((Object)storage);
        this.position = (StoragePosition)Preconditions.checkNotNull((Object)position);
        this.pokemon = (Pokemon)Preconditions.checkNotNull((Object)storage.get(position));
        this.parent = parent;
        this.renameButton = new GuiButton(4, 0, 0, 50, 20, I18n.func_135052_a((String)"gui.screenpokechecker.rename", (Object[])new Object[0]));
        this.renameButton.field_146125_m = false;
    }

    GuiScreenPokeChecker(GuiScreenPokeChecker tab) {
        this(tab.storage, tab.position, tab.parent);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.guiLeft = (this.field_146294_l - this.xSize) / 2;
        this.guiTop = (this.field_146295_m - this.ySize) / 2;
        this.field_146292_n.clear();
        this.field_146292_n.add(new GuiPokeCheckerTabs(3, 0, this.field_146294_l / 2 + 107, this.field_146295_m / 2 + 80, 17, 15, ""));
        this.field_146292_n.add(new GuiPokeCheckerTabs(0, 1, this.field_146294_l / 2 - 34 - 89 - 4, this.field_146295_m / 2 + 80, 89, 15, I18n.func_135052_a((String)"gui.screenpokechecker.summary", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiPokeCheckerTabs(1, 2, this.field_146294_l / 2 - 34, this.field_146295_m / 2 + 80, 69, 15, I18n.func_135052_a((String)"gui.screenpokechecker.moves", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiPokeCheckerTabs(2, 3, this.field_146294_l / 2 + 36, this.field_146295_m / 2 + 80, 69, 15, I18n.func_135052_a((String)"gui.screenpokechecker.stats", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiPokeCheckerTabs(4, 5, this.field_146294_l / 2 - 44, this.field_146295_m / 2 - 107, 9, 9, "", this.pokemon));
        this.field_146292_n.add(new GuiPokeCheckerTabs(7, 6, this.field_146294_l / 2 - 44, this.field_146295_m / 2 - 1, 9, 8, "", this.pokemon));
        this.field_146292_n.add(this.renameButton);
    }

    public void func_146284_a(GuiButton button) {
        switch (button.field_146127_k) {
            case 0: {
                this.closeScreen();
                break;
            }
            case 1: {
                this.field_146297_k.func_147108_a((GuiScreen)new GuiScreenPokeChecker(this));
                break;
            }
            case 2: {
                this.field_146297_k.func_147108_a((GuiScreen)new GuiScreenPokeCheckerMoves(this));
                break;
            }
            case 3: {
                this.field_146297_k.func_147108_a((GuiScreen)new GuiScreenPokeCheckerStats(this));
                break;
            }
            case 4: {
                if (!PixelmonConfig.allowNicknames || this.pokemon.isEgg()) break;
                this.field_146297_k.func_147108_a((GuiScreen)new GuiRenamePokemon(this));
                break;
            }
            case 5: {
                this.field_146297_k.func_147108_a((GuiScreen)new GuiScreenPokeCheckerWarningLevel(this));
                break;
            }
            case 6: {
                if (!PixelmonConfig.allowNicknames || this.pokemon.isEgg()) break;
                this.field_146297_k.func_147108_a((GuiScreen)new GuiRenamePokemon(this));
            }
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode == 1) {
            this.closeScreen();
        }
        super.func_73869_a(typedChar, keyCode);
    }

    private void closeScreen() {
        if (this.parent == null) {
            this.field_146297_k.field_71439_g.func_71053_j();
        } else {
            this.field_146297_k.func_147108_a(this.parent);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (mouseX > this.field_146294_l / 2 - 125 && mouseX < this.field_146294_l / 2 - 40 && mouseY > this.field_146295_m / 2 - 15 && mouseY < this.field_146295_m / 2 + 5) {
            if (mouseButton == 1) {
                this.renameButton.field_146125_m = true;
                this.renameButton.field_146128_h = mouseX;
                this.renameButton.field_146129_i = mouseY;
            } else {
                this.renameButton.field_146125_m = false;
            }
        }
        this.arrowsMouseClicked(mouseX, mouseY);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        int i = this.guiLeft;
        int j = this.guiTop;
        this.drawGuiContainerBackgroundLayer(partialTicks, mouseX, mouseY);
        GlStateManager.func_179101_C();
        RenderHelper.func_74518_a();
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        RenderHelper.func_74520_c();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)i, (float)j, (float)0.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179091_B();
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderHelper.func_74518_a();
        this.drawGuiContainerForegroundLayer(mouseX, mouseY);
        RenderHelper.func_74520_c();
        GlStateManager.func_179121_F();
        GlStateManager.func_179145_e();
        GlStateManager.func_179126_j();
        RenderHelper.func_74519_b();
    }

    public void drawGuiContainerForegroundLayer(int mouseX, int mouseY) {
        GL11.glNormal3f((float)0.0f, (float)-1.0f, (float)0.0f);
        if (!this.pokemon.isEgg()) {
            this.func_73731_b(this.field_146297_k.field_71466_p, I18n.func_135052_a((String)"gui.screenpokechecker.lvl", (Object[])new Object[0]) + " " + this.pokemon.getLevel(), 10, -14, 0xFFFFFF);
            this.func_73731_b(this.field_146297_k.field_71466_p, I18n.func_135052_a((String)"gui.screenpokechecker.number", (Object[])new Object[0]) + " " + String.valueOf(this.pokemon.getSpecies().getNationalPokedexInteger()), -30, -14, 0xFFFFFF);
            if (this.pokemon.getHealth() <= 0) {
                this.func_73731_b(this.field_146297_k.field_71466_p, I18n.func_135052_a((String)"gui.screenpokechecker.fainted", (Object[])new Object[0]), 117, -13, 0xFFFFFF);
            } else {
                this.func_73732_a(this.field_146297_k.field_71466_p, this.pokemon.getHealth() + "/" + this.pokemon.getStat(StatsType.HP), 140, -13, 0xDDDDDD);
            }
        } else {
            this.func_73731_b(this.field_146297_k.field_71466_p, I18n.func_135052_a((String)"gui.screenpokechecker.lvl", (Object[])new Object[0]) + " ???", 10, -14, 0xFFFFFF);
            this.func_73731_b(this.field_146297_k.field_71466_p, I18n.func_135052_a((String)"gui.screenpokechecker.number", (Object[])new Object[0]) + " ???", -30, -14, 0xFFFFFF);
            this.func_73732_a(this.field_146297_k.field_71466_p, "???/???", 140, -13, 0xDDDDDD);
        }
        this.func_73731_b(this.field_146297_k.field_71466_p, I18n.func_135052_a((String)"gui.screenpokechecker.status", (Object[])new Object[0]), -9, 113, 0xFFFFFF);
        this.func_73731_b(this.field_146297_k.field_71466_p, I18n.func_135052_a((String)"gui.screenpokechecker.texp", (Object[])new Object[0]), 107, 40, 0xFFFFFF);
        this.func_73732_a(this.field_146297_k.field_71466_p, I18n.func_135052_a((String)"gui.screenpokechecker.levelup", (Object[])new Object[0]), 134, 74, 0xFFFFFF);
        if (!this.pokemon.isEgg()) {
            this.func_73732_a(this.field_146297_k.field_71466_p, String.valueOf(this.pokemon.getExperience()), 135, 55, 0xFFFFFF);
            this.func_73732_a(this.field_146297_k.field_71466_p, String.valueOf(this.pokemon.getExperienceToLevelUp()), 135, 90, 0xFFFFFF);
        } else {
            this.func_73732_a(this.field_146297_k.field_71466_p, "???", 135, 55, 0xFFFFFF);
            this.func_73732_a(this.field_146297_k.field_71466_p, "???", 135, 90, 0xFFFFFF);
        }
        this.func_73731_b(this.field_146297_k.field_71466_p, I18n.func_135052_a((String)"gui.screenpokechecker.ability", (Object[])new Object[0]), 75, 117, 0xFFFFFF);
        if (!this.pokemon.isEgg()) {
            try {
                this.func_73731_b(this.field_146297_k.field_71466_p, I18n.func_135052_a((String)("ability." + this.pokemon.getAbilityName() + ".name"), (Object[])new Object[0]), 130, 117, 0xFFFFFF);
                this.field_146297_k.field_71466_p.func_78279_b(I18n.func_135052_a((String)("ability." + this.pokemon.getAbility().getName() + ".description"), (Object[])new Object[0]), 62, 130, 145, 0xFFFFFF);
            }
            catch (Exception e) {
                this.func_73731_b(this.field_146297_k.field_71466_p, I18n.func_135052_a((String)"ability.ComingSoon.name", (Object[])new Object[0]), 130, 117, 0xFFFFFF);
                this.field_146297_k.field_71466_p.func_78279_b(I18n.func_135052_a((String)"ability.ComingSoon.description", (Object[])new Object[0]), 62, 130, 145, 0xFFFFFF);
            }
        } else {
            this.func_73731_b(this.field_146297_k.field_71466_p, I18n.func_135052_a((String)"ability.Egg.name", (Object[])new Object[0]), 130, 117, 0xFFFFFF);
            this.field_146297_k.field_71466_p.func_78279_b(I18n.func_135052_a((String)this.pokemon.getEggDescription(), (Object[])new Object[0]), 62, 130, 145, 0xFFFFFF);
        }
        this.drawBasePokemonInfo();
    }

    protected void drawBasePokemonInfo() {
        GuiHelper.bindPokemonSprite(this.pokemon, this.field_146297_k);
        GuiHelper.drawImageQuad(-33.0, -2.0, 84.0, 84.0f, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
        if (!this.pokemon.isEgg()) {
            EnumType type1 = this.pokemon.getBaseStats().getType1();
            EnumType type2 = this.pokemon.getBaseStats().getType2();
            float x = type1.textureX;
            float y = type1.textureY;
            float x1 = 0.0f;
            float y1 = 0.0f;
            if (type2 != null) {
                x1 = type2.textureX;
                y1 = type2.textureY;
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_146297_k.field_71446_o.func_110577_a(GuiResources.types);
            if (type2 != EnumType.Mystery && type2 != null) {
                GuiHelper.drawImageQuad(8.0, 0.0, 21.0, 21.0f, x1 / 495.0f, y1 / 392.0f, (x1 + 98.0f) / 495.0f, (y1 + 98.0f) / 392.0f, this.field_73735_i);
                GuiHelper.drawImageQuad(-14.0, 0.0, 21.0, 21.0f, x / 495.0f, y / 392.0f, (x + 98.0f) / 495.0f, (y + 98.0f) / 392.0f, this.field_73735_i);
            } else {
                GuiHelper.drawImageQuad(-2.0, 0.0, 21.0, 21.0f, x / 495.0f, y / 392.0f, (x + 98.0f) / 495.0f, (y + 98.0f) / 392.0f, this.field_73735_i);
            }
        }
        if (this.pokemon.isShiny()) {
            this.field_146297_k.field_71446_o.func_110577_a(GuiResources.shiny);
            GuiHelper.drawImageQuad(-35.0, 73.0, 10.0, 10.0f, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
        }
        if (this.pokemon.getPokerus() != null && !this.pokemon.getPokerus().canInfect()) {
            this.field_146297_k.field_71446_o.func_110577_a(GuiResources.pokerusFace);
            GuiHelper.drawImageQuad(30.0, 62.0, 16.0, 16.0f, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
        }
    }

    public void drawGuiContainerBackgroundLayer(float partialTicks, int mouseX, int mouseY) {
        this.field_146297_k.field_71446_o.func_110577_a(GuiResources.summarySummary);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b((this.field_146294_l - this.xSize) / 2 - 40, (this.field_146295_m - this.ySize) / 2 - 25, 0, 0, 256, 204);
        this.func_73729_b((this.field_146294_l - this.xSize) / 2 - 15, (this.field_146295_m - this.ySize) / 2 + 127, 23, 225, 44, 28);
        this.drawHealthBar((this.field_146294_l - this.xSize) / 2 + 59, (this.field_146295_m - this.ySize) / 2 - 18, 154, 14, this.pokemon);
        this.func_73729_b((this.field_146294_l - this.xSize) / 2 + 59, (this.field_146295_m - this.ySize) / 2 - 18, 103, 222, 150, 16);
        this.drawExpBar((this.field_146294_l - this.xSize) / 2 + 86, (this.field_146295_m - this.ySize) / 2, 122, 14, this.pokemon);
        this.func_73729_b((this.field_146294_l - this.xSize) / 2 + 59, (this.field_146295_m - this.ySize) / 2, 104, 239, 150, 16);
        float[] texturePair = StatusType.getTexturePos(this.pokemon.getStatus().type);
        float textureX1 = texturePair[0];
        float textureY1 = texturePair[1];
        if (textureX1 != -1.0f) {
            this.field_146297_k.field_71446_o.func_110577_a(GuiResources.status);
            GuiHelper.drawImageQuad((this.field_146294_l - this.xSize) / 2 - 29, (float)((this.field_146295_m - this.ySize) / 2) + 126.5f, 72.0, 31.5f, textureX1 / 299.0f, textureY1 / 210.0f, (textureX1 + 147.0f) / 299.0f, (textureY1 + 68.0f) / 210.0f, this.field_73735_i);
        } else if (this.pokemon.getPokerus() != null && this.pokemon.getPokerus().canInfect()) {
            this.field_146297_k.field_71446_o.func_110577_a(GuiResources.pokerus);
            GuiHelper.drawImageQuad((this.field_146294_l - this.xSize) / 2 - 21, (float)((this.field_146295_m - this.ySize) / 2) + 130.0f, 56.0, 22.0f, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
        } else {
            this.field_146297_k.field_71446_o.func_110577_a(GuiResources.status);
            GuiHelper.drawImageQuad((this.field_146294_l - this.xSize) / 2 - 29, (float)((this.field_146295_m - this.ySize) / 2) + 126.5f, 72.0, 31.5f, 0.0033444815780967474, 0.6761904954910278, 0.4949832856655121, 1.0, this.field_73735_i);
        }
        this.drawPokemonName();
        this.drawArrows(mouseX, mouseY);
    }

    protected void drawPokemonName() {
        if (this.pokemon.isEgg()) {
            this.drawCenteredStringWithoutShadow(Entity1Base.getLocalizedName("Egg"), (this.field_146294_l - this.xSize) / 2 + 7, (this.field_146295_m - this.ySize) / 2 + 87, 0xFFFFFF);
        } else if (this.pokemon.getNickname() != null) {
            this.drawCenteredStringWithoutShadow("(" + this.pokemon.getSpecies().getLocalizedName() + ")", (this.field_146294_l - this.xSize) / 2 + 7, (this.field_146295_m - this.ySize) / 2 + 91, 0xFFFFFF);
            this.drawCenteredStringWithoutShadow(this.pokemon.getNickname(), (this.field_146294_l - this.xSize) / 2 + 7, (this.field_146295_m - this.ySize) / 2 + 83, 0xFFFFFF);
        } else {
            this.drawCenteredStringWithoutShadow(this.pokemon.getDisplayName(), (this.field_146294_l - this.xSize) / 2 + 7, (this.field_146295_m - this.ySize) / 2 + 87, 0xFFFFFF);
        }
    }

    public void arrowsMouseClicked(int mouseX, int mouseY) {
        int l1 = (this.field_146294_l - this.xSize) / 2 + 220;
        int l2 = (this.field_146294_l - this.xSize) / 2 - 62;
        int w = 16;
        int t = (this.field_146295_m - this.ySize) / 2;
        int h = 21;
        if (mouseY > t && mouseY < t + h) {
            if (mouseX > l1 && mouseX < l1 + w) {
                SoundHelper.playButtonPressSound();
                this.setNextPokemon();
            }
            if (mouseX > l2 && mouseX < l2 + w) {
                SoundHelper.playButtonPressSound();
                this.setPrevPokemon();
            }
        }
    }

    private void setPrevPokemon() {
        Tuple<Pokemon, StoragePosition> previous = ClientStorageManager.getPrevious(this.storage, this.position);
        if (previous != null && previous.func_76341_a() != null) {
            this.pokemon = (Pokemon)previous.func_76341_a();
            this.position = (StoragePosition)previous.func_76340_b();
        }
    }

    private void setNextPokemon() {
        Tuple<Pokemon, StoragePosition> previous = ClientStorageManager.getNext(this.storage, this.position);
        if (previous != null && previous.func_76341_a() != null) {
            this.pokemon = (Pokemon)previous.func_76341_a();
            this.position = (StoragePosition)previous.func_76340_b();
        }
    }

    public void drawArrows(int mouseX, int mouseY) {
        if (this.position.box != -1) {
            return;
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(GuiResources.summaryMoves);
        int l1 = (this.field_146294_l - this.xSize) / 2 + 220;
        int l2 = (this.field_146294_l - this.xSize) / 2 - 62;
        int w = 16;
        int t = (this.field_146295_m - this.ySize) / 2;
        int h = 21;
        this.func_73729_b(l1, t, 24, 207, w, h);
        this.func_73729_b(l2, t, 42, 207, w, h);
        if (mouseY > t && mouseY < t + h) {
            if (mouseX > l1 && mouseX < l1 + w) {
                this.func_73729_b(l1, t, 60, 207, w, h);
            }
            if (mouseX > l2 && mouseX < l2 + w) {
                this.func_73729_b(l2, t, 78, 207, w, h);
            }
        }
    }

    private void drawExpBar(int x, int y, int width, int height, Pokemon pokemon) {
        GlStateManager.func_179091_B();
        GlStateManager.func_179142_g();
        GlStateManager.func_179094_E();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        GlStateManager.func_179090_x();
        int barWidth = !pokemon.isEgg() ? (int)(pokemon.getExperienceFraction() * ((float)width - 6.0f)) : (int)(0.0f * ((float)width - 6.0f));
        if (pokemon.getLevel() == PixelmonServerConfig.maxLevel) {
            barWidth = 0;
        }
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        buffer.func_181662_b((double)x, (double)y, 0.0).func_181666_a(0.0f, 0.0f, 0.4f, 1.0f).func_181675_d();
        buffer.func_181662_b((double)x, (double)(y + height), 0.0).func_181666_a(0.0f, 0.0f, 0.4f, 1.0f).func_181675_d();
        buffer.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_181666_a(0.0f, 0.0f, 0.4f, 1.0f).func_181675_d();
        buffer.func_181662_b((double)(x + width), (double)y, 0.0).func_181666_a(0.0f, 0.0f, 0.4f, 1.0f).func_181675_d();
        buffer.func_181662_b((double)x, (double)y, 0.0).func_181666_a(0.3f, 1.0f, 1.0f, 1.0f).func_181675_d();
        buffer.func_181662_b((double)x, (double)(y + height), 0.0).func_181666_a(0.3f, 1.0f, 1.0f, 1.0f).func_181675_d();
        buffer.func_181662_b((double)(x + barWidth), (double)(y + height), 0.0).func_181666_a(0.3f, 1.0f, 1.0f, 1.0f).func_181675_d();
        buffer.func_181662_b((double)(x + barWidth), (double)y, 0.0).func_181666_a(0.3f, 1.0f, 1.0f, 1.0f).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
        GlStateManager.func_179098_w();
        GlStateManager.func_179101_C();
        GlStateManager.func_179119_h();
    }

    public void drawHealthBar(int x, int y, int width, int height, Pokemon pokemon) {
        GlStateManager.func_179091_B();
        GlStateManager.func_179142_g();
        GlStateManager.func_179094_E();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        GlStateManager.func_179090_x();
        int barWidth = width - 6;
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        buffer.func_181662_b((double)x, (double)y, 0.0).func_181666_a(1.0f, 0.2f, 0.2f, 1.0f).func_181675_d();
        buffer.func_181662_b((double)x, (double)(y + height), 0.0).func_181666_a(1.0f, 0.2f, 0.2f, 1.0f).func_181675_d();
        buffer.func_181662_b((double)(x + barWidth), (double)(y + height), 0.0).func_181666_a(1.0f, 0.2f, 0.2f, 1.0f).func_181675_d();
        buffer.func_181662_b((double)(x + barWidth), (double)y, 0.0).func_181666_a(1.0f, 0.2f, 0.2f, 1.0f).func_181675_d();
        float healthFraction = pokemon.isEgg() ? 1.0f : (float)pokemon.getHealth() / (float)pokemon.getStat(StatsType.HP);
        barWidth = (int)(healthFraction * ((float)width - 24.0f)) + 18;
        buffer.func_181662_b((double)x, (double)y, 0.0).func_181666_a(0.2f, 1.0f, 0.2f, 1.0f).func_181675_d();
        buffer.func_181662_b((double)x, (double)(y + height), 0.0).func_181666_a(0.2f, 1.0f, 0.2f, 1.0f).func_181675_d();
        buffer.func_181662_b((double)(x + barWidth), (double)(y + height), 0.0).func_181666_a(0.2f, 1.0f, 0.2f, 1.0f).func_181675_d();
        buffer.func_181662_b((double)(x + barWidth), (double)y, 0.0).func_181666_a(0.2f, 1.0f, 0.2f, 1.0f).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
        GlStateManager.func_179098_w();
        GlStateManager.func_179101_C();
        GlStateManager.func_179119_h();
    }

    public void drawCenteredStringWithoutShadow(String text, int x, int y, int color) {
        this.field_146297_k.field_71466_p.func_78276_b(text, x - this.field_146297_k.field_71466_p.func_78256_a(text) / 2, y, color);
    }
}

