/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.inventory;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.StoragePosition;
import com.pixelmonmod.pixelmon.client.gui.GuiHelper;
import com.pixelmonmod.pixelmon.client.gui.GuiMegaItem;
import com.pixelmonmod.pixelmon.client.gui.GuiResources;
import com.pixelmonmod.pixelmon.client.gui.GuiShinyCharm;
import com.pixelmonmod.pixelmon.client.gui.elements.GuiButtonPokeChecker;
import com.pixelmonmod.pixelmon.client.gui.inventory.IInventoryPixelmon;
import com.pixelmonmod.pixelmon.client.gui.inventory.SlotInventoryPixelmon;
import com.pixelmonmod.pixelmon.client.storage.ClientStorageManager;
import com.pixelmonmod.pixelmon.comm.packetHandlers.SetHeldItem;
import com.pixelmonmod.pixelmon.comm.packetHandlers.clientStorage.ChangeLurePacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.clientStorage.newStorage.ServerSwap;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Gender;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.StatsType;
import com.pixelmonmod.pixelmon.enums.EnumFeatureState;
import com.pixelmonmod.pixelmon.enums.EnumMegaItem;
import com.pixelmonmod.pixelmon.items.ItemHeld;
import com.pixelmonmod.pixelmon.items.ItemLure;
import com.pixelmonmod.pixelmon.listener.EntityPlayerExtension;
import com.pixelmonmod.pixelmon.storage.ClientData;
import java.text.NumberFormat;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.InventoryEffectRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

class InventoryPixelmon<T extends InventoryEffectRenderer> {
    private T gui;
    private int partyWidth;
    private SlotInventoryPixelmon[] pixelmonSlots;
    private StoragePosition selected;
    private GuiButtonPokeChecker pokeChecker;
    private int ticksTillClick = 0;

    InventoryPixelmon(T gui, int partyWidth) {
        this.gui = gui;
        this.pixelmonSlots = new SlotInventoryPixelmon[6];
        this.partyWidth = partyWidth;
    }

    void initGui() {
        this.pokeChecker = new GuiButtonPokeChecker((GuiScreen)this.gui);
        ((IInventoryPixelmon)this.gui).getButtonList().add(this.pokeChecker);
        this.reloadSlots();
    }

    private void reloadSlots() {
        int i;
        for (i = 0; i < this.pixelmonSlots.length; ++i) {
            this.pixelmonSlots[i] = null;
        }
        for (i = 0; i < this.pixelmonSlots.length; ++i) {
            StoragePosition position = new StoragePosition(-1, i);
            Pokemon pokemon = ClientStorageManager.party.get(i);
            if (pokemon == null) continue;
            int x = ((IInventoryPixelmon)this.gui).getGUILeft() - this.partyWidth + 9;
            int y = ((InventoryEffectRenderer)this.gui).field_146295_m / 2 + i * 18 - 65;
            this.pixelmonSlots[i] = new SlotInventoryPixelmon(x, y, position);
        }
    }

    void drawScreen(int mouseX, int mouseY, float partialTicks) {
        boolean recipeBookVisible;
        boolean bl = recipeBookVisible = this.gui instanceof GuiInventory && ((GuiInventory)this.gui).func_194310_f().func_191878_b();
        if (((InventoryEffectRenderer)this.gui).field_147045_u && !recipeBookVisible) {
            ((InventoryEffectRenderer)this.gui).field_147045_u = false;
            ((IInventoryPixelmon)this.gui).superDrawScreen(mouseX, mouseY, partialTicks);
            ((InventoryEffectRenderer)this.gui).field_147045_u = true;
        } else {
            ((IInventoryPixelmon)this.gui).superDrawScreen(mouseX, mouseY, partialTicks);
        }
        if (recipeBookVisible) {
            return;
        }
        GlStateManager.func_179140_f();
        ((InventoryEffectRenderer)this.gui).field_146297_k.field_71466_p.func_78264_a(true);
        for (SlotInventoryPixelmon slot : this.pixelmonSlots) {
            Pokemon pokemon;
            if (slot == null || (pokemon = ClientStorageManager.party.get(slot.position)) == null) continue;
            if ((!this.pokeChecker.field_146124_l || mouseY < this.pokeChecker.field_146129_i || mouseY > this.pokeChecker.field_146129_i + this.pokeChecker.field_146121_g) && slot.getBounds().contains(mouseX, mouseY)) {
                this.drawPokemonInfo(pokemon, mouseX, mouseY);
                continue;
            }
            if (pokemon.isEgg() || !slot.getHeldItemBounds().contains(mouseX, mouseY) || !this.heldItemQualifies(pokemon) || this.ticksTillClick > 0) continue;
            ((InventoryEffectRenderer)this.gui).field_146297_k.field_71446_o.func_110577_a(GuiResources.pixelmonCreativeInventory);
            GuiHelper.drawImageQuad(slot.heldItemX - 2, slot.heldItemY - 2, 20.0, 20.0f, 0.2265625, 0.72265625, 0.3046875, 0.80078125, ((IInventoryPixelmon)this.gui).getZLevel());
            if (pokemon.getHeldItem().func_190926_b()) continue;
            int x = Math.max(mouseX - 62, 0);
            GuiScreen.func_73734_a((int)x, (int)(mouseY - 2), (int)(x + 60), (int)(mouseY + 20), (int)-1437248170);
            ((InventoryEffectRenderer)this.gui).field_146297_k.field_71466_p.func_78276_b(pokemon.getHeldItem().func_82833_r(), x + 2, mouseY, 0xFFFFFF);
        }
        ((InventoryEffectRenderer)this.gui).field_146297_k.field_71466_p.func_78264_a(false);
        int slotLeft = ((IInventoryPixelmon)this.gui).getGUILeft() - this.partyWidth + 8 - 23;
        int slotTop = ((InventoryEffectRenderer)this.gui).field_146295_m / 2 - 77;
        if (ClientStorageManager.party.getLure() != null) {
            ((InventoryEffectRenderer)this.gui).field_146297_k.func_175599_af().func_180450_b(ClientStorageManager.party.getLureStack(), slotLeft - 16, slotTop + 16);
            ((InventoryEffectRenderer)this.gui).field_146297_k.func_175599_af().func_180453_a(((InventoryEffectRenderer)this.gui).field_146297_k.field_71466_p, ClientStorageManager.party.getLureStack(), slotLeft - 16, slotTop + 16, null);
            if (mouseX >= slotLeft - 15 && mouseX <= slotLeft && mouseY >= slotTop + 16 && mouseY <= slotTop + 16 + 14) {
                ((IInventoryPixelmon)this.gui).renderToolTipPublic(ClientStorageManager.party.getLureStack(), mouseX, mouseY);
            }
        }
    }

    void drawGuiContainerBackgroundLayer(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179140_f();
        GlStateManager.func_179106_n();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ((InventoryEffectRenderer)this.gui).field_146297_k.field_71460_t.func_78478_c();
        ((InventoryEffectRenderer)this.gui).field_146297_k.field_71466_p.func_78264_a(true);
        for (SlotInventoryPixelmon slot : this.pixelmonSlots) {
            Pokemon pokemon;
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (slot == null || (pokemon = ClientStorageManager.party.get(slot.position)) == null) continue;
            slot.setX(((IInventoryPixelmon)this.gui).getGUILeft() - this.partyWidth + 9);
            GuiHelper.bindPokemonSprite(pokemon, ((InventoryEffectRenderer)this.gui).field_146297_k);
            GlStateManager.func_179140_f();
            GuiHelper.drawImageQuad(slot.x, slot.y - 3, 16.0, 16.0f, 0.0, 0.0, 1.0, 1.0, ((IInventoryPixelmon)this.gui).getZLevel());
            if (!pokemon.isEgg()) {
                if (pokemon.getHeldItem() != ItemStack.field_190927_a) {
                    ((InventoryEffectRenderer)this.gui).field_146297_k.func_175599_af().func_175042_a(pokemon.getHeldItem(), slot.heldItemX, slot.heldItemY);
                } else {
                    ((InventoryEffectRenderer)this.gui).field_146297_k.field_71446_o.func_110577_a(GuiResources.heldItem);
                    GuiHelper.drawImageQuad(slot.heldItemX + 3, slot.heldItemY + 3, 10.0, 10.0f, 0.0, 0.0, 1.0, 1.0, ((IInventoryPixelmon)this.gui).getZLevel());
                }
            }
            if (!slot.position.equals(this.selected)) continue;
            ((InventoryEffectRenderer)this.gui).field_146297_k.field_71446_o.func_110577_a(GuiResources.pcResources);
            GuiHelper.drawImageQuad((float)slot.x + 0.5f, (float)slot.y + 0.5f, 15.0, 15.0f, 0.0, 0.11328125, 0.11328125, 0.2265625, ((IInventoryPixelmon)this.gui).getZLevel());
        }
        int slotLeft = ((IInventoryPixelmon)this.gui).getGUILeft() - this.partyWidth + 8 - 38;
        int slotTop = ((InventoryEffectRenderer)this.gui).field_146295_m / 2 - 76;
        EnumMegaItem megaItem = EntityPlayerExtension.getPlayerMegaItem((EntityPlayer)((InventoryEffectRenderer)this.gui).field_146297_k.field_71439_g);
        if (megaItem != EnumMegaItem.Disabled) {
            if (megaItem.canEvolve()) {
                ((InventoryEffectRenderer)this.gui).field_146297_k.field_71446_o.func_110577_a(GuiResources.keyStoneSprite);
                GuiHelper.drawImageQuad(slotLeft, slotTop, 14.0, 14.0f, 0.0, 0.0, 1.0, 1.0, ((IInventoryPixelmon)this.gui).getZLevel());
            }
            if (mouseX >= slotLeft && mouseX <= slotLeft + 14 && mouseY >= slotTop && mouseY <= slotTop + 14) {
                ((InventoryEffectRenderer)this.gui).field_146297_k.field_71446_o.func_110577_a(GuiResources.pixelmonCreativeInventory);
                GuiHelper.drawImageQuad(slotLeft - 2, slotTop - 2, 18.0, 18.0f, 0.2265625, 0.72265625, 0.3046875, 0.80078125, ((IInventoryPixelmon)this.gui).getZLevel());
            }
        }
        slotLeft += 15;
        --slotTop;
        EnumFeatureState charm = EntityPlayerExtension.getPlayerShinyCharm((EntityPlayer)((InventoryEffectRenderer)this.gui).field_146297_k.field_71439_g);
        if (charm != EnumFeatureState.Disabled) {
            if (charm.isActive()) {
                ((InventoryEffectRenderer)this.gui).field_146297_k.field_71446_o.func_110577_a(GuiResources.shinyCharm);
                GuiHelper.drawImageQuad(slotLeft, slotTop, 16.0, 16.0f, 0.0, 0.0, 1.0, 1.0, ((IInventoryPixelmon)this.gui).getZLevel());
            }
            if (mouseX >= slotLeft && mouseX <= slotLeft + 14 && mouseY >= slotTop + 1 && mouseY <= slotTop + 15) {
                ((InventoryEffectRenderer)this.gui).field_146297_k.field_71446_o.func_110577_a(GuiResources.pixelmonCreativeInventory);
                GuiHelper.drawImageQuad(slotLeft - 1, slotTop - 1, 18.0, 18.0f, 0.2265625, 0.72265625, 0.3046875, 0.80078125, ((IInventoryPixelmon)this.gui).getZLevel());
            }
        }
        if ((ClientStorageManager.party.getLure() != null || ((InventoryEffectRenderer)this.gui).field_146297_k.field_71439_g.field_71071_by.func_70445_o().func_77973_b() instanceof ItemLure) && mouseX >= slotLeft - 15 && mouseX <= slotLeft && mouseY >= slotTop + 16 && mouseY <= slotTop + 16 + 14) {
            ((InventoryEffectRenderer)this.gui).field_146297_k.field_71446_o.func_110577_a(GuiResources.pixelmonCreativeInventory);
            GuiHelper.drawImageQuad(slotLeft - 17, slotTop + 15, 18.0, 18.0f, 0.2265625, 0.72265625, 0.3046875, 0.80078125, ((IInventoryPixelmon)this.gui).getZLevel());
        }
        GuiHelper.drawStringRightAligned(NumberFormat.getInstance().format(ClientData.playerMoney), ((IInventoryPixelmon)this.gui).getGUILeft() - this.partyWidth + 44, ((InventoryEffectRenderer)this.gui).field_146295_m / 2 + 46, 0, false);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ((InventoryEffectRenderer)this.gui).field_146297_k.field_71466_p.func_78264_a(false);
        RenderHelper.func_74518_a();
        GlStateManager.func_179140_f();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179126_j();
    }

    private boolean heldItemQualifies(Pokemon pokemon) {
        ItemStack handStack = ((InventoryEffectRenderer)this.gui).field_146297_k.field_71439_g.field_71071_by.func_70445_o();
        ItemStack heldStack = pokemon.getHeldItem();
        if (handStack.func_190926_b() && !heldStack.func_190926_b()) {
            return true;
        }
        return !handStack.func_190926_b() && handStack.func_77973_b() instanceof ItemHeld;
    }

    private void drawPokemonInfo(Pokemon pokemon, int x, int y) {
        if (pokemon != null) {
            x = Math.max(x - 84, 0);
            GuiScreen.func_73734_a((int)x, (int)(y - 2), (int)(x + 80), (int)(y + 20), (int)-1437248170);
            String displayName = pokemon.getDisplayName();
            ((InventoryEffectRenderer)this.gui).field_146297_k.field_71466_p.func_78276_b(displayName, x + 2, y, 0xFFFFFF);
            ((InventoryEffectRenderer)this.gui).field_146297_k.field_71446_o.func_110577_a(GuiResources.pixelmonOverlay);
            if (!pokemon.isEgg()) {
                if (pokemon.getGender() == Gender.Male) {
                    ((InventoryEffectRenderer)this.gui).field_146297_k.field_71446_o.func_110577_a(GuiResources.male);
                    GuiHelper.drawImageQuad(((InventoryEffectRenderer)this.gui).field_146297_k.field_71466_p.func_78256_a(displayName) + x + 3, y, 5.0, 8.0f, 0.0, 0.0, 1.0, 1.0, 0.0f);
                } else if (pokemon.getGender() == Gender.Female) {
                    ((InventoryEffectRenderer)this.gui).field_146297_k.field_71446_o.func_110577_a(GuiResources.female);
                    GuiHelper.drawImageQuad(((InventoryEffectRenderer)this.gui).field_146297_k.field_71466_p.func_78256_a(displayName) + x + 3, y, 5.0, 8.0f, 0.0, 0.0, 1.0, 1.0, 0.0f);
                }
                String levelString = I18n.func_135052_a((String)"gui.screenpokechecker.lvl", (Object[])new Object[0]) + " " + pokemon.getLevel();
                ((InventoryEffectRenderer)this.gui).field_146297_k.field_71466_p.func_78276_b(levelString, x + 3, y + ((InventoryEffectRenderer)this.gui).field_146297_k.field_71466_p.field_78288_b + 1, 0xFFFFFF);
                if (pokemon.getHealth() <= 0) {
                    ((InventoryEffectRenderer)this.gui).field_146297_k.field_71466_p.func_78276_b(I18n.func_135052_a((String)"gui.creativeinv.fainted", (Object[])new Object[0]), x + 7 + ((InventoryEffectRenderer)this.gui).field_146297_k.field_71466_p.func_78256_a(levelString), y + ((InventoryEffectRenderer)this.gui).field_146297_k.field_71466_p.field_78288_b + 1, 0xFFFFFF);
                } else {
                    ((InventoryEffectRenderer)this.gui).field_146297_k.field_71466_p.func_78276_b(I18n.func_135052_a((String)"gui.creativeinv.hp", (Object[])new Object[0]) + " " + pokemon.getHealth() + "/" + pokemon.getStat(StatsType.HP), x + 7 + ((InventoryEffectRenderer)this.gui).field_146297_k.field_71466_p.func_78256_a(levelString), y + ((InventoryEffectRenderer)this.gui).field_146297_k.field_71466_p.field_78288_b + 1, 0xFFFFFF);
                }
            }
        }
    }

    boolean mouseClicked(int mouseX, int mouseY, int mouseButton) {
        int slotLeft = ((IInventoryPixelmon)this.gui).getGUILeft() - this.partyWidth - 14;
        int slotTop = ((InventoryEffectRenderer)this.gui).field_146295_m / 2 - 76;
        if (EntityPlayerExtension.getPlayerMegaItem((EntityPlayer)((InventoryEffectRenderer)this.gui).field_146297_k.field_71439_g) != EnumMegaItem.Disabled && mouseX >= slotLeft - 16 && mouseX <= slotLeft - 2 && mouseY >= slotTop && mouseY <= slotTop + 14) {
            ((InventoryEffectRenderer)this.gui).field_146297_k.func_147108_a((GuiScreen)new GuiMegaItem());
            return false;
        }
        if (EntityPlayerExtension.getPlayerShinyCharm((EntityPlayer)((InventoryEffectRenderer)this.gui).field_146297_k.field_71439_g) != EnumFeatureState.Disabled && mouseX >= slotLeft - 2 && mouseX <= slotLeft + 14 && mouseY >= slotTop && mouseY <= slotTop + 14) {
            ((InventoryEffectRenderer)this.gui).field_146297_k.func_147108_a((GuiScreen)new GuiShinyCharm());
            return false;
        }
        if (mouseX >= slotLeft - 16 && mouseX <= slotLeft - 2 && mouseY >= slotTop + 16 && mouseY <= slotTop + 16 + 14 && this.ticksTillClick <= 0) {
            ItemStack held = ((InventoryEffectRenderer)this.gui).field_146297_k.field_71439_g.field_71071_by.func_70445_o();
            ItemStack lure = ClientStorageManager.party.getLureStack();
            boolean creative = ((InventoryEffectRenderer)this.gui).field_146297_k.field_71439_g.field_71075_bZ.field_75098_d;
            if (held.func_190926_b() && lure.func_190926_b()) {
                return false;
            }
            if (held.func_77973_b() instanceof ItemLure) {
                if (lure.func_190926_b()) {
                    ((InventoryEffectRenderer)this.gui).field_146297_k.field_71439_g.field_71071_by.func_70437_b(ItemStack.field_190927_a);
                    Pixelmon.network.sendToServer((IMessage)(creative ? new ChangeLurePacket(ChangeLurePacket.Change.PUT, held.func_77973_b(), held.func_77952_i()) : new ChangeLurePacket(ChangeLurePacket.Change.PUT)));
                } else {
                    ((InventoryEffectRenderer)this.gui).field_146297_k.field_71439_g.field_71071_by.func_70437_b(lure);
                    ClientStorageManager.party.setLureStack(held);
                    Pixelmon.network.sendToServer((IMessage)(creative ? new ChangeLurePacket(ChangeLurePacket.Change.SWAP, held.func_77973_b(), held.func_77952_i()) : new ChangeLurePacket(ChangeLurePacket.Change.SWAP)));
                }
            } else if (!lure.func_190926_b() && held.func_190926_b()) {
                ((InventoryEffectRenderer)this.gui).field_146297_k.field_71439_g.field_71071_by.func_70437_b(lure);
                Pixelmon.network.sendToServer((IMessage)new ChangeLurePacket(ChangeLurePacket.Change.TAKE));
            }
            this.ticksTillClick = 10;
            return false;
        }
        if (this.pokeChecker.func_146115_a()) {
            if (mouseButton == 0) {
                this.pokeChecker.mouseClicked(mouseX, mouseY);
            }
            return false;
        }
        for (int i = 0; i < this.pixelmonSlots.length; ++i) {
            SlotInventoryPixelmon slot = this.pixelmonSlots[i];
            StoragePosition position = slot == null ? null : slot.position;
            Pokemon pokemon = position == null ? null : ClientStorageManager.party.get(position);
            int slotX = ((IInventoryPixelmon)this.gui).getGUILeft() - this.partyWidth + 9;
            int slotY = ((InventoryEffectRenderer)this.gui).field_146295_m / 2 + i * 18 - 65;
            if (mouseX >= slotX && mouseX <= slotX + 16 && mouseY >= slotY && mouseY <= slotY + 16) {
                if (mouseButton == 1) {
                    this.pokeChecker.setPokemon(ClientStorageManager.party, position, pokemon, mouseX, mouseY);
                } else {
                    this.pokeChecker.setPokemon(null, null, null, mouseX, mouseY);
                }
                if (mouseButton == 0) {
                    if (this.selected == null) {
                        this.selected = position;
                    } else {
                        Pixelmon.network.sendToServer((IMessage)new ServerSwap(this.selected, ClientStorageManager.party.get(this.selected), new StoragePosition(-1, i), pokemon));
                        ClientStorageManager.party.swap(this.selected.order, i);
                        this.selected = null;
                        this.reloadSlots();
                    }
                }
                return false;
            }
            if (this.ticksTillClick > 0 || pokemon == null || pokemon.isEgg() || !this.heldItemQualifies(pokemon) || !slot.getHeldItemBounds().contains(mouseX, mouseY)) continue;
            SetHeldItem packet = new SetHeldItem(position, pokemon.getUUID());
            InventoryPlayer inventory = ((InventoryEffectRenderer)this.gui).field_146297_k.field_71439_g.field_71071_by;
            ItemStack currentItem = inventory.func_70445_o();
            ItemStack oldItem = pokemon.getHeldItem();
            if (((InventoryEffectRenderer)this.gui).field_146297_k.field_71439_g.field_71075_bZ.field_75098_d) {
                if (!currentItem.func_190926_b()) {
                    ItemStack singleItem = currentItem.func_77946_l();
                    singleItem.func_190920_e(1);
                    pokemon.setHeldItem(singleItem);
                    packet.setItem(currentItem.func_77973_b());
                } else {
                    pokemon.setHeldItem(ItemStack.field_190927_a);
                    packet.setItem(null);
                }
            } else {
                ItemStack playerItem;
                if (oldItem.func_190926_b()) {
                    if (!currentItem.func_190926_b()) {
                        ItemStack singleItem = currentItem.func_77946_l();
                        singleItem.func_190920_e(1);
                        pokemon.setHeldItem(singleItem);
                        if (currentItem.func_190916_E() <= 1) {
                            inventory.func_70437_b(ItemStack.field_190927_a);
                        } else {
                            currentItem.func_190918_g(1);
                        }
                    }
                } else if (currentItem.func_190926_b()) {
                    pokemon.setHeldItem(ItemStack.field_190927_a);
                    inventory.func_70437_b(oldItem);
                } else if (ItemStack.func_179545_c((ItemStack)oldItem, (ItemStack)currentItem) && ItemStack.func_77970_a((ItemStack)oldItem, (ItemStack)currentItem)) {
                    pokemon.setHeldItem(ItemStack.field_190927_a);
                    currentItem.func_190917_f(1);
                } else if (currentItem.func_190916_E() <= 1) {
                    ItemStack singleItem = currentItem.func_77946_l();
                    singleItem.func_190920_e(1);
                    pokemon.setHeldItem(singleItem);
                    inventory.func_70437_b(oldItem);
                } else {
                    ItemStack singleItem = currentItem.func_77946_l();
                    singleItem.func_190920_e(1);
                    pokemon.setHeldItem(singleItem);
                    currentItem.func_190918_g(1);
                    inventory.func_70441_a(oldItem);
                }
                if (!(playerItem = inventory.func_70445_o()).func_190926_b() && playerItem.func_190916_E() > 64) {
                    playerItem.func_190920_e(64);
                }
            }
            Pixelmon.network.sendToServer((IMessage)packet);
            this.ticksTillClick = 10;
            return false;
        }
        return true;
    }

    public void tick() {
        if (this.ticksTillClick > 0) {
            --this.ticksTillClick;
        }
    }
}

