/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.dialogue;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.dialogue.Dialogue;
import com.pixelmonmod.pixelmon.client.gui.GuiHelper;
import com.pixelmonmod.pixelmon.client.gui.elements.GuiRoundButton;
import com.pixelmonmod.pixelmon.comm.packetHandlers.dialogue.DialogueChoiceMade;
import com.pixelmonmod.pixelmon.comm.packetHandlers.dialogue.DialogueClosure;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiDialogue
extends GuiScreen {
    private static volatile List<Dialogue> dialogues;
    private List<GuiRoundButton> choiceButtons = new ArrayList<GuiRoundButton>();
    private Dialogue currentDialogue = dialogues.get(0);
    private boolean pause = false;
    protected int guiLeft;
    protected int guiTop;

    public void func_73866_w_() {
        super.func_73866_w_();
        this.guiLeft = (this.field_146294_l - 176) / 2;
        this.guiTop = (this.field_146295_m - 166) / 2;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        if (this.currentDialogue == null) {
            return;
        }
        if (this.choiceButtons.isEmpty() && !this.currentDialogue.choices.isEmpty()) {
            this.loadButtons();
        }
        GuiHelper.drawChatBox(this, this.currentDialogue.name, Lists.newArrayList((Object[])new String[]{this.currentDialogue.getText()}), 0.0f);
        for (int i = 0; i < this.choiceButtons.size(); ++i) {
            this.choiceButtons.get(i).drawButton(this.getButtonX(i), this.getButtonY(i), mouseX, mouseY, 0.0f);
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        if (this.pause) {
            return;
        }
        if (this.currentDialogue.choices.isEmpty()) {
            GuiDialogue.removeImmediateDialogue();
            this.next();
            if (this.currentDialogue != null) {
                this.loadButtons();
            }
            return;
        }
        for (int i = 0; i < this.choiceButtons.size(); ++i) {
            if (!this.choiceButtons.get(i).isMouseOver(this.getButtonX(i), this.getButtonY(i), mouseX, mouseY)) continue;
            this.pause = true;
            Pixelmon.network.sendToServer((IMessage)new DialogueChoiceMade(this.currentDialogue.choices.get(i)));
            break;
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    public void close() {
        Minecraft.func_71410_x().field_71439_g.func_71053_j();
        Pixelmon.network.sendToServer((IMessage)new DialogueClosure());
    }

    public void next() {
        this.pause = false;
        if (dialogues.isEmpty()) {
            this.close();
        } else {
            this.currentDialogue = dialogues.get(0);
            this.choiceButtons.clear();
        }
    }

    public static void removeImmediateDialogue() {
        if (!dialogues.isEmpty()) {
            dialogues.remove(0);
        }
    }

    public static void addDialogues(List<Dialogue> dialogues) {
        GuiDialogue.dialogues.addAll(dialogues);
    }

    public static void insertDialogues(List<Dialogue> dialogues) {
        dialogues.addAll(GuiDialogue.dialogues);
        GuiDialogue.dialogues = dialogues;
    }

    public static void setDialogues(List<Dialogue> dialogues) {
        GuiDialogue.dialogues = dialogues;
    }

    private void loadButtons() {
        this.choiceButtons.clear();
        for (int i = 0; i < this.currentDialogue.choices.size(); ++i) {
            this.choiceButtons.add(new GuiRoundButton(-30 + (230 - (this.getLargestWidth() + 20)) / 2, 65, this.currentDialogue.choices.get((int)i).text, this.getLargestWidth() + 20, 20));
        }
    }

    private int getLargestWidth() {
        int max = 0;
        for (int i = 0; i < this.currentDialogue.choices.size(); ++i) {
            if (this.field_146297_k.field_71466_p.func_78256_a(this.currentDialogue.choices.get((int)i).text) <= max) continue;
            max = this.field_146297_k.field_71466_p.func_78256_a(this.currentDialogue.choices.get((int)i).text);
        }
        return max;
    }

    private int getButtonX(int buttonNum) {
        return this.guiLeft;
    }

    private int getButtonY(int buttonNum) {
        return this.guiTop + 23 * buttonNum;
    }
}

