/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.choosePokemon;

import com.pixelmonmod.pixelmon.client.gui.GuiHelper;
import com.pixelmonmod.pixelmon.client.gui.GuiResources;
import com.pixelmonmod.pixelmon.client.gui.battles.GuiBattle;
import com.pixelmonmod.pixelmon.client.gui.battles.PixelmonInGui;
import com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.BattleScreen;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.SwitchPokemon;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Gender;
import com.pixelmonmod.pixelmon.enums.battle.BattleMode;
import com.pixelmonmod.pixelmon.items.ItemRevive;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;

public class ChoosePokemon
extends BattleScreen {
    PixelmonInGui selected = null;
    protected PixelmonInGui[] inBattle = new PixelmonInGui[6];
    protected PixelmonInGui[] inParty = new PixelmonInGui[6];
    protected String backText = "";

    public ChoosePokemon(GuiBattle parent) {
        super(parent, BattleMode.ChoosePokemon);
    }

    public ChoosePokemon(GuiBattle parent, BattleMode mode) {
        super(parent, mode);
    }

    @Override
    public void drawScreen(int width, int height, int mouseX, int mouseY) {
        Item item;
        this.fillParty();
        this.field_146297_k.field_71446_o.func_110577_a(GuiResources.choosePokemon);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiHelper.drawImageQuad(width / 2 - 128, height - 203, 256.0, 203.0f, 0.0, 0.0, 1.0, 0.79296875, this.field_73735_i);
        if (this.bm.mode == BattleMode.ApplyToPokemon) {
            this.func_73732_a(this.field_146297_k.field_71466_p, I18n.func_135052_a((String)"gui.choosepokemon.select", (Object[])new Object[0]), width / 2 - 40, height - 23, 0xFFFFFF);
        } else if (this.bm.mode == BattleMode.ChooseRelearnMove || this.bm.mode == BattleMode.ChooseTutor) {
            this.func_73732_a(this.field_146297_k.field_71466_p, I18n.func_135052_a((String)"gui.selectpokemon.message", (Object[])new Object[0]), width / 2 - 40, height - 23, 0xFFFFFF);
        } else {
            this.func_73732_a(this.field_146297_k.field_71466_p, I18n.func_135052_a((String)"gui.choosepokemon.sendout", (Object[])new Object[0]), width / 2 - 40, height - 23, 0xFFFFFF);
        }
        this.backText = this.getBackText();
        if (!"".equals(this.backText)) {
            if (mouseX > width / 2 + 63 && mouseX < width / 2 + 63 + 48 && mouseY > height - 27 && mouseY < height - 27 + 17 && !this.bm.isHealing) {
                this.field_146297_k.field_71446_o.func_110577_a(GuiResources.choosePokemon);
                GuiHelper.drawImageQuad(width / 2 + 63, height - 27, 48.0, 17.0f, 0.7734375, 0.8203125, 0.9609375, 0.88671875, this.field_73735_i);
            }
            this.func_73732_a(this.field_146297_k.field_71466_p, I18n.func_135052_a((String)this.backText, (Object[])new Object[0]), width / 2 + 87, height - 22, 0xFFFFFF);
        }
        PixelmonInGui p = this.inBattle[0] != null ? this.inBattle[0] : this.inParty[0];
        Item item2 = item = this.bm.itemToUse != null ? Item.func_150899_d((int)this.bm.itemToUse.id) : null;
        if (p != null) {
            GuiHelper.bindPokemonSprite(p, this.field_146297_k);
            GuiHelper.drawImageQuad(width / 2 - 121, height - 179, 24.0, 24.0f, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
            GuiBattle.drawHealthBar(width / 2 - 85, height - 135, 56, 9, p.health, p.maxHealth);
            this.field_146297_k.field_71446_o.func_110577_a(GuiResources.choosePokemon);
            GuiHelper.drawImageQuad(width / 2 - 95, height - 135, 61.0, 9.0f, 0.3359375, 0.9375, 0.57421875, 0.97265625, this.field_73735_i);
            this.func_73732_a(this.field_146297_k.field_71466_p, (int)p.health + "/" + p.maxHealth, width / 2 - 59, height - 123, 0xFFFFFF);
            String name = p.getDisplayName();
            this.func_73731_b(this.field_146297_k.field_71466_p, name, width / 2 - 90, height - 161, 0xFFFFFF);
            this.func_73731_b(this.field_146297_k.field_71466_p, I18n.func_135052_a((String)"gui.overlay1v1.lv", (Object[])new Object[0]) + p.level, width / 2 - 90, height - 148, 0xFFFFFF);
            float[] texturePair = p.getStatusTexturePos();
            if (texturePair[0] != -1.0f) {
                this.field_146297_k.field_71446_o.func_110577_a(GuiResources.status);
                GuiHelper.drawImageQuad(width / 2 - 117, height - 150, 24.0, 10.5f, texturePair[0] / 299.0f, texturePair[1] / 210.0f, (texturePair[0] + 147.0f) / 299.0f, (texturePair[1] + 68.0f) / 210.0f, this.field_73735_i);
            }
            this.field_146297_k.field_71446_o.func_110577_a(GuiResources.choosePokemon);
            if (p.getGender() == Gender.Male) {
                GuiHelper.drawImageQuad(width / 2 - 90 + this.field_146297_k.field_71466_p.func_78256_a(name), height - 161, 6.0, 9.0f, 0.125, 0.8125, 0.1484375, 0.84765625, this.field_73735_i);
            } else if (p.getGender() == Gender.Female) {
                GuiHelper.drawImageQuad(width / 2 - 90 + this.field_146297_k.field_71466_p.func_78256_a(name), height - 161, 6.0, 9.0f, 0.125, 0.8515625, 0.1484375, 0.88671875, this.field_73735_i);
            }
            if (this.bm.mode == BattleMode.ApplyToPokemon && !this.bm.isHealing && mouseX > width / 2 - 120 && mouseX < width / 2 - 21 && mouseY > height - 165 && mouseY < height - 113) {
                boolean valid = false;
                if (item instanceof ItemRevive) {
                    if (p.health <= 0.0f) {
                        valid = true;
                    }
                } else if (p.health > 0.0f) {
                    valid = true;
                }
                if (valid) {
                    this.field_146297_k.field_71446_o.func_110577_a(GuiResources.selectCurrentPokemon);
                    GuiHelper.drawImageQuad(width / 2 - 120, height - 165, 89.0, 52.0f, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
                }
            }
        }
        int inBattleIndex = 1;
        int inPartyIndex = this.inBattle[0] == null ? 1 : 0;
        for (int i = 0; i < 5; ++i) {
            PixelmonInGui pData = this.inBattle[inBattleIndex] != null ? this.inBattle[inBattleIndex++] : this.inParty[inPartyIndex++];
            int pos = i;
            if (pData == null) continue;
            GuiHelper.bindPokemonSprite(pData, this.field_146297_k);
            GuiHelper.drawImageQuad(width / 2 - 23, height - 192 + pos * 30, 24.0, 24.0f, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
            GuiBattle.drawHealthBar(width / 2 + 65, height - 192 + pos * 30, 56, 9, pData.health, pData.maxHealth);
            this.field_146297_k.field_71446_o.func_110577_a(GuiResources.choosePokemon);
            GuiHelper.drawImageQuad(width / 2 + 55, height - 192 + pos * 30, 61.0, 9.0f, 0.3359375, 0.9375, 0.57421875, 0.97265625, this.field_73735_i);
            this.func_73731_b(this.field_146297_k.field_71466_p, (int)pData.health + "/" + pData.maxHealth, width / 2 + 75, height - 180 + pos * 30, 0xFFFFFF);
            this.func_73731_b(this.field_146297_k.field_71466_p, pData.getDisplayName(), width / 2 + 5, height - 190 + pos * 30, 0xFFFFFF);
            this.func_73731_b(this.field_146297_k.field_71466_p, I18n.func_135052_a((String)"gui.overlay1v1.lv", (Object[])new Object[0]) + pData.level, width / 2 + 5, height - 176 + pos * 30, 0xFFFFFF);
            float[] texturePair = pData.getStatusTexturePos();
            if (texturePair[0] != -1.0f) {
                this.field_146297_k.field_71446_o.func_110577_a(GuiResources.status);
                GuiHelper.drawImageQuad(width / 2 + 48, height - 177 + pos * 30, 24.0, 10.5f, texturePair[0] / 299.0f, texturePair[1] / 210.0f, (texturePair[0] + 147.0f) / 299.0f, (texturePair[1] + 68.0f) / 210.0f, this.field_73735_i);
            }
            this.field_146297_k.field_71446_o.func_110577_a(GuiResources.choosePokemon);
            if (pData.getGender() == Gender.Male) {
                GuiHelper.drawImageQuad(width / 2 + 40, height - 176 + pos * 30, 6.0, 9.0f, 0.125, 0.8125, 0.1484375, 0.84765625, this.field_73735_i);
            } else if (pData.getGender() == Gender.Female) {
                GuiHelper.drawImageQuad(width / 2 + 40, height - 176 + pos * 30, 6.0, 9.0f, 0.125, 0.8515625, 0.1484375, 0.88671875, this.field_73735_i);
            }
            int xPos = width / 2 - 30;
            int yPos = height - 195 + pos * 30;
            boolean isCurrent = false;
            if (Arrays.asList(this.inBattle).contains(pData)) {
                isCurrent = true;
            }
            if ((!isCurrent || this.bm.mode != BattleMode.ApplyToPokemon) && isCurrent || mouseX <= xPos || mouseX >= xPos + 150 || mouseY <= yPos + 1 || mouseY >= yPos + 31 || this.bm.isHealing) continue;
            boolean valid = false;
            if (this.bm.mode == BattleMode.ApplyToPokemon && item instanceof ItemRevive) {
                if (pData.health <= 0.0f) {
                    valid = true;
                }
            } else if (pData.health > 0.0f && pData != this.selected) {
                valid = true;
            }
            if (!valid) continue;
            GuiHelper.drawImageQuad(xPos, yPos, 150.0, 32.0f, 0.16796875, 0.80078125, 0.7578125, 0.92578125, this.field_73735_i);
        }
    }

    @Override
    public void click(int width, int height, int mouseX, int mouseY) {
        if (mouseX > width / 2 + 63 && mouseX < width / 2 + 63 + 48 && mouseY > height - 27 && mouseY < height - 27 + 17) {
            this.clickBackButton();
        }
        if (this.bm.mode == BattleMode.MainMenu) {
            return;
        }
        int inBattleIndex = 1;
        int inPartyIndex = 0;
        for (int i = 0; i < 5; ++i) {
            PixelmonInGui pData;
            if (this.inBattle[inBattleIndex] != null) {
                pData = this.inBattle[inBattleIndex++];
            } else if (this.inParty[inPartyIndex] != null) {
                pData = this.inParty[inPartyIndex++];
            } else {
                return;
            }
            if (pData == null) continue;
            int xpos = width / 2 - 30;
            int ypos = height - 195 + i * 30;
            if (mouseX <= xpos || mouseX >= xpos + 150 || mouseY <= ypos + 1 || mouseY >= ypos + 31) continue;
            boolean canSelect = true;
            if (Arrays.asList(this.inBattle).contains(pData)) {
                canSelect = false;
            }
            if (pData == this.selected) {
                if (this.bm.selectedActions.isEmpty()) {
                    this.selected = null;
                } else {
                    canSelect = false;
                }
            }
            if (!canSelect) continue;
            this.selected = pData;
            if (!(pData.health > 0.0f)) continue;
            this.addSwitch(pData.pokemonUUID);
            this.selectedMove();
            return;
        }
    }

    protected void selectedMove() {
        this.bm.selectedMove();
    }

    public PixelmonInGui choosePokemonSlot(int width, int height, int mouseX, int mouseY) {
        if (mouseX > width / 2 + 63 && mouseX < width / 2 + 63 + 48 && mouseY > height - 27 && mouseY < height - 27 + 17) {
            Minecraft.func_71410_x().field_71439_g.func_71053_j();
            return null;
        }
        PixelmonInGui[] party = this.getParty();
        if (mouseX > width / 2 - 120 && mouseX < width / 2 - 21 && mouseY > height - 165 && mouseY < height - 113) {
            if (party[0] != null) {
                return party[0];
            }
        } else {
            for (int i = 0; i < 5; ++i) {
                PixelmonInGui pokemon = party[i + 1];
                if (pokemon == null) continue;
                int xpos = width / 2 - 30;
                int ypos = height - 195 + i * 30;
                if (mouseX <= xpos || mouseX >= xpos + 150 || mouseY <= ypos + 1 || mouseY >= ypos + 31) continue;
                return pokemon;
            }
        }
        return null;
    }

    protected PixelmonInGui[] getParty() {
        PixelmonInGui[] party = new PixelmonInGui[6];
        int arrayIndex = 0;
        for (PixelmonInGui data : this.inBattle) {
            if (data == null) break;
            if (arrayIndex >= 6) continue;
            party[arrayIndex++] = data;
        }
        for (PixelmonInGui data : this.inParty) {
            if (arrayIndex >= 6) continue;
            party[arrayIndex++] = data;
        }
        return party;
    }

    protected void fillParty() {
        this.inBattle = new PixelmonInGui[6];
        this.inParty = new PixelmonInGui[6];
        if (this.bm.teamPokemon != null) {
            int i = 0;
            for (UUID uuid : this.bm.teamPokemon) {
                Optional<PixelmonInGui> pixelmon = this.bm.fullOurPokemon.stream().filter(p -> p.pokemonUUID.equals(uuid)).findFirst();
                if (!pixelmon.isPresent()) continue;
                this.inBattle[i++] = pixelmon.get();
            }
        }
        List<PixelmonInGui> inBattleList = Arrays.asList(this.inBattle);
        int i = 0;
        for (PixelmonInGui d : this.bm.fullOurPokemon) {
            if (inBattleList.contains(d)) continue;
            this.inParty[i++] = d;
        }
    }

    protected String getBackText() {
        return "gui.battle.back";
    }

    protected void clickBackButton() {
        this.bm.mode = BattleMode.MainMenu;
    }

    protected void addSwitch(UUID newPokemonUUID) {
        this.bm.selectedActions.add(new SwitchPokemon(newPokemonUUID, this.bm.battleControllerIndex, this.bm.getCurrentPokemon().pokemonUUID, false));
    }
}

