/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.battles;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.battles.attacks.BattleMessageBase;
import com.pixelmonmod.pixelmon.battles.controller.participants.ParticipantType;
import com.pixelmonmod.pixelmon.battles.rules.BattleRules;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.client.camera.CameraMode;
import com.pixelmonmod.pixelmon.client.camera.CameraTargetEntity;
import com.pixelmonmod.pixelmon.client.camera.EntityCamera;
import com.pixelmonmod.pixelmon.client.camera.ICameraTarget;
import com.pixelmonmod.pixelmon.client.gui.GuiEvolve;
import com.pixelmonmod.pixelmon.client.gui.battles.AttackData;
import com.pixelmonmod.pixelmon.client.gui.battles.EvoInfo;
import com.pixelmonmod.pixelmon.client.gui.battles.GuiBattle;
import com.pixelmonmod.pixelmon.client.gui.battles.PixelmonInGui;
import com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.choosePokemon.EnforcedSwitch;
import com.pixelmonmod.pixelmon.client.gui.battles.timerTasks.AFKTask;
import com.pixelmonmod.pixelmon.client.storage.ClientStorageManager;
import com.pixelmonmod.pixelmon.comm.packetHandlers.LevelUp;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.ChooseAttack;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.Flee;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.ParticipantReady;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.SwitchPokemon;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.enums.EnumBossMode;
import com.pixelmonmod.pixelmon.enums.battle.BagSection;
import com.pixelmonmod.pixelmon.enums.battle.BattleMode;
import com.pixelmonmod.pixelmon.enums.battle.EnumBattleType;
import com.pixelmonmod.pixelmon.items.ItemData;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.client.GuiIngameForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;

public class ClientBattleManager {
    public int battleControllerIndex = -1;
    public BattleMode mode;
    public BagSection bagSection;
    public boolean battleEnded = true;
    public boolean isSpectating = false;
    private ArrayList<String> messageList = new ArrayList();
    public UUID[] teamPokemon;
    public PixelmonInGui[] displayedEnemyPokemon;
    public PixelmonInGui[] displayedOurPokemon;
    public PixelmonInGui[] displayedAllyPokemon;
    public List<PixelmonInGui> fullOurPokemon;
    public final ArrayList<BattleMessageBase> battleMessages = new ArrayList();
    public ArrayList<ItemData> bagStore = new ArrayList();
    public ArrayList<LevelUp> levelUpList = new ArrayList(6);
    public ArrayList<AttackData> newAttackList = new ArrayList();
    public boolean goBackToMainMenu;
    public int startIndex = 0;
    public ItemData itemToUse = null;
    public IMessage sendPacket;
    public BattleMode oldMode;
    public BattleMode yesNoOrigin;
    public List<EvoInfo> evolveList = new ArrayList<EvoInfo>(6);
    public boolean isHealing = false;
    public int healAmount = 0;
    public int selectedAttack = -1;
    public int currentPokemon = -1;
    public boolean[][] targetted = new boolean[2][];
    public boolean choosingPokemon;
    public ArrayList<IMessage> selectedActions = new ArrayList();
    public EnumBattleType battleType;
    public Queue<com.pixelmonmod.pixelmon.comm.packetHandlers.battles.EnforcedSwitch> enforcedSwitches = new LinkedList<com.pixelmonmod.pixelmon.comm.packetHandlers.battles.EnforcedSwitch>();
    public boolean afkOn;
    public boolean afkActive;
    public int afkActivate;
    public int afkTurn;
    public int afkTime;
    private Timer afkTimer;
    public boolean waitingText;
    public boolean megaEvolving;
    public UUID megaEvolution = null;
    public UUID ultraBurst = null;
    public boolean showZMoves = false;
    public boolean usedZMove = false;
    public BattleRules rules = new BattleRules();
    public boolean canSwitch = true;
    public boolean canFlee = true;
    public ParticipantType[][] battleSetup;
    public boolean healFinished = false;
    int ticksSincePicked = 0;
    public ArrayList<UUID> pokemonToChoose;
    public UUID spectatingUUID;
    private EntityPlayer spectating;
    private int thirdP = 0;

    public boolean isBattling() {
        return this.battleControllerIndex != -1 && !this.battleEnded && !this.isSpectating;
    }

    public void addMessage(String s) {
        this.messageList.add(s);
    }

    public String getNextMessage() {
        if (this.hasMoreMessages()) {
            return this.messageList.get(0);
        }
        return "";
    }

    public void removeMessage() {
        if (this.hasMoreMessages()) {
            this.messageList.remove(0);
        }
    }

    public boolean hasMoreMessages() {
        return !this.messageList.isEmpty();
    }

    public PixelmonInGui getCurrentPokemon() {
        if (this.currentPokemon != -1) {
            if (!this.isBattling() && ClientStorageManager.party.get(this.currentPokemon) != null) {
                return new PixelmonInGui(ClientStorageManager.party.get(this.currentPokemon));
            }
            if (this.teamPokemon != null) {
                if (this.currentPokemon < this.teamPokemon.length) {
                    for (PixelmonInGui pig : this.fullOurPokemon) {
                        if (!this.teamPokemon[this.currentPokemon].equals(pig.pokemonUUID)) continue;
                        return pig;
                    }
                }
            } else {
                return this.fullOurPokemon.get(this.currentPokemon);
            }
        }
        return null;
    }

    public EntityPixelmon getUserPokemon() {
        return this.getUserPokemon(CameraMode.Battle);
    }

    public EntityPixelmon getUserPokemon(CameraMode mode) {
        if (mode == CameraMode.Battle) {
            if ((this.currentPokemon != -1 || this.isSpectating) && this.teamPokemon != null && this.teamPokemon.length > 0) {
                if (this.currentPokemon == -1) {
                    this.currentPokemon = 0;
                }
                int pokemonIndex = Math.min(this.currentPokemon, this.teamPokemon.length - 1);
                return this.getEntity(this.teamPokemon[pokemonIndex]);
            }
        } else if (mode == CameraMode.Evolution) {
            return GuiEvolve.currentPokemon;
        }
        return null;
    }

    public EntityPixelmon getEntity(UUID uuid) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e != null) {
            List loadedEntityList = mc.field_71441_e.field_72996_f;
            for (int i = 0; i < loadedEntityList.size(); ++i) {
                EntityPixelmon pokemon;
                Entity e = (Entity)loadedEntityList.get(i);
                if (!(e instanceof EntityPixelmon) || !(pokemon = (EntityPixelmon)e).getPokemonData().getUUID().equals(uuid)) continue;
                return pokemon;
            }
        }
        return null;
    }

    public void clearMessages() {
        this.messageList.clear();
    }

    public boolean hasLevelUps() {
        return !this.levelUpList.isEmpty();
    }

    public boolean hasNewAttacks() {
        return !this.newAttackList.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startBattle(int battleControllerIndex, ParticipantType[][] battleSetup, int afkActivate, int afkTurn, BattleRules rules) {
        this.battleControllerIndex = battleControllerIndex;
        this.battleSetup = battleSetup;
        this.rules = rules;
        this.displayedOurPokemon = null;
        this.displayedEnemyPokemon = null;
        this.displayedAllyPokemon = null;
        this.fullOurPokemon = null;
        this.teamPokemon = null;
        this.targetted = new boolean[2][];
        this.mode = BattleMode.Waiting;
        this.clearMessages();
        this.canSwitch = true;
        this.canFlee = true;
        this.battleEnded = false;
        this.megaEvolution = null;
        this.ultraBurst = null;
        this.usedZMove = false;
        if (afkActivate == -1) {
            this.afkOn = false;
        } else {
            this.afkOn = true;
            this.afkActivate = afkActivate;
            this.afkTurn = afkTurn;
            this.afkActive = false;
            this.resetAFKTime();
        }
        ArrayList<BattleMessageBase> arrayList = this.battleMessages;
        synchronized (arrayList) {
            this.battleMessages.clear();
        }
    }

    public void startSpectate(EnumBattleType battleType) {
        ClientProxy.battleManager.isSpectating = true;
        ClientProxy.battleManager.battleType = battleType;
        this.spectating = null;
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_147108_a((GuiScreen)new GuiBattle());
    }

    public void endSpectate() {
        if (ClientProxy.battleManager.isSpectating) {
            ClientProxy.battleManager.isSpectating = false;
            ClientProxy.battleManager.battleEnded = true;
            this.spectating = null;
            this.spectatingUUID = null;
            this.resetViewEntity();
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && !this.battleEnded) {
            this.tick();
        }
    }

    private void tick() {
        ICameraTarget tar;
        Minecraft minecraft = Minecraft.func_71410_x();
        if (!(minecraft.field_71462_r instanceof GuiBattle) && minecraft.field_71439_g != null) {
            minecraft.func_147108_a((GuiScreen)new GuiBattle());
        }
        if (this.ticksSincePicked > 0) {
            --this.ticksSincePicked;
        }
        boolean doCameraTick = true;
        if (ClientProxy.camera != null && (tar = ClientProxy.camera.getTarget()) != null) {
            EntityPixelmon userPokemon = this.getUserPokemon();
            if (tar.getTargetData() == userPokemon && (userPokemon == null || userPokemon.field_70128_L || userPokemon.func_110143_aJ() <= 0.0f)) {
                this.setCameraToPlayer();
                doCameraTick = false;
            }
        }
        if (PixelmonConfig.useBattleCamera && doCameraTick && this.ticksSincePicked <= 0 && this.getUserPokemon() != null) {
            Entity viewEntity = minecraft.func_175606_aa();
            if (viewEntity instanceof EntityCamera && viewEntity != ClientProxy.camera) {
                minecraft.func_175607_a((Entity)ClientProxy.camera);
            }
            this.setCameraToPixelmon();
        }
    }

    public void restoreSettingsAndClose() {
        this.battleEnded = true;
        if (this.afkTimer != null) {
            this.afkTimer.cancel();
        }
        this.resetViewEntity();
        this.spectating = null;
        this.spectatingUUID = null;
        this.selectedActions.clear();
        this.enforcedSwitches.clear();
        EnforcedSwitch.failFlee = false;
        this.megaEvolution = null;
        this.ultraBurst = null;
        this.usedZMove = false;
    }

    public boolean canCatchOpponent() {
        for (int i = 0; i < this.battleSetup[1].length; ++i) {
            ParticipantType t = this.battleSetup[1][i];
            if (t != ParticipantType.WildPokemon || this.displayedEnemyPokemon[i].bossLevel != EnumBossMode.NotBoss.index || this.displayedEnemyPokemon[i].blockCapture) continue;
            return true;
        }
        return false;
    }

    public boolean canRunFromBattle() {
        for (int i = 0; i < this.battleSetup[1].length; ++i) {
            ParticipantType t = this.battleSetup[1][i];
            if (t != ParticipantType.WildPokemon) continue;
            return this.canFlee;
        }
        return !this.rules.hasClause("forfeit");
    }

    public boolean canForfeit() {
        for (int i = 0; i < this.battleSetup[1].length; ++i) {
            ParticipantType t = this.battleSetup[1][i];
            if (t == ParticipantType.WildPokemon) continue;
            return true;
        }
        return false;
    }

    public EntityPlayer getViewPlayer() {
        Minecraft minecraft = Minecraft.func_71410_x();
        if (this.isSpectating && this.spectatingUUID != null) {
            if (this.spectating == null) {
                this.spectating = minecraft.field_71441_e.func_152378_a(this.spectatingUUID);
            }
            if (this.spectating != null) {
                return this.spectating;
            }
        }
        return minecraft.field_71439_g;
    }

    public void startPicking(boolean canSwitch, boolean canFlee, ArrayList<UUID> pokemonToChoose) {
        this.setCameraToPlayer();
        this.ticksSincePicked = 50;
        if (!this.isSpectating) {
            this.canSwitch = canSwitch;
            this.canFlee = canFlee;
            this.oldMode = BattleMode.MainMenu;
            this.mode = BattleMode.MainMenu;
            this.pokemonToChoose = pokemonToChoose;
            for (int i = 0; i < this.teamPokemon.length; ++i) {
                UUID uuid = this.teamPokemon[i];
                if (!this.fullOurPokemon.stream().anyMatch(p -> p.pokemonUUID.equals(uuid)) || !this.hasTurn(uuid)) continue;
                this.currentPokemon = i;
                break;
            }
        }
    }

    private boolean hasTurn(UUID uuid) {
        for (UUID pokemonUUID : this.pokemonToChoose) {
            if (!pokemonUUID.equals(uuid)) continue;
            return true;
        }
        return false;
    }

    public void selectedMove() {
        this.selectedMove(false);
    }

    public void selectedMove(boolean isEnforcedSwitch) {
        this.afkActive = false;
        this.megaEvolving = false;
        this.showZMoves = false;
        if (!this.enforcedSwitches.isEmpty()) {
            this.enforcedSwitches.poll().processMessage();
            return;
        }
        if (!isEnforcedSwitch && this.teamPokemon.length > this.currentPokemon + 1 && this.teamPokemon.length > this.selectedActions.size()) {
            int prevCurrentPokemon = this.currentPokemon;
            for (int i = this.currentPokemon + 1; i < this.teamPokemon.length; ++i) {
                UUID uuid = this.teamPokemon[i];
                if (this.fullOurPokemon.stream().anyMatch(p -> p.pokemonUUID.equals(uuid))) {
                    if (!this.hasTurn(uuid)) continue;
                    this.currentPokemon = i;
                    break;
                }
                this.finishSelection();
                return;
            }
            if (prevCurrentPokemon == this.currentPokemon) {
                this.finishSelection();
                return;
            }
            this.mode = BattleMode.MainMenu;
        } else {
            this.finishSelection();
        }
    }

    public void afkSelectMove() {
        if (this.mode != BattleMode.Waiting) {
            if (this.mode == BattleMode.EnforcedSwitch) {
                ArrayList<PixelmonInGui> inBattle = new ArrayList<PixelmonInGui>(3);
                if (this.teamPokemon != null) {
                    for (UUID uuid : this.teamPokemon) {
                        for (PixelmonInGui pig : this.fullOurPokemon) {
                            if (!pig.pokemonUUID.equals(uuid)) continue;
                            inBattle.add(pig);
                        }
                    }
                    PixelmonInGui currentData = (PixelmonInGui)inBattle.get(this.currentPokemon % inBattle.size());
                    this.selectedActions.add(new SwitchPokemon(null, this.battleControllerIndex, currentData.pokemonUUID, true));
                }
            } else {
                for (int i = this.currentPokemon; i < this.teamPokemon.length; ++i) {
                    UUID uuid = this.teamPokemon[i];
                    if (!this.fullOurPokemon.stream().anyMatch(p -> p.pokemonUUID.equals(uuid)) || !this.hasTurn(uuid)) continue;
                    this.currentPokemon = i;
                    PixelmonInGui currentData = this.getCurrentPokemon();
                    Object action = currentData.health <= 0.0f ? new SwitchPokemon(null, this.battleControllerIndex, currentData.pokemonUUID, false) : new ChooseAttack(this.getCurrentPokemon().pokemonUUID, new boolean[0][0], -1, this.battleControllerIndex, this.megaEvolving);
                    this.megaEvolving = false;
                    this.showZMoves = false;
                    this.selectedActions.add((IMessage)action);
                }
            }
            this.finishSelection();
        }
    }

    public void finishSelection() {
        this.mode = BattleMode.Waiting;
        this.selectedActions.stream().filter(action -> action != null).forEach(arg_0 -> ((SimpleNetworkWrapper)Pixelmon.network).sendToServer(arg_0));
        this.selectedActions.clear();
    }

    public void setTeamPokemon(UUID[] pokemon) {
        this.teamPokemon = pokemon;
        this.targetted[0] = new boolean[pokemon.length];
        if (this.displayedOurPokemon == null) {
            ArrayList<PixelmonInGui> ourPokemon = new ArrayList<PixelmonInGui>();
            for (UUID uuid : pokemon) {
                for (PixelmonInGui pig : this.fullOurPokemon) {
                    if (!pig.pokemonUUID.equals(uuid)) continue;
                    ourPokemon.add(pig);
                }
            }
            this.displayedOurPokemon = ourPokemon.toArray(new PixelmonInGui[0]);
            for (PixelmonInGui pig : this.displayedOurPokemon) {
                pig.xPos = 120;
            }
        }
    }

    public void setTeamPokemon(PixelmonInGui[] data) {
        if (this.displayedOurPokemon != null) {
            for (PixelmonInGui replacement : data) {
                for (PixelmonInGui current : this.displayedOurPokemon) {
                    if (!replacement.pokemonUUID.equals(current.pokemonUUID)) continue;
                    replacement.health = current.health;
                }
            }
        }
        this.displayedOurPokemon = data;
        this.targetted[0] = new boolean[0];
        for (PixelmonInGui pig : this.displayedOurPokemon) {
            pig.xPos = 120;
        }
    }

    public void setOpponents(PixelmonInGui[] data) {
        if (this.displayedEnemyPokemon != null && data != null) {
            for (PixelmonInGui replacement : data) {
                for (PixelmonInGui current : this.displayedEnemyPokemon) {
                    if (!replacement.pokemonUUID.equals(current.pokemonUUID)) continue;
                    replacement.health = current.health;
                }
            }
        }
        this.displayedEnemyPokemon = data;
        this.targetted[1] = new boolean[this.displayedEnemyPokemon.length];
    }

    public void setTeamData(PixelmonInGui[] data) {
        if (this.displayedAllyPokemon != null && data != null) {
            for (PixelmonInGui replacement : data) {
                for (PixelmonInGui current : this.displayedAllyPokemon) {
                    if (!replacement.pokemonUUID.equals(current.pokemonUUID)) continue;
                    replacement.health = current.health;
                }
            }
        }
        this.displayedAllyPokemon = data;
        for (PixelmonInGui pig : this.displayedAllyPokemon) {
            pig.xPos = 120;
        }
    }

    public void setFullTeamData(PixelmonInGui[] data) {
        if (this.fullOurPokemon != null) {
            for (PixelmonInGui replacement : data) {
                for (PixelmonInGui current : this.fullOurPokemon) {
                    if (!replacement.pokemonUUID.equals(current.pokemonUUID)) continue;
                    replacement.health = current.health;
                }
            }
        }
        this.fullOurPokemon = Lists.newArrayList((Object[])data);
        for (PixelmonInGui pig : this.fullOurPokemon) {
            pig.xPos = 120;
        }
    }

    public PixelmonInGui getUncontrolledTeamPokemon(UUID uuid) {
        if (this.displayedAllyPokemon == null) {
            return null;
        }
        for (PixelmonInGui data : this.displayedAllyPokemon) {
            if (!uuid.equals(data.pokemonUUID)) continue;
            return data;
        }
        return null;
    }

    public PixelmonInGui getPokemon(UUID uuid) {
        if (this.displayedOurPokemon != null) {
            for (PixelmonInGui pixelmonInGui : this.displayedOurPokemon) {
                if (!uuid.equals(pixelmonInGui.pokemonUUID)) continue;
                return pixelmonInGui;
            }
        }
        if (this.displayedEnemyPokemon != null) {
            for (PixelmonInGui pixelmonInGui : this.displayedEnemyPokemon) {
                if (!uuid.equals(pixelmonInGui.pokemonUUID)) continue;
                return pixelmonInGui;
            }
        }
        if (this.displayedAllyPokemon != null) {
            for (PixelmonInGui pixelmonInGui : this.displayedAllyPokemon) {
                if (!uuid.equals(pixelmonInGui.pokemonUUID)) continue;
                return pixelmonInGui;
            }
        }
        if (this.fullOurPokemon != null) {
            for (PixelmonInGui pig : this.fullOurPokemon) {
                if (!uuid.equals(pig.pokemonUUID)) continue;
                return pig;
            }
        }
        return null;
    }

    public boolean isEnemyPokemon(PixelmonInGui pokemon) {
        for (PixelmonInGui p : this.displayedEnemyPokemon) {
            if (p != pokemon) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBattleMessage(BattleMessageBase message) {
        ArrayList<BattleMessageBase> arrayList = this.battleMessages;
        synchronized (arrayList) {
            this.battleMessages.add(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBattleMessage(BattleMessageBase message) {
        ArrayList<BattleMessageBase> arrayList = this.battleMessages;
        synchronized (arrayList) {
            this.battleMessages.remove(message);
            if (this.battleMessages.isEmpty()) {
                this.onClearedMessages();
            }
        }
    }

    public void onClearedMessages() {
        if (!this.isSpectating && !this.hasMoreMessages() && this.battleMessages.isEmpty()) {
            Pixelmon.network.sendToServer((IMessage)new ParticipantReady(this.battleControllerIndex, Minecraft.func_71410_x().field_71439_g.func_110124_au().toString()));
        }
    }

    public void setCameraToPixelmon() {
        if (ClientProxy.camera != null) {
            ICameraTarget tar = ClientProxy.camera.getTarget();
            if (tar != null) {
                EntityPixelmon userPokemon = this.getUserPokemon();
                if (tar.getTargetData() != userPokemon) {
                    if (tar instanceof CameraTargetEntity) {
                        tar.setTargetData((Object)userPokemon);
                    } else if (!PixelmonConfig.playerControlCamera) {
                        ClientProxy.camera.setTarget(new CameraTargetEntity((Entity)userPokemon));
                    }
                }
            } else if (!PixelmonConfig.playerControlCamera) {
                ClientProxy.camera.setTarget(new CameraTargetEntity((Entity)Minecraft.func_71410_x().field_71439_g));
            }
        }
    }

    public void setCameraToPlayer() {
        if (ClientProxy.camera != null) {
            ICameraTarget tar = ClientProxy.camera.getTarget();
            if (tar != null) {
                if (tar.getTargetData() != this.getViewPlayer()) {
                    if (tar instanceof CameraTargetEntity) {
                        tar.setTargetData(this.getViewPlayer());
                    } else if (!PixelmonConfig.playerControlCamera) {
                        ClientProxy.camera.setTarget(new CameraTargetEntity((Entity)this.getViewPlayer()));
                    }
                }
            } else if (ClientProxy.camera == null || this.getViewPlayer() == null) {
                Pixelmon.LOGGER.warn("Problem finding battle camera.");
            } else if (!PixelmonConfig.playerControlCamera) {
                ClientProxy.camera.setTarget(new CameraTargetEntity((Entity)this.getViewPlayer()));
            }
        }
    }

    public void setViewEntity(Entity entity) {
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_175607_a(entity);
        mc.field_71474_y.field_74319_N = true;
        this.thirdP = mc.field_71474_y.field_74320_O;
        mc.field_71474_y.field_74320_O = 0;
        GuiIngameForge.renderHotbar = false;
        GuiIngameForge.renderCrosshairs = false;
        GuiIngameForge.renderExperiance = false;
        GuiIngameForge.renderAir = false;
        GuiIngameForge.renderHealth = false;
        GuiIngameForge.renderFood = false;
        GuiIngameForge.renderArmor = false;
    }

    public Entity getViewEntity() {
        return Minecraft.func_71410_x().func_175606_aa();
    }

    public void resetViewEntity() {
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_175607_a((Entity)mc.field_71439_g);
        GuiIngameForge.renderHotbar = true;
        GuiIngameForge.renderCrosshairs = true;
        GuiIngameForge.renderExperiance = true;
        GuiIngameForge.renderAir = true;
        GuiIngameForge.renderHealth = true;
        GuiIngameForge.renderFood = true;
        GuiIngameForge.renderArmor = true;
        mc.field_71474_y.field_74319_N = false;
        mc.field_71474_y.field_74320_O = this.thirdP;
        if (ClientProxy.camera != null) {
            ClientProxy.camera.func_70106_y();
        }
        ClientProxy.camera = null;
    }

    public void resetAFKTime() {
        this.setAFKTimer(this.afkActive ? this.afkTurn : this.afkActivate);
    }

    private void setAFKTimer(int time) {
        this.afkTime = time;
        if (this.afkTimer != null) {
            this.afkTimer.cancel();
        }
        this.afkTimer = new Timer();
        this.afkTimer.scheduleAtFixedRate((TimerTask)new AFKTask(this), 1000L, 1000L);
    }

    public void setTeamSelectTime() {
        if (this.rules.teamSelectTime > 0) {
            this.afkOn = true;
            this.setAFKTimer(this.rules.teamSelectTime);
        } else {
            this.afkOn = false;
        }
    }

    public void selectRunAction(UUID pokemonUUID) {
        if (this.canForfeit()) {
            this.oldMode = this.mode;
            this.mode = BattleMode.YesNoForfeit;
        } else {
            Pixelmon.network.sendToServer((IMessage)new Flee(pokemonUUID));
            this.mode = BattleMode.Waiting;
        }
    }

    public void checkClearedMessages() {
        if (!(this.hasMoreMessages() || this.mode != BattleMode.Waiting && this.mode != BattleMode.MainMenu || this.choosingPokemon || this.hasLevelUps())) {
            this.onClearedMessages();
            if (this.afkOn) {
                this.resetAFKTime();
            }
        }
    }

    public boolean canMegaEvolve() {
        if (this.megaEvolution != null) {
            return false;
        }
        for (IMessage message : this.selectedActions) {
            if (!(message instanceof ChooseAttack)) continue;
            ChooseAttack attackMessage = (ChooseAttack)message;
            if (!attackMessage.megaEvolving) continue;
            return false;
        }
        return true;
    }

    public boolean canUltraBurst() {
        return this.ultraBurst == null;
    }

    public boolean canUseZMove() {
        return !this.usedZMove;
    }
}

