/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.DamageTypeEnum;
import com.pixelmonmod.pixelmon.battles.controller.BattleControllerBase;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.battles.status.Weather;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.AbilityBase;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.MagicGuard;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.Overcoat;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.SandForce;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.SandRush;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.SandVeil;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.StatsType;
import com.pixelmonmod.pixelmon.enums.EnumType;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import java.util.List;

public class Sandstorm
extends Weather {
    public Sandstorm() {
        this(5);
    }

    public Sandstorm(int turnsToGo) {
        super(StatusType.Sandstorm, turnsToGo, EnumHeldItems.smoothRock, "pixelmon.effect.sandstorm", "pixelmon.status.sandstormrage", "pixelmon.status.sandstormsubside", false);
    }

    @Override
    protected Weather getNewInstance(int turns) {
        return new Sandstorm(turns);
    }

    @Override
    public void applyRepeatedEffect(BattleControllerBase bc) {
        for (PixelmonWrapper p : bc.getDefaultTurnOrder()) {
            if (this.isImmune(p)) continue;
            p.bc.sendToAll("pixelmon.status.buffetedbysandstorm", p.getNickname());
            p.doBattleDamage(p, p.getPercentMaxHealth(6.25f), DamageTypeEnum.WEATHER);
        }
    }

    @Override
    public boolean isImmune(PixelmonWrapper p) {
        AbilityBase ability = p.getBattleAbility();
        return p.hasType(EnumType.Ground, EnumType.Rock, EnumType.Steel) || p.isFainted() || ability instanceof MagicGuard || ability instanceof Overcoat || ability instanceof SandForce || ability instanceof SandRush || ability instanceof SandVeil || p.getUsableHeldItem().getHeldItemType() == EnumHeldItems.safetyGoggles;
    }

    @Override
    public int[] modifyStats(PixelmonWrapper user, int[] stats) {
        if (user.hasType(EnumType.Rock)) {
            int n = StatsType.SpecialDefence.getStatIndex();
            stats[n] = (int)((double)stats[n] * 1.5);
        }
        return stats;
    }

    @Override
    protected int countBenefits(PixelmonWrapper user, PixelmonWrapper target) {
        List<Attack> moveset;
        int benefits = 0;
        if (!this.isImmune(target)) {
            --benefits;
        } else if (target.hasType(EnumType.Rock)) {
            ++benefits;
        }
        AbilityBase ability = target.getBattleAbility();
        if (ability instanceof SandForce || ability instanceof SandRush || ability instanceof SandVeil) {
            ++benefits;
        }
        if (Attack.hasAttack(moveset = user.getBattleAI().getMoveset(target), "Weather Ball")) {
            ++benefits;
        }
        if (Attack.hasAttack(moveset, "SolarBeam")) {
            --benefits;
        }
        if (Attack.hasAttack(moveset, "Moonlight", "Morning Sun", "Synthesis")) {
            --benefits;
        }
        return benefits;
    }
}

