/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.DamageTypeEnum;
import com.pixelmonmod.pixelmon.battles.attacks.EffectBase;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.Feint;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.KingsShield;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.battles.status.Vanish;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import com.pixelmonmod.pixelmon.enums.battle.AttackCategory;
import com.pixelmonmod.pixelmon.enums.forms.EnumAegislash;

public abstract class ProtectVariation
extends StatusBase {
    public ProtectVariation(StatusType type) {
        super(type);
    }

    @Override
    public void applyEffect(PixelmonWrapper user, PixelmonWrapper target) {
        if (user.bc.simulateMode) {
            return;
        }
        if (this instanceof KingsShield && user.getSpecies() == EnumSpecies.Aegislash && user.getForm() == EnumAegislash.BLADE.getForm()) {
            user.setForm(EnumAegislash.SHIELD.ordinal());
            user.bc.modifyStats(user);
            user.bc.sendToAll("pixelmon.abilities.stancechange.shield", user.getNickname());
        }
        float successChance = 1.0f / (float)Math.pow(3.0, user.protectsInARow);
        boolean successful = true;
        if (this.canFail()) {
            successful = RandomHelper.getRandomChance(successChance);
        }
        boolean bl = successful = successful && !user.bc.isLastMover() && this.addStatus(user);
        if (successful) {
            if (user.protectsInARow < 6) {
                ++user.protectsInARow;
            }
            this.displayMessage(user);
        } else {
            user.protectsInARow = 0;
            user.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
        }
    }

    @Override
    public boolean stopsIncomingAttack(PixelmonWrapper pokemon, PixelmonWrapper user) {
        if (user.attack.getMove().getTargetingInfo().hitsAll && user.attack.getMove().getTargetingInfo().hitsSelf) {
            return false;
        }
        if (!pokemon.getTeamPokemon().contains(user)) {
            for (EffectBase e : user.attack.getMove().effects) {
                if (!(e instanceof Vanish) && !(e instanceof Feint)) continue;
                return false;
            }
        }
        return !user.usingZ || user.attack.getAttackCategory() == AttackCategory.STATUS;
    }

    @Override
    public int modifyDamageIncludeFixed(int damage, PixelmonWrapper user, PixelmonWrapper target, Attack a, DamageTypeEnum damageType) {
        if (user != target && user.usingZ && a.getAttackCategory() != AttackCategory.STATUS) {
            return (int)Math.ceil((float)damage / 4.0f);
        }
        return damage;
    }

    protected abstract boolean addStatus(PixelmonWrapper var1);

    protected abstract void displayMessage(PixelmonWrapper var1);

    protected boolean canFail() {
        return true;
    }
}

