/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.StatsEffect;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.StatsType;
import java.util.ArrayList;

public class Minimize
extends StatusBase {
    private static final transient String[] squashMoves = new String[]{"Body Slam", "Dragon Rush", "Flying Press", "Heat Crash", "Steamroller", "Stomp", "Heavy Slam", "Malicious Moonsault"};

    public Minimize() {
        super(StatusType.Minimize);
    }

    @Override
    public void applyEffect(PixelmonWrapper user, PixelmonWrapper target) {
        if (user.getBattleStats().modifyStat(2, StatsType.Evasion) && !user.hasStatus(StatusType.Minimize)) {
            user.addStatus(new Minimize(), user);
        }
    }

    @Override
    public int[] modifyPowerAndAccuracyTarget(int power, int accuracy, PixelmonWrapper user, PixelmonWrapper target, Attack a) {
        if (a.isAttack(squashMoves)) {
            power *= 2;
            accuracy = -1;
        }
        return new int[]{power, accuracy};
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, ArrayList<MoveChoice> userChoices, ArrayList<MoveChoice> bestUserChoices, ArrayList<MoveChoice> opponentChoices, ArrayList<MoveChoice> bestOpponentChoices) {
        if (MoveChoice.hasMove(opponentChoices, squashMoves)) {
            return;
        }
        StatsEffect statsEffect = new StatsEffect(StatsType.Evasion, 2, true);
        statsEffect.weightEffect(pw, userChoice, userChoices, bestUserChoices, opponentChoices, bestOpponentChoices);
    }
}

