/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.AbilityBase;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.Steadfast;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.StatsType;
import java.util.ArrayList;

public class Flinch
extends StatusBase {
    public Flinch() {
        super(StatusType.Flinch);
    }

    @Override
    public void applyEffect(PixelmonWrapper user, PixelmonWrapper target) {
        if (this.checkChance()) {
            Flinch.flinch(user, target);
        }
    }

    public static void flinch(PixelmonWrapper user, PixelmonWrapper target) {
        if (!target.hasStatus(StatusType.Flinch) && target.bc != null && target.bc.battleLog.getActionForPokemon(target.bc.battleTurn, target) == null && target.attack != null) {
            target.addStatus(new Flinch(), user);
        }
    }

    @Override
    public void applyRepeatedEffect(PixelmonWrapper pw) {
        pw.removeStatus(this);
    }

    @Override
    public boolean canAttackThisTurn(PixelmonWrapper user, Attack a) {
        user.bc.sendToAll("battlecontroller.flinched", user.getNickname());
        user.removeStatus(this);
        AbilityBase ability = user.getBattleAbility();
        if (ability instanceof Steadfast) {
            ability.sendActivatedMessage(user);
            user.getBattleStats().modifyStat(1, StatsType.Speed);
        }
        return false;
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, ArrayList<MoveChoice> userChoices, ArrayList<MoveChoice> bestUserChoices, ArrayList<MoveChoice> opponentChoices, ArrayList<MoveChoice> bestOpponentChoices) {
        float chance = this.getChance();
        if (userChoice.hitsAlly()) {
            return;
        }
        for (PixelmonWrapper target : userChoice.targets) {
            if (MoveChoice.canOutspeed(bestOpponentChoices, pw, userChoice.createList()) || !target.addStatus(new Flinch(), pw)) continue;
            if (chance == 100.0f) {
                userChoice.raiseWeight(chance);
                continue;
            }
            if (chance >= 50.0f) {
                userChoice.raiseWeight(chance / 2.0f);
                continue;
            }
            userChoice.raiseWeight(chance / 100.0f);
        }
    }
}

